/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationTypeBase
implements ConfigurationType {
    private final String myId;
    private final String myDisplayName;
    private final String myDescription;
    private final Icon myIcon;
    private ConfigurationFactory[] myFactories;

    protected ConfigurationTypeBase(@NotNull String id, String displayName, String description, Icon icon) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/configurations/ConfigurationTypeBase.<init> must not be null");
        }
        this.myId = id;
        this.myDisplayName = displayName;
        this.myDescription = description;
        this.myIcon = icon;
        this.myFactories = new ConfigurationFactory[0];
    }

    protected void addFactory(ConfigurationFactory factory) {
        ArrayList<ConfigurationFactory> newFactories = new ArrayList<ConfigurationFactory>();
        Collections.addAll(newFactories, this.myFactories);
        newFactories.add(factory);
        this.myFactories = newFactories.toArray(new ConfigurationFactory[newFactories.size()]);
    }

    @Override
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    public String getConfigurationTypeDescription() {
        return this.myDescription;
    }

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/configurations/ConfigurationTypeBase.getId must not return null");
        }
        return string;
    }

    @Override
    public ConfigurationFactory[] getConfigurationFactories() {
        return this.myFactories;
    }
}

