/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import org.jetbrains.annotations.NotNull;

public abstract class FacetModificationTrackingService {
    public static FacetModificationTrackingService getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/FacetModificationTrackingService.getInstance must not be null");
        }
        return ModuleServiceManager.getService(module, FacetModificationTrackingService.class);
    }

    public static FacetModificationTrackingService getInstance(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/FacetModificationTrackingService.getInstance must not be null");
        }
        return ModuleServiceManager.getService(facet.getModule(), FacetModificationTrackingService.class);
    }

    @NotNull
    public abstract ModificationTracker getFacetModificationTracker(@NotNull Facet var1);

    public abstract void incFacetModificationTracker(@NotNull Facet var1);

    public abstract <T extends Facet> void addModificationTrackerListener(T var1, ModificationTrackerListener<? super T> var2, Disposable var3);

    public abstract void removeModificationTrackerListener(Facet var1, ModificationTrackerListener<?> var2);
}

