/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractTreeBuilder
implements Disposable {
    private AbstractTreeUi myUi;
    private static final String TREE_BUILDER = "TreeBuilder";
    public static final boolean DEFAULT_UPDATE_INACTIVE = true;

    public AbstractTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator) {
        this(tree, treeModel, treeStructure, comparator, true);
    }

    public AbstractTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator, boolean updateIfInactive) {
        this.init(tree, treeModel, treeStructure, comparator, updateIfInactive);
    }

    protected AbstractTreeBuilder() {
    }

    protected void init(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator, boolean updateIfInactive) {
        tree.putClientProperty(TREE_BUILDER, new WeakReference<AbstractTreeBuilder>(this));
        this.myUi = this.createUi();
        this.getUi().init(this, tree, treeModel, treeStructure, comparator, updateIfInactive);
        this.setPassthroughMode(this.isUnitTestingMode());
    }

    protected AbstractTreeUi createUi() {
        return new AbstractTreeUi();
    }

    public final void select(Object element) {
        this.getUi().userSelect(new Object[]{element}, null, false, true);
    }

    public final void select(Object element, @Nullable Runnable onDone) {
        this.getUi().userSelect(new Object[]{element}, new UserRunnable(onDone), false, true);
    }

    public final void select(Object element, @Nullable Runnable onDone, boolean addToSelection) {
        this.getUi().userSelect(new Object[]{element}, new UserRunnable(onDone), addToSelection, true);
    }

    public final void select(Object[] elements, @Nullable Runnable onDone) {
        this.getUi().userSelect(elements, new UserRunnable(onDone), false, true);
    }

    public final void select(Object[] elements, @Nullable Runnable onDone, boolean addToSelection) {
        this.getUi().userSelect(elements, new UserRunnable(onDone), addToSelection, true);
    }

    public final void expand(Object element, @Nullable Runnable onDone) {
        this.getUi().expand(element, (Runnable)new UserRunnable(onDone));
    }

    public final void expand(Object[] element, @Nullable Runnable onDone) {
        this.getUi().expand(element, (Runnable)new UserRunnable(onDone));
    }

    public final void collapseChildren(Object element, @Nullable Runnable onDone) {
        this.getUi().collapseChildren(element, new UserRunnable(onDone));
    }

    protected AbstractTreeNode createSearchingTreeNodeWrapper() {
        return new AbstractTreeNodeWrapper();
    }

    public final AbstractTreeBuilder setClearOnHideDelay(long clearOnHideDelay) {
        this.getUi().setClearOnHideDelay(clearOnHideDelay);
        return this;
    }

    protected AbstractTreeUpdater createUpdater() {
        AbstractTreeUpdater updater = new AbstractTreeUpdater(this);
        updater.setModalityStateComponent(MergingUpdateQueue.ANY_COMPONENT);
        return updater;
    }

    protected final AbstractTreeUpdater getUpdater() {
        return this.getUi().getUpdater();
    }

    public final boolean addSubtreeToUpdateByElement(Object element) {
        return this.getUpdater().addSubtreeToUpdateByElement(element);
    }

    public final void addSubtreeToUpdate(DefaultMutableTreeNode node) {
        this.getUi().addSubtreeToUpdate(node);
    }

    public final void addSubtreeToUpdate(DefaultMutableTreeNode node, Runnable afterUpdate) {
        this.getUi().addSubtreeToUpdate(node, afterUpdate);
    }

    public final DefaultMutableTreeNode getRootNode() {
        return this.getUi().getRootNode();
    }

    public final void setNodeDescriptorComparator(Comparator<NodeDescriptor> nodeDescriptorComparator) {
        this.getUi().setNodeDescriptorComparator(nodeDescriptorComparator);
    }

    protected Object getTreeStructureElement(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getElement();
    }

    protected void updateNode(DefaultMutableTreeNode node) {
        this.getUi().doUpdateNode(node);
    }

    protected boolean validateNode(Object child) {
        return true;
    }

    protected boolean isDisposeOnCollapsing(NodeDescriptor nodeDescriptor) {
        return true;
    }

    public final JTree getTree() {
        return this.getUi().getTree();
    }

    public final AbstractTreeStructure getTreeStructure() {
        return this.getUi().getTreeStructure();
    }

    public final void setTreeStructure(AbstractTreeStructure structure) {
        this.getUi().setTreeStructure(structure);
    }

    public void updateFromRoot() {
        this.queueUpdate();
    }

    protected ActionCallback updateFromRootCB() {
        return this.queueUpdate();
    }

    public void initRootNode() {
        this.getUi().initRootNode();
    }

    public final ActionCallback queueUpdate() {
        return this.queueUpdateFrom(this.getTreeStructure().getRootElement(), true);
    }

    public final ActionCallback queueUpdateFrom(Object element, boolean forceResort) {
        if (forceResort) {
            this.getUi().incComparatorStamp();
        }
        return this.getUi().queueUpdate(element);
    }

    public void buildNodeForElement(Object element) {
        this.getUi().buildNodeForElement(element);
    }

    @Nullable
    public DefaultMutableTreeNode getNodeForElement(Object element) {
        return this.getUi().getNodeForElement(element, false);
    }

    public void cleanUp() {
        this.getUi().doCleanUp();
    }

    @Nullable
    protected ProgressIndicator createProgressIndicator() {
        return null;
    }

    protected void expandNodeChildren(DefaultMutableTreeNode node) {
        this.getUi().doExpandNodeChildren(node);
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return this.getTreeStructure().getRootElement() == this.getTreeStructureElement(nodeDescriptor);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        return false;
    }

    protected boolean isSmartExpand() {
        return true;
    }

    public final boolean isDisposed() {
        return this.getUi() == null || this.getUi().isReleaseRequested();
    }

    public final void updateSubtree(DefaultMutableTreeNode node) {
        this.getUi().updateSubtree(node, true);
    }

    public final boolean wasRootNodeInitialized() {
        return this.getUi().wasRootNodeInitialized();
    }

    public final boolean isNodeBeingBuilt(TreePath path) {
        return this.getUi().isNodeBeingBuilt(path);
    }

    public final void buildNodeForPath(Object[] path) {
        this.getUi().buildNodeForPath(path);
    }

    public final DefaultMutableTreeNode getNodeForPath(Object[] path) {
        return this.getUi().getNodeForPath(path);
    }

    protected Object findNodeByElement(Object element) {
        return this.getUi().findNodeByElement(element);
    }

    public static boolean isLoadingNode(DefaultMutableTreeNode node) {
        return AbstractTreeUi.isLoadingNode(node);
    }

    public boolean isChildrenResortingNeeded(NodeDescriptor descriptor) {
        return true;
    }

    protected void runOnYeildingDone(Runnable onDone) {
        if (this.myUi.isPassthroughMode()) {
            onDone.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)onDone);
        }
    }

    protected void yield(Runnable runnable) {
        if (this.myUi.isPassthroughMode()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public boolean isToYieldUpdateFor(DefaultMutableTreeNode node) {
        return true;
    }

    public boolean isToEnsureSelectionOnFocusGained() {
        return true;
    }

    protected void runBackgroundLoading(final Runnable runnable) {
        if (this.isDisposed()) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            app.runReadAction(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
        } else {
            runnable.run();
        }
    }

    protected void updateAfterLoadedInBackground(Runnable runnable) {
        if (this.myUi.isPassthroughMode()) {
            runnable.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        }
    }

    public final ActionCallback getIntialized() {
        return this.myUi.getInitialized();
    }

    public final ActionCallback getReady(Object requestor) {
        return this.myUi.getReady(requestor);
    }

    protected void sortChildren(Comparator<TreeNode> nodeComparator, DefaultMutableTreeNode node, ArrayList<TreeNode> children) {
        Collections.sort(children, nodeComparator);
    }

    public void setPassthroughMode(boolean passthrough) {
        this.myUi.setPassthroughMode(passthrough);
    }

    public void expandAll(@Nullable Runnable onDone) {
        this.getUi().expandAll(onDone);
    }

    public ActionCallback cancelUpdate() {
        return this.getUi().cancelUpdate();
    }

    public ActionCallback batch(Progressive progressive) {
        return this.getUi().batch(progressive);
    }

    public AsyncResult<Object> revalidateElement(Object element) {
        return this.getTreeStructure().revalidateElement(element);
    }

    public final AbstractTreeUi getUi() {
        return this.myUi;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.myUi.requestRelease();
    }

    void releaseUi() {
        this.myUi = null;
    }

    protected boolean updateNodeDescriptor(NodeDescriptor descriptor) {
        return this.getUi().doUpdateNodeDescriptor(descriptor);
    }

    public final DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.getTree().getModel();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Set<Object> getSelectedElements() {
        Set<Object> set;
        if (this.isDisposed()) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/AbstractTreeBuilder.getSelectedElements must not return null");
            return set;
        }
        set = this.getUi().getSelectedElements();
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/AbstractTreeBuilder.getSelectedElements must not return null");
    }

    @NotNull
    public final <T> Set<T> getSelectedElements(Class<T> elementClass) {
        HashSet result = new HashSet();
        for (Object o : this.getSelectedElements()) {
            Object each = this.transformElement(o);
            if (!elementClass.isInstance(each)) continue;
            result.add(each);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/AbstractTreeBuilder.getSelectedElements must not return null");
        }
        return hashSet;
    }

    protected Object transformElement(Object object) {
        return object;
    }

    public final void setCanYieldUpdate(boolean yield) {
        this.getUi().setCanYield(yield);
    }

    @Nullable
    public static AbstractTreeBuilder getBuilderFor(JTree tree) {
        WeakReference ref = (WeakReference)tree.getClientProperty(TREE_BUILDER);
        return ref != null ? (AbstractTreeBuilder)ref.get() : null;
    }

    @Nullable
    public final <T> Object accept(Class nodeClass, TreeVisitor<T> visitor) {
        return this.accept(nodeClass, this.getTreeStructure().getRootElement(), visitor);
    }

    @Nullable
    private <T> Object accept(Class nodeClass, Object element, TreeVisitor<T> visitor) {
        Object[] children;
        if (element == null) {
            return null;
        }
        if (nodeClass.isAssignableFrom(element.getClass()) && visitor.visit(element)) {
            return element;
        }
        for (Object each : children = this.getTreeStructure().getChildElements(element)) {
            Object childObject = this.accept(nodeClass, each, visitor);
            if (childObject == null) continue;
            return childObject;
        }
        return null;
    }

    public <T> boolean select(Class nodeClass, TreeVisitor<T> visitor, @Nullable Runnable onDone, boolean addToSelection) {
        Object element = this.accept(nodeClass, visitor);
        if (element != null) {
            this.select(element, onDone, addToSelection);
            return true;
        }
        return false;
    }

    public void scrollSelectionToVisible(@Nullable Runnable onDone, boolean shouldBeCentered) {
        this.myUi.scrollSelectionToVisible(onDone, shouldBeCentered);
    }

    protected boolean isUnitTestingMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    public static boolean isToPaintSelection(JTree tree) {
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
        return builder != null && builder.getUi() != null ? builder.getUi().isToPaintSelection() : true;
    }

    class UserRunnable
    implements Runnable {
        private Runnable myRunnable;

        public UserRunnable(Runnable runnable) {
            this.myRunnable = runnable;
        }

        @Override
        public void run() {
            if (this.myRunnable != null) {
                AbstractTreeUi ui = AbstractTreeBuilder.this.getUi();
                if (ui != null) {
                    ui.executeUserRunnable(this.myRunnable);
                } else {
                    this.myRunnable.run();
                }
            }
        }
    }

    public static class AbstractTreeNodeWrapper
    extends AbstractTreeNode<Object> {
        public AbstractTreeNodeWrapper() {
            super((Project)null, null);
        }

        @Override
        @NotNull
        public Collection<AbstractTreeNode> getChildren() {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/AbstractTreeBuilder$AbstractTreeNodeWrapper.getChildren must not return null");
            }
            return list;
        }

        @Override
        public void update(PresentationData presentation) {
        }
    }
}

