/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressFunComponentProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressManager {
    private static final ProgressManager ourInstance = ServiceManager.getService(ProgressManager.class);
    protected static boolean ourNeedToCheckCancel = false;

    public static ProgressManager getInstance() {
        return ourInstance;
    }

    public abstract boolean hasProgressIndicator();

    public abstract boolean hasModalProgressIndicator();

    public abstract boolean hasUnsafeProgressIndicator();

    public abstract void runProcess(Runnable var1, ProgressIndicator var2) throws ProcessCanceledException;

    public abstract ProgressIndicator getProgressIndicator();

    public static void checkCanceled() throws ProcessCanceledException {
        if (ourNeedToCheckCancel) {
            ProgressManager.getInstance().doCheckCanceled();
            ourNeedToCheckCancel = false;
        }
    }

    protected abstract void doCheckCanceled() throws ProcessCanceledException;

    @Deprecated
    public abstract void registerFunComponentProvider(ProgressFunComponentProvider var1);

    @Deprecated
    public abstract void removeFunComponentProvider(ProgressFunComponentProvider var1);

    public abstract JComponent getProvidedFunComponent(Project var1, @NonNls String var2);

    public abstract void executeNonCancelableSection(Runnable var1);

    public abstract NonCancelableSection startNonCancelableSection();

    public abstract void setCancelButtonText(String var1);

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @Nls String var2, boolean var3, Project var4);

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @Nls String var2, boolean var3, Project var4, JComponent var5);

    public abstract void runProcessWithProgressAsynchronously(@NotNull Project var1, @NotNull @Nls String var2, @NotNull Runnable var3, @Nullable Runnable var4, @Nullable Runnable var5);

    public abstract void runProcessWithProgressAsynchronously(@NotNull Project var1, @NotNull @Nls String var2, @NotNull Runnable var3, @Nullable Runnable var4, @Nullable Runnable var5, @NotNull PerformInBackgroundOption var6);

    public abstract void run(@NotNull Task var1);
}

