/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="VcsManagerConfiguration", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public final class VcsConfiguration
implements PersistentStateComponent<Element>,
ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.VcsConfiguration");
    @NonNls
    private static final String VALUE_ATTR = "value";
    @NonNls
    private static final String CONFIRM_MOVE_TO_FAILED_COMMIT_ELEMENT = "confirmMoveToFailedCommit";
    @NonNls
    private static final String CONFIRM_REMOVE_EMPTY_CHANGELIST_ELEMENT = "confirmRemoveEmptyChangelist";
    private Project myProject;
    public boolean OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT = true;
    public boolean CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT = true;
    public boolean PERFORM_UPDATE_IN_BACKGROUND = true;
    public boolean PERFORM_COMMIT_IN_BACKGROUND = true;
    public boolean PERFORM_EDIT_IN_BACKGROUND = true;
    public boolean PERFORM_CHECKOUT_IN_BACKGROUND = true;
    public boolean PERFORM_ADD_REMOVE_IN_BACKGROUND = true;
    public boolean PERFORM_ROLLBACK_IN_BACKGROUND = false;
    public volatile boolean CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND = false;
    public VcsShowConfirmationOption.Value MOVE_TO_FAILED_COMMIT_CHANGELIST = VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    public VcsShowConfirmationOption.Value REMOVE_EMPTY_INACTIVE_CHANGELISTS = VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    public boolean ENABLE_BACKGROUND_PROCESSES = false;
    public int CHANGED_ON_SERVER_INTERVAL = 60;
    public boolean FORCE_NON_EMPTY_COMMENT = false;
    private final ArrayList<String> myLastCommitMessages = new ArrayList();
    public String LAST_COMMIT_MESSAGE = null;
    public boolean MAKE_NEW_CHANGELIST_ACTIVE = true;
    public boolean OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT = false;
    public boolean CHECK_FILES_UP_TO_DATE_BEFORE_COMMIT = false;
    public boolean REFORMAT_BEFORE_PROJECT_COMMIT = false;
    public boolean REFORMAT_BEFORE_FILE_COMMIT = false;
    public float FILE_HISTORY_DIALOG_COMMENTS_SPLITTER_PROPORTION = 0.8f;
    public float FILE_HISTORY_DIALOG_SPLITTER_PROPORTION = 0.5f;
    public String ACTIVE_VCS_NAME;
    public boolean UPDATE_GROUP_BY_PACKAGES = false;
    public boolean UPDATE_GROUP_BY_CHANGELIST = false;
    public boolean SHOW_FILE_HISTORY_AS_TREE = false;
    public float FILE_HISTORY_SPLITTER_PROPORTION = 0.6f;
    private static final int MAX_STORED_MESSAGES = 25;
    @NonNls
    private static final String MESSAGE_ELEMENT_NAME = "MESSAGE";
    private final PerformInBackgroundOption myUpdateOption = new UpdateInBackgroundOption();
    private final PerformInBackgroundOption myCommitOption = new CommitInBackgroundOption();
    private final PerformInBackgroundOption myEditOption = new EditInBackgroundOption();
    private final PerformInBackgroundOption myCheckoutOption = new CheckoutInBackgroundOption();
    private final PerformInBackgroundOption myAddRemoveOption = new AddRemoveInBackgroundOption();

    public static VcsConfiguration createEmptyConfiguration() {
        return new VcsConfiguration();
    }

    private VcsConfiguration() {
    }

    public VcsConfiguration(Project project) {
        this.myProject = project;
    }

    @Override
    public Element getState() {
        try {
            Element e = new Element("state");
            this.writeExternal(e);
            return e;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    @Override
    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        Element child = element.getChild(CONFIRM_MOVE_TO_FAILED_COMMIT_ELEMENT);
        if (child != null) {
            this.MOVE_TO_FAILED_COMMIT_CHANGELIST = VcsShowConfirmationOption.Value.fromString(child.getAttributeValue(VALUE_ATTR));
        }
        if ((child = element.getChild(CONFIRM_REMOVE_EMPTY_CHANGELIST_ELEMENT)) != null) {
            this.REMOVE_EMPTY_INACTIVE_CHANGELISTS = VcsShowConfirmationOption.Value.fromString(child.getAttributeValue(VALUE_ATTR));
        }
        List messages = element.getChildren(MESSAGE_ELEMENT_NAME);
        for (Object message : messages) {
            this.saveCommitMessage(((Element)message).getAttributeValue(VALUE_ATTR));
        }
        if (this.ACTIVE_VCS_NAME != null && this.ACTIVE_VCS_NAME.length() > 0) {
            StartupManager.getInstance(this.myProject).registerStartupActivity(new Runnable(){

                @Override
                public void run() {
                    ProjectLevelVcsManager.getInstance(VcsConfiguration.this.myProject).setDirectoryMapping("", VcsConfiguration.this.ACTIVE_VCS_NAME);
                }
            });
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Element confirmChild;
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        if (this.MOVE_TO_FAILED_COMMIT_CHANGELIST != VcsShowConfirmationOption.Value.SHOW_CONFIRMATION) {
            confirmChild = new Element(CONFIRM_MOVE_TO_FAILED_COMMIT_ELEMENT);
            confirmChild.setAttribute(VALUE_ATTR, this.MOVE_TO_FAILED_COMMIT_CHANGELIST.toString());
            element.addContent(confirmChild);
        }
        if (this.REMOVE_EMPTY_INACTIVE_CHANGELISTS != VcsShowConfirmationOption.Value.SHOW_CONFIRMATION) {
            confirmChild = new Element(CONFIRM_REMOVE_EMPTY_CHANGELIST_ELEMENT);
            confirmChild.setAttribute(VALUE_ATTR, this.REMOVE_EMPTY_INACTIVE_CHANGELISTS.toString());
            element.addContent(confirmChild);
        }
        for (String message : this.myLastCommitMessages) {
            Element messageElement = new Element(MESSAGE_ELEMENT_NAME);
            messageElement.setAttribute(VALUE_ATTR, message);
            element.addContent(messageElement);
        }
    }

    public static VcsConfiguration getInstance(Project project) {
        return project.getComponent(VcsConfiguration.class);
    }

    @Override
    public void projectOpened() {
    }

    @Override
    public void projectClosed() {
    }

    @Override
    @NotNull
    public String getComponentName() {
        if ("VcsManagerConfiguration" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/VcsConfiguration.getComponentName must not return null");
        }
        return "VcsManagerConfiguration";
    }

    @Override
    public void initComponent() {
    }

    @Override
    public void disposeComponent() {
    }

    public void saveCommitMessage(String comment) {
        this.LAST_COMMIT_MESSAGE = comment;
        if (comment == null || comment.length() == 0) {
            return;
        }
        this.myLastCommitMessages.remove(comment);
        while (this.myLastCommitMessages.size() >= 25) {
            this.myLastCommitMessages.remove(0);
        }
        this.myLastCommitMessages.add(comment);
    }

    public String getLastCommitMessage() {
        return this.getLastNonEmptyCommitMessage();
    }

    public String getLastNonEmptyCommitMessage() {
        if (this.myLastCommitMessages.isEmpty()) {
            return null;
        }
        return this.myLastCommitMessages.get(this.myLastCommitMessages.size() - 1);
    }

    @NotNull
    public ArrayList<String> getRecentMessages() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myLastCommitMessages);
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/VcsConfiguration.getRecentMessages must not return null");
        }
        return arrayList;
    }

    public void removeMessage(String content) {
        this.myLastCommitMessages.remove(content);
    }

    public PerformInBackgroundOption getUpdateOption() {
        return this.myUpdateOption;
    }

    public PerformInBackgroundOption getCommitOption() {
        return this.myCommitOption;
    }

    public PerformInBackgroundOption getEditOption() {
        return this.myEditOption;
    }

    public PerformInBackgroundOption getCheckoutOption() {
        return this.myCheckoutOption;
    }

    public PerformInBackgroundOption getAddRemoveOption() {
        return this.myAddRemoveOption;
    }

    private class AddRemoveInBackgroundOption
    implements PerformInBackgroundOption {
        private AddRemoveInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_ADD_REMOVE_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
            VcsConfiguration.this.PERFORM_ADD_REMOVE_IN_BACKGROUND = true;
        }
    }

    private class CheckoutInBackgroundOption
    implements PerformInBackgroundOption {
        private CheckoutInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_CHECKOUT_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
            VcsConfiguration.this.PERFORM_CHECKOUT_IN_BACKGROUND = true;
        }
    }

    private class EditInBackgroundOption
    implements PerformInBackgroundOption {
        private EditInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_EDIT_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
            VcsConfiguration.this.PERFORM_EDIT_IN_BACKGROUND = true;
        }
    }

    private class CommitInBackgroundOption
    implements PerformInBackgroundOption {
        private CommitInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_COMMIT_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
        }
    }

    private class UpdateInBackgroundOption
    implements PerformInBackgroundOption {
        private UpdateInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_UPDATE_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
        }
    }

    public static enum StandardConfirmation {
        ADD(VcsBundle.message("vcs.command.name.add", new Object[0])),
        REMOVE(VcsBundle.message("vcs.command.name.remove", new Object[0]));

        private final String myId;

        private StandardConfirmation(String id) {
            this.myId = id;
        }

        public String getId() {
            return this.myId;
        }
    }

    public static enum StandardOption {
        ADD(VcsBundle.message("vcs.command.name.add", new Object[0])),
        REMOVE(VcsBundle.message("vcs.command.name.remove", new Object[0])),
        EDIT(VcsBundle.message("vcs.command.name.edit", new Object[0])),
        CHECKOUT(VcsBundle.message("vcs.command.name.checkout", new Object[0])),
        STATUS(VcsBundle.message("vcs.command.name.status", new Object[0])),
        UPDATE(VcsBundle.message("vcs.command.name.update", new Object[0]));

        private final String myId;

        private StandardOption(String id) {
            this.myId = id;
        }

        public String getId() {
            return this.myId;
        }
    }
}

