/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JRootPane;

public class IdeGlassPaneUtil {
    private IdeGlassPaneUtil() {
    }

    public static IdeGlassPane find(Component component) {
        Component gp;
        if (!(component instanceof JComponent)) {
            throw new IllegalArgumentException("Component must be instance of JComponent");
        }
        JRootPane root = ((JComponent)component).getRootPane();
        if (root == null) {
            new IllegalArgumentException("Component must be visible in order to find glass pane for it");
        }
        if (!((gp = root.getGlassPane()) instanceof IdeGlassPane)) {
            throw new IllegalArgumentException("Glass pane should be " + IdeGlassPane.class.getName());
        }
        return (IdeGlassPane)((Object)gp);
    }

    public static void installPainter(final JComponent target, final Painter painter, final Disposable parent) {
        UiNotifyConnector connector = new UiNotifyConnector(target, new Activatable(){
            IdeGlassPane myPane;

            @Override
            public void showNotify() {
                IdeGlassPane pane = IdeGlassPaneUtil.find(target);
                if (this.myPane != null && this.myPane != pane) {
                    this.myPane.removePainter(painter);
                }
                this.myPane = pane;
                this.myPane.addPainter(target, painter, parent);
            }

            @Override
            public void hideNotify() {
                if (this.myPane != null) {
                    this.myPane.removePainter(painter);
                }
            }
        });
        Disposer.register((Disposable)parent, (Disposable)connector);
    }
}

