/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsProvider;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ClassMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSettings
implements Cloneable,
JDOMExternalizable {
    private final ClassMap<CustomCodeStyleSettings> myCustomSettings = new ClassMap();
    @NonNls
    private static final String ADDITIONAL_INDENT_OPTIONS = "ADDITIONAL_INDENT_OPTIONS";
    @NonNls
    private static final String FILETYPE = "fileType";
    public boolean LINE_COMMENT_AT_FIRST_COLUMN = true;
    public boolean BLOCK_COMMENT_AT_FIRST_COLUMN = true;
    public boolean KEEP_LINE_BREAKS = true;
    public boolean KEEP_FIRST_COLUMN_COMMENT = true;
    public boolean INSERT_FIRST_SPACE_IN_LINE = true;
    public boolean USE_SAME_INDENTS = false;
    @Deprecated
    public final IndentOptions JAVA_INDENT_OPTIONS = new IndentOptions();
    @Deprecated
    public final IndentOptions JSP_INDENT_OPTIONS = new IndentOptions();
    @Deprecated
    public final IndentOptions XML_INDENT_OPTIONS = new IndentOptions();
    public final IndentOptions OTHER_INDENT_OPTIONS = new IndentOptions();
    private final Map<FileType, IndentOptions> myAdditionalIndentOptions = new LinkedHashMap<FileType, IndentOptions>();
    private static final String ourSystemLineSeparator = SystemProperties.getLineSeparator();
    public String LINE_SEPARATOR;
    public boolean KEEP_CONTROL_STATEMENT_IN_ONE_LINE = true;
    public static final int END_OF_LINE = 1;
    public static final int NEXT_LINE = 2;
    public static final int NEXT_LINE_SHIFTED = 3;
    public static final int NEXT_LINE_SHIFTED2 = 4;
    public static final int NEXT_LINE_IF_WRAPPED = 5;
    public int BRACE_STYLE = 1;
    public int CLASS_BRACE_STYLE = 1;
    public int METHOD_BRACE_STYLE = 1;
    public boolean DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS = false;
    public boolean ELSE_ON_NEW_LINE = false;
    public boolean WHILE_ON_NEW_LINE = false;
    public boolean CATCH_ON_NEW_LINE = false;
    public boolean FINALLY_ON_NEW_LINE = false;
    public boolean INDENT_CASE_FROM_SWITCH = true;
    public boolean SPECIAL_ELSE_IF_TREATMENT = true;
    public boolean ALIGN_MULTILINE_PARAMETERS = true;
    public boolean ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
    public boolean ALIGN_MULTILINE_FOR = true;
    public boolean INDENT_WHEN_CASES = true;
    public boolean ALIGN_MULTILINE_BINARY_OPERATION = false;
    public boolean ALIGN_MULTILINE_ASSIGNMENT = false;
    public boolean ALIGN_MULTILINE_TERNARY_OPERATION = false;
    public boolean ALIGN_MULTILINE_THROWS_LIST = false;
    public boolean ALIGN_MULTILINE_EXTENDS_LIST = false;
    public boolean ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION = false;
    public boolean ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = false;
    public boolean ALIGN_GROUP_FIELD_DECLARATIONS = false;
    public int KEEP_BLANK_LINES_IN_DECLARATIONS = 2;
    public int KEEP_BLANK_LINES_IN_CODE = 2;
    public int KEEP_BLANK_LINES_BEFORE_RBRACE = 2;
    public int BLANK_LINES_BEFORE_PACKAGE = 0;
    public int BLANK_LINES_AFTER_PACKAGE = 1;
    public int BLANK_LINES_BEFORE_IMPORTS = 1;
    public int BLANK_LINES_AFTER_IMPORTS = 1;
    public int BLANK_LINES_AROUND_CLASS = 1;
    public int BLANK_LINES_AROUND_FIELD = 0;
    public int BLANK_LINES_AROUND_METHOD = 1;
    public int BLANK_LINES_AROUND_FIELD_IN_INTERFACE = 0;
    public int BLANK_LINES_AROUND_METHOD_IN_INTERFACE = 1;
    public int BLANK_LINES_AFTER_CLASS_HEADER = 0;
    public boolean SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
    public boolean SPACE_AROUND_LOGICAL_OPERATORS = true;
    public boolean SPACE_AROUND_EQUALITY_OPERATORS = true;
    public boolean SPACE_AROUND_RELATIONAL_OPERATORS = true;
    public boolean SPACE_AROUND_BITWISE_OPERATORS = true;
    public boolean SPACE_AROUND_ADDITIVE_OPERATORS = true;
    public boolean SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
    public boolean SPACE_AROUND_SHIFT_OPERATORS = true;
    public boolean SPACE_AFTER_COMMA = true;
    public boolean SPACE_BEFORE_COMMA = false;
    public boolean SPACE_AFTER_SEMICOLON = true;
    public boolean SPACE_BEFORE_SEMICOLON = false;
    public boolean SPACE_WITHIN_PARENTHESES = false;
    public boolean SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
    public boolean SPACE_WITHIN_METHOD_PARENTHESES = false;
    public boolean SPACE_WITHIN_IF_PARENTHESES = false;
    public boolean SPACE_WITHIN_WHILE_PARENTHESES = false;
    public boolean SPACE_WITHIN_FOR_PARENTHESES = false;
    public boolean SPACE_WITHIN_CATCH_PARENTHESES = false;
    public boolean SPACE_WITHIN_SWITCH_PARENTHESES = false;
    public boolean SPACE_WITHIN_SYNCHRONIZED_PARENTHESES = false;
    public boolean SPACE_WITHIN_CAST_PARENTHESES = false;
    public boolean SPACE_WITHIN_BRACKETS = false;
    public boolean SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = false;
    public boolean SPACE_AFTER_TYPE_CAST = true;
    public boolean SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
    public boolean SPACE_BEFORE_METHOD_PARENTHESES = false;
    public boolean SPACE_BEFORE_IF_PARENTHESES = true;
    public boolean SPACE_BEFORE_WHILE_PARENTHESES = true;
    public boolean SPACE_BEFORE_FOR_PARENTHESES = true;
    public boolean SPACE_BEFORE_CATCH_PARENTHESES = true;
    public boolean SPACE_BEFORE_SWITCH_PARENTHESES = true;
    public boolean SPACE_BEFORE_SYNCHRONIZED_PARENTHESES = true;
    public boolean SPACE_BEFORE_CLASS_LBRACE = true;
    public boolean SPACE_BEFORE_METHOD_LBRACE = true;
    public boolean SPACE_BEFORE_IF_LBRACE = true;
    public boolean SPACE_BEFORE_ELSE_LBRACE = true;
    public boolean SPACE_BEFORE_WHILE_LBRACE = true;
    public boolean SPACE_BEFORE_FOR_LBRACE = true;
    public boolean SPACE_BEFORE_DO_LBRACE = true;
    public boolean SPACE_BEFORE_SWITCH_LBRACE = true;
    public boolean SPACE_BEFORE_TRY_LBRACE = true;
    public boolean SPACE_BEFORE_CATCH_LBRACE = true;
    public boolean SPACE_BEFORE_FINALLY_LBRACE = true;
    public boolean SPACE_BEFORE_SYNCHRONIZED_LBRACE = true;
    public boolean SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE = false;
    public boolean SPACE_BEFORE_QUEST = true;
    public boolean SPACE_AFTER_QUEST = true;
    public boolean SPACE_BEFORE_COLON = true;
    public boolean SPACE_AFTER_COLON = true;
    public boolean SPACE_BEFORE_TYPE_PARAMETER_LIST = false;
    public String FIELD_NAME_PREFIX = "";
    public String STATIC_FIELD_NAME_PREFIX = "";
    public String PARAMETER_NAME_PREFIX = "";
    public String LOCAL_VARIABLE_NAME_PREFIX = "";
    public String FIELD_NAME_SUFFIX = "";
    public String STATIC_FIELD_NAME_SUFFIX = "";
    public String PARAMETER_NAME_SUFFIX = "";
    public String LOCAL_VARIABLE_NAME_SUFFIX = "";
    public boolean PREFER_LONGER_NAMES = true;
    public final TypeToNameMap FIELD_TYPE_TO_NAME = new TypeToNameMap();
    public final TypeToNameMap STATIC_FIELD_TYPE_TO_NAME = new TypeToNameMap();
    @NonNls
    public final TypeToNameMap PARAMETER_TYPE_TO_NAME = new TypeToNameMap();
    public final TypeToNameMap LOCAL_VARIABLE_TYPE_TO_NAME = new TypeToNameMap();
    public boolean GENERATE_FINAL_LOCALS = false;
    public boolean GENERATE_FINAL_PARAMETERS = false;
    public boolean USE_EXTERNAL_ANNOTATIONS = false;
    public boolean INSERT_OVERRIDE_ANNOTATION = true;
    public boolean LAYOUT_STATIC_IMPORTS_SEPARATELY = true;
    public boolean USE_FQ_CLASS_NAMES = false;
    public boolean USE_FQ_CLASS_NAMES_IN_JAVADOC = true;
    public boolean USE_SINGLE_CLASS_IMPORTS = true;
    public boolean INSERT_INNER_CLASS_IMPORTS = false;
    public int CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = 5;
    public int NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = 3;
    public final PackageEntryTable PACKAGES_TO_USE_IMPORT_ON_DEMAND = new PackageEntryTable();
    public final PackageEntryTable IMPORT_LAYOUT_TABLE = new PackageEntryTable();
    public int FIELDS_ORDER_WEIGHT = 1;
    public int CONSTRUCTORS_ORDER_WEIGHT = 2;
    public int METHODS_ORDER_WEIGHT = 3;
    public int INNER_CLASSES_ORDER_WEIGHT = 4;
    public int RIGHT_MARGIN = 120;
    public static final int DO_NOT_WRAP = 0;
    public static final int WRAP_AS_NEEDED = 1;
    public static final int WRAP_ALWAYS = 2;
    public static final int WRAP_ON_EVERY_ITEM = 4;
    public int CALL_PARAMETERS_WRAP = 0;
    public boolean PREFER_PARAMETERS_WRAP = false;
    public boolean CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
    public boolean CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
    public int METHOD_PARAMETERS_WRAP = 0;
    public boolean METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
    public boolean METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
    public int EXTENDS_LIST_WRAP = 0;
    public int THROWS_LIST_WRAP = 0;
    public int EXTENDS_KEYWORD_WRAP = 0;
    public int THROWS_KEYWORD_WRAP = 0;
    public int METHOD_CALL_CHAIN_WRAP = 0;
    public boolean PARENTHESES_EXPRESSION_LPAREN_WRAP = false;
    public boolean PARENTHESES_EXPRESSION_RPAREN_WRAP = false;
    public int BINARY_OPERATION_WRAP = 0;
    public boolean BINARY_OPERATION_SIGN_ON_NEXT_LINE = false;
    public int TERNARY_OPERATION_WRAP = 0;
    public boolean TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = false;
    public boolean MODIFIER_LIST_WRAP = false;
    public boolean KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
    public boolean KEEP_SIMPLE_METHODS_IN_ONE_LINE = false;
    public int FOR_STATEMENT_WRAP = 0;
    public boolean FOR_STATEMENT_LPAREN_ON_NEXT_LINE = false;
    public boolean FOR_STATEMENT_RPAREN_ON_NEXT_LINE = false;
    public int ARRAY_INITIALIZER_WRAP = 0;
    public boolean ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = false;
    public boolean ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = false;
    public int ASSIGNMENT_WRAP = 0;
    public boolean PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE = false;
    public int LABELED_STATEMENT_WRAP = 2;
    public boolean WRAP_COMMENTS = false;
    public int ASSERT_STATEMENT_WRAP = 0;
    public boolean ASSERT_STATEMENT_COLON_ON_NEXT_LINE = false;
    public static final int DO_NOT_FORCE = 0;
    public static final int FORCE_BRACES_IF_MULTILINE = 1;
    public static final int FORCE_BRACES_ALWAYS = 3;
    public int IF_BRACE_FORCE = 0;
    public int DOWHILE_BRACE_FORCE = 0;
    public int WHILE_BRACE_FORCE = 0;
    public int FOR_BRACE_FORCE = 0;
    @NonNls
    public String ENTITY_EB_PREFIX = "";
    @NonNls
    public String ENTITY_EB_SUFFIX = "Bean";
    @NonNls
    public String ENTITY_HI_PREFIX = "";
    @NonNls
    public String ENTITY_HI_SUFFIX = "Home";
    @NonNls
    public String ENTITY_RI_PREFIX = "";
    @NonNls
    public String ENTITY_RI_SUFFIX = "";
    @NonNls
    public String ENTITY_LHI_PREFIX = "Local";
    @NonNls
    public String ENTITY_LHI_SUFFIX = "Home";
    @NonNls
    public String ENTITY_LI_PREFIX = "Local";
    @NonNls
    public String ENTITY_LI_SUFFIX = "";
    @NonNls
    public String ENTITY_DD_PREFIX = "";
    @NonNls
    public String ENTITY_DD_SUFFIX = "EJB";
    @NonNls
    public String ENTITY_VO_PREFIX = "";
    @NonNls
    public String ENTITY_VO_SUFFIX = "VO";
    @NonNls
    public String ENTITY_PK_CLASS = "java.lang.String";
    @NonNls
    public String SESSION_EB_PREFIX = "";
    @NonNls
    public String SESSION_EB_SUFFIX = "Bean";
    @NonNls
    public String SESSION_HI_PREFIX = "";
    @NonNls
    public String SESSION_HI_SUFFIX = "Home";
    @NonNls
    public String SESSION_RI_PREFIX = "";
    @NonNls
    public String SESSION_RI_SUFFIX = "";
    @NonNls
    public String SESSION_LHI_PREFIX = "Local";
    @NonNls
    public String SESSION_LHI_SUFFIX = "Home";
    @NonNls
    public String SESSION_LI_PREFIX = "Local";
    @NonNls
    public String SESSION_LI_SUFFIX = "";
    @NonNls
    public String SESSION_SI_PREFIX = "";
    @NonNls
    public String SESSION_SI_SUFFIX = "Service";
    @NonNls
    public String SESSION_DD_PREFIX = "";
    @NonNls
    public String SESSION_DD_SUFFIX = "EJB";
    @NonNls
    public String MESSAGE_EB_PREFIX = "";
    @NonNls
    public String MESSAGE_EB_SUFFIX = "Bean";
    @NonNls
    public String MESSAGE_DD_PREFIX = "";
    @NonNls
    public String MESSAGE_DD_SUFFIX = "EJB";
    @NonNls
    public String SERVLET_CLASS_PREFIX = "";
    @NonNls
    public String SERVLET_CLASS_SUFFIX = "";
    @NonNls
    public String SERVLET_DD_PREFIX = "";
    @NonNls
    public String SERVLET_DD_SUFFIX = "";
    @NonNls
    public String FILTER_CLASS_PREFIX = "";
    @NonNls
    public String FILTER_CLASS_SUFFIX = "";
    @NonNls
    public String FILTER_DD_PREFIX = "";
    @NonNls
    public String FILTER_DD_SUFFIX = "";
    @NonNls
    public String LISTENER_CLASS_PREFIX = "";
    @NonNls
    public String LISTENER_CLASS_SUFFIX = "";
    public boolean ENABLE_JAVADOC_FORMATTING = true;
    public boolean JD_ALIGN_PARAM_COMMENTS = true;
    public int JD_MIN_PARM_NAME_LENGTH = 0;
    public int JD_MAX_PARM_NAME_LENGTH = 30;
    public boolean JD_ALIGN_EXCEPTION_COMMENTS = true;
    public int JD_MIN_EXCEPTION_NAME_LENGTH = 0;
    public int JD_MAX_EXCEPTION_NAME_LENGTH = 30;
    public boolean JD_ADD_BLANK_AFTER_PARM_COMMENTS = false;
    public boolean JD_ADD_BLANK_AFTER_RETURN = false;
    public boolean JD_ADD_BLANK_AFTER_DESCRIPTION = true;
    public boolean JD_P_AT_EMPTY_LINES = true;
    public boolean JD_KEEP_INVALID_TAGS = true;
    public boolean JD_KEEP_EMPTY_LINES = true;
    public boolean JD_DO_NOT_WRAP_ONE_LINE_COMMENTS = false;
    public boolean JD_USE_THROWS_NOT_EXCEPTION = true;
    public boolean JD_KEEP_EMPTY_PARAMETER = true;
    public boolean JD_KEEP_EMPTY_EXCEPTION = true;
    public boolean JD_KEEP_EMPTY_RETURN = true;
    public boolean JD_LEADING_ASTERISKS_ARE_ENABLED = true;
    public boolean XML_KEEP_WHITESPACES = false;
    public int XML_ATTRIBUTE_WRAP = 1;
    public int XML_TEXT_WRAP = 1;
    public boolean XML_KEEP_LINE_BREAKS = true;
    public boolean XML_KEEP_LINE_BREAKS_IN_TEXT = true;
    public int XML_KEEP_BLANK_LINES = 2;
    public boolean XML_ALIGN_ATTRIBUTES = true;
    public boolean XML_ALIGN_TEXT = false;
    public boolean XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE = false;
    public boolean XML_SPACE_AFTER_TAG_NAME = false;
    public boolean XML_SPACE_INSIDE_EMPTY_TAG = false;
    public boolean HTML_KEEP_WHITESPACES = false;
    public int HTML_ATTRIBUTE_WRAP = 1;
    public int HTML_TEXT_WRAP = 1;
    public boolean HTML_KEEP_LINE_BREAKS = true;
    public boolean HTML_KEEP_LINE_BREAKS_IN_TEXT = true;
    public int HTML_KEEP_BLANK_LINES = 2;
    public boolean HTML_ALIGN_ATTRIBUTES = true;
    public boolean HTML_ALIGN_TEXT = false;
    public boolean HTML_SPACE_AROUND_EQUALITY_IN_ATTRINUTE = false;
    public boolean HTML_SPACE_AFTER_TAG_NAME = false;
    public boolean HTML_SPACE_INSIDE_EMPTY_TAG = false;
    @NonNls
    public String HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE = "body,div,p,form,h1,h2,h3";
    @NonNls
    public String HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE = "br";
    @NonNls
    public String HTML_DO_NOT_INDENT_CHILDREN_OF = "html,body,thead,tbody,tfoot";
    public int HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES = 200;
    @NonNls
    public String HTML_KEEP_WHITESPACES_INSIDE = "span,pre";
    @NonNls
    public String HTML_INLINE_ELEMENTS = "a,abbr,acronym,b,basefont,bdo,big,br,cite,cite,code,dfn,em,font,i,img,input,kbd,label,q,s,samp,select,span,strike,strong,sub,sup,textarea,tt,u,var";
    @NonNls
    public String HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT = "title,h1,h2,h3,h4,h5,h6,p";
    public boolean JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST = false;
    public int METHOD_ANNOTATION_WRAP = 2;
    public int CLASS_ANNOTATION_WRAP = 2;
    public int FIELD_ANNOTATION_WRAP = 2;
    public int PARAMETER_ANNOTATION_WRAP = 0;
    public int VARIABLE_ANNOTATION_WRAP = 0;
    public boolean SPACE_BEFORE_ANOTATION_PARAMETER_LIST = false;
    public boolean SPACE_WITHIN_ANNOTATION_PARENTHESES = false;
    public int ENUM_CONSTANTS_WRAP = 0;
    private CodeStyleSettings myParentSettings;
    private boolean myLoadedAdditionalIndentOptions;

    public CodeStyleSettings() {
        this(true);
    }

    public CodeStyleSettings(boolean loadExtensions) {
        this.initTypeToName();
        this.initImportsByDefault();
        if (loadExtensions) {
            CodeStyleSettingsProvider[] codeStyleSettingsProviders;
            for (CodeStyleSettingsProvider provider : codeStyleSettingsProviders = (CodeStyleSettingsProvider[])Extensions.getExtensions(CodeStyleSettingsProvider.EXTENSION_POINT_NAME)) {
                this.addCustomSettings(provider.createCustomSettings(this));
            }
        }
    }

    private void initImportsByDefault() {
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "java.awt", false));
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "javax.swing", false));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "javax", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "java", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
    }

    private void initTypeToName() {
        CodeStyleSettings.initGeneralLocalVariable(this.PARAMETER_TYPE_TO_NAME);
        CodeStyleSettings.initGeneralLocalVariable(this.LOCAL_VARIABLE_TYPE_TO_NAME);
        this.PARAMETER_TYPE_TO_NAME.addPair("*Exception", "e");
    }

    private static void initGeneralLocalVariable(@NonNls TypeToNameMap map) {
        map.addPair("int", "i");
        map.addPair("byte", "b");
        map.addPair("char", "c");
        map.addPair("long", "l");
        map.addPair("short", "i");
        map.addPair("boolean", "b");
        map.addPair("double", "v");
        map.addPair("float", "v");
        map.addPair("java.lang.Object", "o");
        map.addPair("java.lang.String", "s");
    }

    public void setParentSettings(CodeStyleSettings parent) {
        this.myParentSettings = parent;
    }

    public CodeStyleSettings getParentSettings() {
        return this.myParentSettings;
    }

    private void addCustomSettings(CustomCodeStyleSettings settings) {
        if (settings != null) {
            this.myCustomSettings.put(settings.getClass(), (Object)settings);
        }
    }

    public <T extends CustomCodeStyleSettings> T getCustomSettings(Class<T> aClass) {
        return (T)((CustomCodeStyleSettings)this.myCustomSettings.get(aClass));
    }

    public CodeStyleSettings clone() {
        CodeStyleSettings clone = new CodeStyleSettings();
        clone.copyFrom(this);
        return clone;
    }

    private void copyCustomSettingsFrom(CodeStyleSettings from) {
        assert (from != this);
        this.myCustomSettings.clear();
        for (CustomCodeStyleSettings customCodeStyleSettings : from.myCustomSettings.values()) {
            this.addCustomSettings((CustomCodeStyleSettings)customCodeStyleSettings.clone());
        }
        this.FIELD_TYPE_TO_NAME.copyFrom(from.FIELD_TYPE_TO_NAME);
        this.STATIC_FIELD_TYPE_TO_NAME.copyFrom(from.STATIC_FIELD_TYPE_TO_NAME);
        this.PARAMETER_TYPE_TO_NAME.copyFrom(from.PARAMETER_TYPE_TO_NAME);
        this.LOCAL_VARIABLE_TYPE_TO_NAME.copyFrom(from.LOCAL_VARIABLE_TYPE_TO_NAME);
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(from.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        this.IMPORT_LAYOUT_TABLE.copyFrom(from.IMPORT_LAYOUT_TABLE);
        this.OTHER_INDENT_OPTIONS.copyFrom(from.OTHER_INDENT_OPTIONS);
        this.myAdditionalIndentOptions.clear();
        for (Map.Entry entry : from.myAdditionalIndentOptions.entrySet()) {
            IndentOptions options = (IndentOptions)entry.getValue();
            this.myAdditionalIndentOptions.put((FileType)entry.getKey(), (IndentOptions)options.clone());
        }
    }

    public void copyFrom(CodeStyleSettings from) {
        CodeStyleSettings.copyPublicFields(from, this);
        this.copyCustomSettingsFrom(from);
    }

    private static void copyPublicFields(Object from, Object to) {
        Field[] fields;
        assert (from != to);
        for (Field field : fields = to.getClass().getDeclaredFields()) {
            if (!CodeStyleSettings.isPublic(field) || CodeStyleSettings.isFinal(field)) continue;
            try {
                CodeStyleSettings.copyFieldValue(from, to, field);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void copyFieldValue(Object from, Object to, Field field) throws IllegalAccessException {
        Class<?> fieldType = field.getType();
        if (fieldType.isPrimitive()) {
            field.set(to, field.get(from));
        } else if (fieldType.equals(String.class)) {
            field.set(to, field.get(from));
        } else {
            throw new RuntimeException("Field not copied " + field.getName());
        }
    }

    private static boolean isPublic(Field field) {
        return (field.getModifiers() & 1) != 0;
    }

    private static boolean isFinal(Field field) {
        return (field.getModifiers() & 0x10) != 0;
    }

    public String getLineSeparator() {
        return this.LINE_SEPARATOR != null ? this.LINE_SEPARATOR : ourSystemLineSeparator;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        if (this.LAYOUT_STATIC_IMPORTS_SEPARATELY) {
            boolean found = false;
            for (PackageEntry entry : this.IMPORT_LAYOUT_TABLE.getEntries()) {
                if (entry != PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) continue;
                found = true;
                break;
            }
            if (!found) {
                PackageEntry last;
                PackageEntry packageEntry = last = this.IMPORT_LAYOUT_TABLE.getEntryCount() == 0 ? null : this.IMPORT_LAYOUT_TABLE.getEntryAt(this.IMPORT_LAYOUT_TABLE.getEntryCount() - 1);
                if (last != PackageEntry.BLANK_LINE_ENTRY) {
                    this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                }
                this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
            }
        }
        this.importOldIndentOptions(element);
        for (CustomCodeStyleSettings settings : this.myCustomSettings.values()) {
            settings.readExternal(element);
        }
        List list = element.getChildren(ADDITIONAL_INDENT_OPTIONS);
        if (list != null) {
            for (Object o : list) {
                Element additionalIndentElement;
                String fileTypeId;
                if (!(o instanceof Element) || (fileTypeId = (additionalIndentElement = (Element)o).getAttributeValue(FILETYPE)) == null || fileTypeId.length() <= 0) continue;
                FileType target = FileTypeManager.getInstance().getFileTypeByExtension(fileTypeId);
                if (FileTypes.UNKNOWN == target || FileTypes.PLAIN_TEXT == target || target.getDefaultExtension().length() == 0) {
                    target = new TempFileType(fileTypeId);
                }
                IndentOptions options = new IndentOptions();
                options.readExternal(additionalIndentElement);
                this.registerAdditionalIndentOptions(target, options);
            }
        }
        this.copyOldIndentOptions("java", this.JAVA_INDENT_OPTIONS);
        this.copyOldIndentOptions("jsp", this.JSP_INDENT_OPTIONS);
        this.copyOldIndentOptions("xml", this.XML_INDENT_OPTIONS);
    }

    private void copyOldIndentOptions(@NonNls String extension, IndentOptions options) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(extension);
        if (fileType != FileTypes.UNKNOWN && fileType != FileTypes.PLAIN_TEXT && !this.myAdditionalIndentOptions.containsKey(fileType) && fileType.getDefaultExtension().length() != 0) {
            this.registerAdditionalIndentOptions(fileType, options);
        }
    }

    private void importOldIndentOptions(@NonNls Element element) {
        List options = element.getChildren("option");
        for (Object option1 : options) {
            int value;
            Element option = (Element)option1;
            String name = option.getAttributeValue("name");
            if ("TAB_SIZE".equals(name)) {
                this.JAVA_INDENT_OPTIONS.TAB_SIZE = value = Integer.valueOf(option.getAttributeValue("value")).intValue();
                this.JSP_INDENT_OPTIONS.TAB_SIZE = value;
                this.XML_INDENT_OPTIONS.TAB_SIZE = value;
                this.OTHER_INDENT_OPTIONS.TAB_SIZE = value;
                continue;
            }
            if ("INDENT_SIZE".equals(name)) {
                this.JAVA_INDENT_OPTIONS.INDENT_SIZE = value = Integer.valueOf(option.getAttributeValue("value")).intValue();
                this.JSP_INDENT_OPTIONS.INDENT_SIZE = value;
                this.XML_INDENT_OPTIONS.INDENT_SIZE = value;
                this.OTHER_INDENT_OPTIONS.INDENT_SIZE = value;
                continue;
            }
            if ("CONTINUATION_INDENT_SIZE".equals(name)) {
                this.JAVA_INDENT_OPTIONS.CONTINUATION_INDENT_SIZE = value = Integer.valueOf(option.getAttributeValue("value")).intValue();
                this.JSP_INDENT_OPTIONS.CONTINUATION_INDENT_SIZE = value;
                this.XML_INDENT_OPTIONS.CONTINUATION_INDENT_SIZE = value;
                this.OTHER_INDENT_OPTIONS.CONTINUATION_INDENT_SIZE = value;
                continue;
            }
            if ("USE_TAB_CHARACTER".equals(name)) {
                value = Boolean.valueOf(option.getAttributeValue("value")).booleanValue() ? 1 : 0;
                this.JAVA_INDENT_OPTIONS.USE_TAB_CHARACTER = value;
                this.JSP_INDENT_OPTIONS.USE_TAB_CHARACTER = value;
                this.XML_INDENT_OPTIONS.USE_TAB_CHARACTER = value;
                this.OTHER_INDENT_OPTIONS.USE_TAB_CHARACTER = value;
                continue;
            }
            if (!"SMART_TABS".equals(name)) continue;
            value = Boolean.valueOf(option.getAttributeValue("value")).booleanValue() ? 1 : 0;
            this.JAVA_INDENT_OPTIONS.SMART_TABS = value;
            this.JSP_INDENT_OPTIONS.SMART_TABS = value;
            this.XML_INDENT_OPTIONS.SMART_TABS = value;
            this.OTHER_INDENT_OPTIONS.SMART_TABS = value;
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        CodeStyleSettings parentSettings = new CodeStyleSettings();
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter((Object)this, (Object)parentSettings));
        ArrayList customSettings = new ArrayList(this.myCustomSettings.values());
        Collections.sort(customSettings, new Comparator<CustomCodeStyleSettings>(){

            @Override
            public int compare(CustomCodeStyleSettings o1, CustomCodeStyleSettings o2) {
                return o1.getTagName().compareTo(o2.getTagName());
            }
        });
        for (CustomCodeStyleSettings settings : customSettings) {
            Object parentCustomSettings = parentSettings.getCustomSettings(settings.getClass());
            assert (parentCustomSettings != null);
            settings.writeExternal(element, (CustomCodeStyleSettings)parentCustomSettings);
        }
        FileType[] fileTypes = this.myAdditionalIndentOptions.keySet().toArray(new FileType[this.myAdditionalIndentOptions.keySet().size()]);
        Arrays.sort(fileTypes, new Comparator<FileType>(){

            @Override
            public int compare(FileType o1, FileType o2) {
                return o1.getDefaultExtension().compareTo(o2.getDefaultExtension());
            }
        });
        for (FileType fileType : fileTypes) {
            IndentOptions indentOptions = this.myAdditionalIndentOptions.get(fileType);
            Element additionalIndentOptions = new Element(ADDITIONAL_INDENT_OPTIONS);
            indentOptions.writeExternal(additionalIndentOptions);
            additionalIndentOptions.setAttribute(FILETYPE, fileType.getDefaultExtension());
            element.addContent(additionalIndentOptions);
        }
    }

    public IndentOptions getIndentOptions(FileType fileType) {
        IndentOptions indentOptions;
        if (this.USE_SAME_INDENTS || fileType == null) {
            return this.OTHER_INDENT_OPTIONS;
        }
        if (!this.myLoadedAdditionalIndentOptions) {
            this.loadAdditionalIndentOptions();
        }
        if ((indentOptions = this.myAdditionalIndentOptions.get(fileType)) != null) {
            return indentOptions;
        }
        return this.OTHER_INDENT_OPTIONS;
    }

    public boolean isSmartTabs(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).SMART_TABS;
    }

    public int getIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).INDENT_SIZE;
    }

    public int getContinuationIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).CONTINUATION_INDENT_SIZE;
    }

    public int getLabelIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).LABEL_INDENT_SIZE;
    }

    public boolean getLabelIndentAbsolute(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).LABEL_INDENT_ABSOLUTE;
    }

    public int getTabSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).TAB_SIZE;
    }

    public boolean useTabCharacter(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).USE_TAB_CHARACTER;
    }

    private void registerAdditionalIndentOptions(FileType fileType, IndentOptions options) {
        this.myAdditionalIndentOptions.put(fileType, options);
    }

    public IndentOptions getAdditionalIndentOptions(FileType fileType) {
        if (!this.myLoadedAdditionalIndentOptions) {
            this.loadAdditionalIndentOptions();
        }
        return this.myAdditionalIndentOptions.get(fileType);
    }

    private void loadAdditionalIndentOptions() {
        FileTypeIndentOptionsProvider[] providers;
        this.myLoadedAdditionalIndentOptions = true;
        for (FileTypeIndentOptionsProvider provider : providers = (FileTypeIndentOptionsProvider[])Extensions.getExtensions(FileTypeIndentOptionsProvider.EP_NAME)) {
            if (this.myAdditionalIndentOptions.containsKey(provider.getFileType())) continue;
            this.registerAdditionalIndentOptions(provider.getFileType(), provider.createIndentOptions());
        }
    }

    public void clearCodeStyleSettings() throws Exception {
        CodeStyleSettings cleanSettings = new CodeStyleSettings();
        this.copyFrom(cleanSettings);
        this.myAdditionalIndentOptions.clear();
        this.myLoadedAdditionalIndentOptions = false;
    }

    private static class TempFileType
    implements FileType {
        private final String myExtension;

        private TempFileType(@NotNull String extension) {
            if (extension == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType.<init> must not be null");
            }
            this.myExtension = extension;
        }

        @Override
        @NotNull
        public String getName() {
            if ("TempFileType" == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType.getName must not return null");
            }
            return "TempFileType";
        }

        @Override
        @NotNull
        public String getDescription() {
            if ("TempFileType" == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType.getDescription must not return null");
            }
            return "TempFileType";
        }

        @Override
        @NotNull
        public String getDefaultExtension() {
            String string = this.myExtension;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType.getDefaultExtension must not return null");
            }
            return string;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public String getCharset(@NotNull VirtualFile file, byte[] content) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType.getCharset must not be null");
            }
            return null;
        }
    }

    public static class TypeToNameMap
    implements JDOMExternalizable {
        private final List<String> myPatterns = new ArrayList<String>();
        private final List<String> myNames = new ArrayList<String>();

        public void addPair(String pattern, String name) {
            this.myPatterns.add(pattern);
            this.myNames.add(name);
        }

        public String nameByType(String type) {
            for (int i = 0; i < this.myPatterns.size(); ++i) {
                String pattern = this.myPatterns.get(i);
                if (!(StringUtil.startsWithChar((CharSequence)pattern, (char)'*') ? type.endsWith(pattern.substring(1)) : type.equals(pattern))) continue;
                return this.myNames.get(i);
            }
            return null;
        }

        public void readExternal(@NonNls Element element) throws InvalidDataException {
            this.myPatterns.clear();
            this.myNames.clear();
            for (Object o : element.getChildren("pair")) {
                Element e = (Element)o;
                String pattern = e.getAttributeValue("type");
                String name = e.getAttributeValue("name");
                if (pattern == null || name == null) {
                    throw new InvalidDataException();
                }
                this.myPatterns.add(pattern);
                this.myNames.add(name);
            }
        }

        public void writeExternal(Element parentNode) throws WriteExternalException {
            for (int i = 0; i < this.myPatterns.size(); ++i) {
                String pattern = this.myPatterns.get(i);
                String name = this.myNames.get(i);
                Element element = new Element("pair");
                parentNode.addContent(element);
                element.setAttribute("type", pattern);
                element.setAttribute("name", name);
            }
        }

        public void copyFrom(TypeToNameMap from) {
            assert (from != this);
            this.myPatterns.clear();
            this.myPatterns.addAll(from.myPatterns);
            this.myNames.clear();
            this.myNames.addAll(from.myNames);
        }

        public boolean equals(Object other) {
            if (other instanceof TypeToNameMap) {
                String s2;
                String s1;
                int i;
                TypeToNameMap otherMap = (TypeToNameMap)other;
                if (this.myPatterns.size() != otherMap.myPatterns.size()) {
                    return false;
                }
                if (this.myNames.size() != otherMap.myNames.size()) {
                    return false;
                }
                for (i = 0; i < this.myPatterns.size(); ++i) {
                    s1 = this.myPatterns.get(i);
                    if (Comparing.equal((String)s1, (String)(s2 = otherMap.myPatterns.get(i)))) continue;
                    return false;
                }
                for (i = 0; i < this.myNames.size(); ++i) {
                    s1 = this.myNames.get(i);
                    if (Comparing.equal((String)s1, (String)(s2 = otherMap.myNames.get(i)))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int code = 0;
            for (String myPattern : this.myPatterns) {
                code += myPattern.hashCode();
            }
            for (String myName : this.myNames) {
                code += myName.hashCode();
            }
            return code;
        }
    }

    public static class IndentOptions
    implements JDOMExternalizable,
    Cloneable {
        public int INDENT_SIZE = 4;
        public int CONTINUATION_INDENT_SIZE = 8;
        public int TAB_SIZE = 4;
        public boolean USE_TAB_CHARACTER = false;
        public boolean SMART_TABS = false;
        public int LABEL_INDENT_SIZE = 0;
        public boolean LABEL_INDENT_ABSOLUTE = false;

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndentOptions that = (IndentOptions)o;
            if (this.CONTINUATION_INDENT_SIZE != that.CONTINUATION_INDENT_SIZE) {
                return false;
            }
            if (this.INDENT_SIZE != that.INDENT_SIZE) {
                return false;
            }
            if (this.LABEL_INDENT_ABSOLUTE != that.LABEL_INDENT_ABSOLUTE) {
                return false;
            }
            if (this.LABEL_INDENT_SIZE != that.LABEL_INDENT_SIZE) {
                return false;
            }
            if (this.SMART_TABS != that.SMART_TABS) {
                return false;
            }
            if (this.TAB_SIZE != that.TAB_SIZE) {
                return false;
            }
            return this.USE_TAB_CHARACTER == that.USE_TAB_CHARACTER;
        }

        public int hashCode() {
            int result = this.INDENT_SIZE;
            result = 31 * result + this.CONTINUATION_INDENT_SIZE;
            result = 31 * result + this.TAB_SIZE;
            result = 31 * result + (this.USE_TAB_CHARACTER ? 1 : 0);
            result = 31 * result + (this.SMART_TABS ? 1 : 0);
            result = 31 * result + this.LABEL_INDENT_SIZE;
            result = 31 * result + (this.LABEL_INDENT_ABSOLUTE ? 1 : 0);
            return result;
        }

        public void copyFrom(IndentOptions other) {
            CodeStyleSettings.copyPublicFields(other, this);
        }
    }
}

