/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class FilePatternPackageSet
implements PackageSet {
    @NonNls
    public static final String SCOPE_FILE = "file";
    private Pattern myModulePattern;
    private Pattern myModuleGroupPattern;
    private final String myPathPattern;
    private final Pattern myFilePattern;
    private final String myModulePatternText;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.search.scope.packageSet.FilePatternPackageSet");

    public FilePatternPackageSet(@NonNls String modulePattern, @NonNls String filePattern) {
        this.myPathPattern = filePattern;
        this.myModulePatternText = modulePattern;
        if (modulePattern == null || modulePattern.length() == 0) {
            this.myModulePattern = null;
        } else if (modulePattern.startsWith("group:")) {
            int idx = modulePattern.indexOf(58, 6);
            if (idx == -1) {
                idx = modulePattern.length();
            }
            this.myModuleGroupPattern = Pattern.compile(StringUtil.replace((String)modulePattern.substring(6, idx), (String)"*", (String)".*"));
            if (idx < modulePattern.length() - 1) {
                this.myModulePattern = Pattern.compile(StringUtil.replace((String)modulePattern.substring(idx + 1), (String)"*", (String)".*"));
            }
        } else {
            this.myModulePattern = Pattern.compile(StringUtil.replace((String)modulePattern, (String)"*", (String)".*"));
        }
        this.myFilePattern = filePattern != null ? Pattern.compile(FilePatternPackageSet.convertToRegexp(filePattern, '/')) : null;
    }

    @Override
    public boolean contains(PsiFile file, NamedScopesHolder holder) {
        Project project = file.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        VirtualFile vFile = file.getVirtualFile();
        return vFile != null && fileIndex.isInContent(vFile) && this.fileMatcher(vFile, fileIndex) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, vFile, fileIndex);
    }

    private boolean fileMatcher(VirtualFile virtualFile, ProjectFileIndex fileIndex) {
        if (this.myModulePattern != null) {
            VirtualFile contentRoot = fileIndex.getContentRootForFile(virtualFile);
            return this.myFilePattern.matcher(VfsUtil.getRelativePath(virtualFile, contentRoot, '/')).matches();
        }
        return this.myFilePattern.matcher(FilePatternPackageSet.getRelativePath(virtualFile, fileIndex, true)).matches();
    }

    public static boolean matchesModule(Pattern moduleGroupPattern, Pattern modulePattern, VirtualFile file, ProjectFileIndex fileIndex) {
        Module module = fileIndex.getModuleForFile(file);
        LOG.assertTrue(module != null, (Object)("url: " + file.getUrl()));
        if (modulePattern != null && modulePattern.matcher(module.getName()).matches()) {
            return true;
        }
        String[] groupPath = ModuleManager.getInstance(module.getProject()).getModuleGroupPath(module);
        if (groupPath != null) {
            for (String node : groupPath) {
                if (moduleGroupPattern == null || !moduleGroupPattern.matcher(node).matches()) continue;
                return true;
            }
        }
        return modulePattern == null && moduleGroupPattern == null;
    }

    public static String convertToRegexp(String aspectsntx, char separator) {
        StringBuffer buf = new StringBuffer(aspectsntx.length());
        boolean isAfterSeparator = false;
        boolean isAfterAsterix = false;
        for (int cur = 0; cur < aspectsntx.length(); ++cur) {
            char curChar = aspectsntx.charAt(cur);
            if (curChar != separator && isAfterSeparator) {
                buf.append("\\" + separator);
                isAfterSeparator = false;
            }
            if (curChar != '*' && isAfterAsterix) {
                buf.append(".*");
                isAfterAsterix = false;
            }
            if (curChar == '*') {
                if (!isAfterAsterix) {
                    isAfterAsterix = true;
                    continue;
                }
                buf.append("[^\\" + separator + "]*");
                isAfterAsterix = false;
                continue;
            }
            if (curChar == separator) {
                if (isAfterSeparator) {
                    buf.append("\\" + separator + "(.*\\" + separator + ")?");
                    isAfterSeparator = false;
                    continue;
                }
                isAfterSeparator = true;
                continue;
            }
            buf.append(curChar);
        }
        if (isAfterAsterix) {
            buf.append("[^\\" + separator + "]*");
        }
        return buf.toString();
    }

    @Override
    public PackageSet createCopy() {
        return new FilePatternPackageSet(this.myModulePatternText, this.myPathPattern);
    }

    @Override
    public int getNodePriority() {
        return 0;
    }

    @Override
    public String getText() {
        StringBuffer buf = new StringBuffer(SCOPE_FILE);
        if (this.myModulePattern != null || this.myModuleGroupPattern != null) {
            buf.append("[").append(this.myModulePatternText).append("]");
        }
        if (buf.length() > 0) {
            buf.append(':');
        }
        buf.append(this.myPathPattern);
        return buf.toString();
    }

    public static String getRelativePath(VirtualFile virtualFile, ProjectFileIndex index, boolean useFQName) {
        Module module = index.getModuleForFile(virtualFile);
        if (module != null) {
            VirtualFile projectParent = module.getProject().getBaseDir();
            if (projectParent != null && VfsUtil.isAncestor(projectParent, virtualFile, false)) {
                String projectRelativePath = VfsUtil.getRelativePath(virtualFile, projectParent, '/');
                return useFQName ? projectRelativePath : projectRelativePath.substring(projectRelativePath.indexOf(47) + 1);
            }
            return virtualFile.getPath();
        }
        VirtualFile contentRootForFile = index.getContentRootForFile(virtualFile);
        if (contentRootForFile != null) {
            return VfsUtil.getRelativePath(virtualFile, contentRootForFile, '/');
        }
        return FilePatternPackageSet.getLibRelativePath(virtualFile, index);
    }

    public static String getLibRelativePath(VirtualFile virtualFile, ProjectFileIndex index) {
        StringBuilder relativePath = new StringBuilder(100);
        for (VirtualFile directory = virtualFile; directory != null && index.isInLibraryClasses(directory); directory = directory.getParent()) {
            relativePath.insert(0, '/');
            relativePath.insert(0, directory.getName());
        }
        return relativePath.toString();
    }
}

