/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonRefactoringUtil {
    private CommonRefactoringUtil() {
    }

    public static void showErrorMessage(String title, String message, @NonNls String helpId, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.showErrorMessage must not be null");
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        RefactoringMessageDialog dialog = new RefactoringMessageDialog(title, message, helpId, "OptionPane.errorIcon", false, project);
        dialog.show();
    }

    public static void showErrorHint(Project project, @Nullable Editor editor, String message, String title, String helpId) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RefactoringErrorHintException(message);
        }
        if (editor == null) {
            CommonRefactoringUtil.showErrorMessage(title, message, helpId, project);
        } else {
            HintManager.getInstance().showErrorHint(editor, message);
        }
    }

    @NonNls
    public static String htmlEmphasize(String text) {
        return "<b><code>" + text + "</code></b>";
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatus must not be null");
        }
        PsiFile psiFile = element.getContainingFile();
        return !ReadonlyStatusHandler.getInstance(element.getProject()).ensureFilesWritable(psiFile.getVirtualFile()).hasReadonlyFiles();
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatus must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatus must not be null");
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(element, project, RefactoringBundle.message("refactoring.cannot.be.performed"));
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, PsiElement ... elements) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatus must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatus must not be null");
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(Arrays.asList(elements), project, RefactoringBundle.message("refactoring.cannot.be.performed"), false, true);
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element, @NotNull Project project, String messagePrefix) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatus must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatus must not be null");
        }
        return element.isWritable() || CommonRefactoringUtil.checkReadOnlyStatus(Collections.singleton(element), project, messagePrefix, false, true);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatusRecursively must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatusRecursively must not be null");
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(elements, project, RefactoringBundle.message("refactoring.cannot.be.performed"), true, false);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatusRecursively must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatusRecursively must not be null");
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(elements, project, RefactoringBundle.message("refactoring.cannot.be.performed"), true, notifyOnFail);
    }

    private static boolean checkReadOnlyStatus(@NotNull Collection<? extends PsiElement> elements, @NotNull Project project, String messagePrefix, boolean recursively, boolean notifyOnFail) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatus must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/CommonRefactoringUtil.checkReadOnlyStatus must not be null");
        }
        THashSet readonly = new THashSet();
        THashSet failed = new THashSet();
        boolean seenNonWritablePsiFilesWithoutVirtualFile = false;
        for (PsiElement psiElement : elements) {
            PsiFile file;
            VirtualFile vFile;
            if (psiElement instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)psiElement;
                vFile = dir.getVirtualFile();
                if (vFile.getFileSystem() instanceof JarFileSystem) {
                    failed.add(vFile);
                    continue;
                }
                if (recursively) {
                    CommonRefactoringUtil.addVirtualFiles(vFile, (Collection<VirtualFile>)readonly);
                    continue;
                }
                readonly.add(vFile);
                continue;
            }
            if (psiElement instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories;
                for (PsiDirectory directory : directories = ((PsiDirectoryContainer)psiElement).getDirectories()) {
                    VirtualFile virtualFile = directory.getVirtualFile();
                    if (recursively) {
                        if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                            failed.add(virtualFile);
                            continue;
                        }
                        CommonRefactoringUtil.addVirtualFiles(virtualFile, (Collection<VirtualFile>)readonly);
                        continue;
                    }
                    if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                        failed.add(virtualFile);
                        continue;
                    }
                    readonly.add(virtualFile);
                }
                continue;
            }
            if (psiElement instanceof PsiCompiledElement) {
                file = psiElement.getContainingFile();
                if (file == null) continue;
                failed.add(file.getVirtualFile());
                continue;
            }
            file = psiElement.getContainingFile();
            if (file == null) {
                if (psiElement.isWritable()) continue;
                seenNonWritablePsiFilesWithoutVirtualFile = true;
                continue;
            }
            vFile = file.getVirtualFile();
            if (vFile != null) {
                readonly.add(vFile);
                continue;
            }
            if (psiElement.isWritable()) continue;
            seenNonWritablePsiFilesWithoutVirtualFile = true;
        }
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(VfsUtil.toVirtualFileArray((Collection<? extends VirtualFile>)readonly));
        failed.addAll(Arrays.asList(status.getReadonlyFiles()));
        if (notifyOnFail && (!failed.isEmpty() || seenNonWritablePsiFilesWithoutVirtualFile && readonly.isEmpty())) {
            StringBuilder stringBuilder = new StringBuilder(messagePrefix);
            stringBuilder.append('\n');
            int i = 0;
            for (VirtualFile virtualFile : failed) {
                String subj;
                String presentableUrl = virtualFile.getPresentableUrl();
                String string = subj = virtualFile.isDirectory() ? RefactoringBundle.message("directory.description", presentableUrl) : RefactoringBundle.message("file.description", presentableUrl);
                if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                    stringBuilder.append(RefactoringBundle.message("0.is.located.in.a.jar.file", subj));
                } else {
                    stringBuilder.append(RefactoringBundle.message("0.is.read.only", subj));
                }
                if (i++ <= 20) continue;
                stringBuilder.append("...\n");
                break;
            }
            CommonRefactoringUtil.showErrorMessage(RefactoringBundle.message("error.title"), stringBuilder.toString(), null, project);
            return false;
        }
        return failed.isEmpty();
    }

    private static void addVirtualFiles(VirtualFile vFile, Collection<VirtualFile> list) {
        if (!vFile.isWritable()) {
            list.add(vFile);
        }
        VirtualFile[] children = vFile.getChildren();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (children != null) {
            for (VirtualFile virtualFile : children) {
                if (fileTypeManager.isFileIgnored(virtualFile.getName())) continue;
                CommonRefactoringUtil.addVirtualFiles(virtualFile, list);
            }
        }
    }

    public static String capitalize(String text) {
        return Character.toUpperCase(text.charAt(0)) + text.substring(1);
    }

    public static boolean isAncestor(PsiElement resolved, Collection<? extends PsiElement> scopes) {
        for (PsiElement psiElement : scopes) {
            if (!PsiTreeUtil.isAncestor(psiElement, resolved, false)) continue;
            return true;
        }
        return false;
    }

    public static class RefactoringErrorHintException
    extends RuntimeException {
        public RefactoringErrorHintException(String message) {
            super(message);
        }
    }
}

