/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConvertContext
extends ConvertContext {
    public static ConvertContext createConvertContext(final DomElement domElement) {
        return new AbstractConvertContext(){

            @Override
            @NotNull
            public DomElement getInvocationElement() {
                DomElement domElement2 = domElement;
                if (domElement2 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/xml/AbstractConvertContext$1.getInvocationElement must not return null");
                }
                return domElement2;
            }
        };
    }

    @Override
    public final XmlTag getTag() {
        return this.getInvocationElement().getXmlTag();
    }

    @Override
    @Nullable
    public XmlElement getXmlElement() {
        return this.getInvocationElement().getXmlElement();
    }

    @Override
    @NotNull
    public final XmlFile getFile() {
        XmlFile xmlFile = DomUtil.getFile(this.getInvocationElement());
        if (xmlFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/AbstractConvertContext.getFile must not return null");
        }
        return xmlFile;
    }

    @Override
    public Module getModule() {
        DomFileElement fileElement = DomUtil.getFileElement(this.getInvocationElement());
        if (fileElement == null) {
            XmlElement xmlElement = this.getInvocationElement().getXmlElement();
            return xmlElement == null ? null : ModuleUtil.findModuleForPsiElement(xmlElement);
        }
        return fileElement.getRootElement().getModule();
    }

    @Override
    public PsiManager getPsiManager() {
        return this.getFile().getManager();
    }
}

