/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluator;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.LookupValueWithPsiElement;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetElementUtilBase {
    public static final int REFERENCED_ELEMENT_ACCEPTED = 1;
    public static final int ELEMENT_NAME_ACCEPTED = 2;
    public static final int LOOKUP_ITEM_ACCEPTED = 8;
    protected final LanguageExtension<TargetElementEvaluator> targetElementEvaluator = new LanguageExtension("com.intellij.targetElementEvaluator");

    public static TargetElementUtilBase getInstance() {
        return (TargetElementUtilBase)ServiceManager.getService(TargetElementUtilBase.class);
    }

    public int getAllAccepted() {
        return 11;
    }

    public int getDefinitionSearchFlags() {
        return this.getAllAccepted();
    }

    public int getReferenceSearchFlags() {
        return this.getAllAccepted();
    }

    @Nullable
    public static PsiReference findReference(Editor editor) {
        return TargetElementUtilBase.findReference(editor, editor.getCaretModel().getOffset());
    }

    @Nullable
    public static PsiReference findReference(Editor editor, int offset) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        }
        offset = TargetElementUtilBase.adjustOffset(document, offset);
        if (file instanceof PsiCompiledElement) {
            return ((PsiCompiledElement)file).getMirror().findReferenceAt(offset);
        }
        return file.findReferenceAt(offset);
    }

    public static int adjustOffset(Document document, int offset) {
        CharSequence text = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!Character.isJavaIdentifierPart(text.charAt(offset))) {
            --correctedOffset;
        }
        if (correctedOffset < 0 || !Character.isJavaIdentifierPart(text.charAt(correctedOffset))) {
            return offset;
        }
        return correctedOffset;
    }

    @Nullable
    public static PsiElement findTargetElement(Editor editor, int flags) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return TargetElementUtilBase.getInstance().findTargetElement(editor, flags, editor.getCaretModel().getOffset());
    }

    public static boolean inVirtualSpace(Editor editor, int offset) {
        if (offset == editor.getCaretModel().getOffset()) {
            return TargetElementUtilBase.inVirtualSpace(editor, editor.getCaretModel().getLogicalPosition());
        }
        return false;
    }

    public static boolean inVirtualSpace(Editor editor, LogicalPosition logicalPosition) {
        return !editor.offsetToLogicalPosition(editor.logicalPositionToOffset(logicalPosition)).equals((Object)logicalPosition);
    }

    @Nullable
    public PsiElement findTargetElement(Editor editor, int flags, int offset) {
        PsiElement referenceOrReferencedElement;
        PsiFile file;
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Lookup activeLookup = LookupManager.getInstance(project).getActiveLookup();
        if (activeLookup != null && (flags & 8) != 0) {
            PsiElement lookupItem = TargetElementUtilBase.getLookupItem(activeLookup);
            return lookupItem != null && lookupItem.isValid() ? lookupItem : null;
        }
        Document document = editor.getDocument();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null) {
            return null;
        }
        offset = TargetElementUtilBase.adjustOffset(document, offset);
        PsiElement element = file.findElementAt(offset);
        if ((flags & 1) != 0 && this.isAcceptableReferencedElement(element, referenceOrReferencedElement = this.getReferenceOrReferencedElement(file, editor, flags, offset))) {
            return referenceOrReferencedElement;
        }
        if (element == null) {
            return null;
        }
        if ((flags & 2) != 0) {
            if (element instanceof PsiNamedElement) {
                return element;
            }
            return this.getNamedElement(element, offset - element.getTextRange().getStartOffset());
        }
        return null;
    }

    protected boolean isAcceptableReferencedElement(PsiElement element, PsiElement referenceOrReferencedElement) {
        return referenceOrReferencedElement != null && referenceOrReferencedElement.isValid();
    }

    @Nullable
    public PsiElement adjustElement(Editor editor, int flags, PsiElement element, PsiElement contextElement) {
        return element;
    }

    @Nullable
    public PsiElement adjustReference(@NotNull PsiReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/TargetElementUtilBase.adjustReference must not be null");
        }
        return null;
    }

    @Nullable
    public PsiElement getNamedElement(final @Nullable PsiElement element, final int offsetInElement) {
        if (element == null) {
            return null;
        }
        final ArrayList targets = CollectionFactory.arrayList();
        Consumer<PomTarget> consumer = new Consumer<PomTarget>(){

            public void consume(PomTarget target) {
                if (target instanceof PsiDeclaredTarget) {
                    PsiDeclaredTarget declaredTarget = (PsiDeclaredTarget)target;
                    PsiElement navigationElement = declaredTarget.getNavigationElement();
                    TextRange range = declaredTarget.getNameIdentifierRange();
                    if (range != null && !range.shiftRight(navigationElement.getTextRange().getStartOffset()).contains(element.getTextRange().getStartOffset() + offsetInElement)) {
                        return;
                    }
                }
                targets.add(target);
            }
        };
        int offset = offsetInElement;
        for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
            for (PomDeclarationSearcher searcher : (PomDeclarationSearcher[])PomDeclarationSearcher.EP_NAME.getExtensions()) {
                searcher.findDeclarationsAt(parent, offset, (Consumer)consumer);
                if (targets.isEmpty()) continue;
                PomTarget target = (PomTarget)targets.get(0);
                return target == null ? null : PomService.convertToPsi((Project)element.getProject(), (PomTarget)target);
            }
            offset += parent.getStartOffsetInParent();
        }
        return this.getNamedElement(element);
    }

    @Nullable
    protected PsiElement getNamedElement(@Nullable PsiElement element) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, PsiNamedElement.class, (boolean)false);
        if (parent != null) {
            assert (element != null) : "notnull parent?";
            if (parent.getTextOffset() == element.getTextRange().getStartOffset()) {
                return parent;
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getLookupItem(Lookup activeLookup) {
        PsiElement element;
        LookupElement item = activeLookup.getCurrentItem();
        if (item == null) {
            return null;
        }
        Object o = item.getObject();
        if (o instanceof PsiElement) {
            PsiElement element2 = (PsiElement)o;
            if (!(element2 instanceof PsiDirectoryContainer) && !TargetElementUtilBase.isValidElement(element2)) {
                return null;
            }
            return element2;
        }
        if (o instanceof LookupValueWithPsiElement && (element = ((LookupValueWithPsiElement)o).getElement()) != null && TargetElementUtilBase.isValidElement(element)) {
            return element;
        }
        return null;
    }

    private static boolean isValidElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/TargetElementUtilBase.isValidElement must not be null");
        }
        if (!element.isValid()) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return false;
        }
        return file.getOriginalFile().getVirtualFile() != null;
    }

    @Nullable
    protected PsiElement getReferenceOrReferencedElement(PsiFile file, Editor editor, int flags, int offset) {
        PsiElement element;
        PsiReference ref = TargetElementUtilBase.findReference(editor, offset);
        if (ref == null) {
            return null;
        }
        Language language = ref.getElement().getLanguage();
        TargetElementEvaluator evaluator = (TargetElementEvaluator)this.targetElementEvaluator.forLanguage(language);
        if (evaluator != null && (element = evaluator.getElementByReference(ref, flags)) != null) {
            return element;
        }
        PsiManager manager = file.getManager();
        PsiElement refElement = ref.resolve();
        if (refElement == null) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                DaemonCodeAnalyzer.getInstance((Project)manager.getProject()).updateVisibleHighlighters(editor);
            }
            return null;
        }
        return refElement;
    }

    public Collection<PsiElement> getTargetCandidates(PsiReference reference) {
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
            ArrayList<PsiElement> navigatableResults = new ArrayList<PsiElement>(results.length);
            for (ResolveResult r : results) {
                PsiElement element = r.getElement();
                if (!EditSourceUtil.canNavigate((PsiElement)element) && (!(element instanceof Navigatable) || !((Navigatable)element).canNavigateToSource())) continue;
                navigatableResults.add(element);
            }
            return navigatableResults;
        }
        PsiElement resolved = reference.resolve();
        if (resolved instanceof NavigationItem) {
            return Collections.singleton(resolved);
        }
        return Collections.emptyList();
    }

    public PsiElement getGotoDeclarationTarget(PsiElement element, PsiElement navElement) {
        return navElement;
    }

    public boolean includeSelfInGotoImplementation(PsiElement element) {
        TargetElementEvaluator elementEvaluator = element != null ? (TargetElementEvaluator)this.targetElementEvaluator.forLanguage(element.getLanguage()) : null;
        return elementEvaluator == null || elementEvaluator.includeSelfInGotoImplementation(element);
    }
}

