/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.DefaultInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AllClassesGetter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.AllClassesGetter");
    private final ElementFilter myFilter;
    private static final InsertHandler<JavaPsiClassReferenceElement> INSERT_HANDLER = new InsertHandler<JavaPsiClassReferenceElement>(){

        private void _handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
            boolean insertFqn;
            RangeMarker toDelete;
            Document document;
            String qname;
            int endOffset;
            block18: {
                int newOffset;
                Editor editor = context.getEditor();
                PsiClass psiClass = item.getObject();
                if (!psiClass.isValid()) {
                    return;
                }
                endOffset = editor.getCaretModel().getOffset();
                qname = psiClass.getQualifiedName();
                if (qname == null) {
                    return;
                }
                if (endOffset == 0) {
                    return;
                }
                document = editor.getDocument();
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)psiClass.getProject());
                PsiFile file = context.getFile();
                if (file.findElementAt(endOffset - 1) == null) {
                    return;
                }
                OffsetKey key = OffsetKey.create((String)"endOffset", (boolean)false);
                context.getOffsetMap().addOffset(key, endOffset);
                ClassNameInsertHandler handler = (ClassNameInsertHandler)ClassNameInsertHandler.EP_NAME.forLanguage(file.getLanguage());
                ClassNameInsertHandlerResult checkReference = ClassNameInsertHandlerResult.CHECK_FOR_CORRECT_REFERENCE;
                if (handler != null) {
                    checkReference = handler.handleInsert(context, item);
                }
                if ((newOffset = context.getOffsetMap().getOffset(key)) >= 0) {
                    endOffset = newOffset;
                } else {
                    LOG.error(endOffset + " became invalid: " + context.getOffsetMap() + "; inserting " + qname);
                }
                toDelete = DefaultInsertHandler.insertSpace(endOffset, document);
                psiDocumentManager.commitAllDocuments();
                PsiReference psiReference = file.findReferenceAt(endOffset - 1);
                boolean bl = insertFqn = checkReference != ClassNameInsertHandlerResult.REFERENCE_CORRECTED;
                if (checkReference == ClassNameInsertHandlerResult.CHECK_FOR_CORRECT_REFERENCE && psiReference != null) {
                    PsiManager psiManager = file.getManager();
                    if (psiManager.areElementsEquivalent((PsiElement)psiClass, DefaultInsertHandler.resolveReference(psiReference))) {
                        insertFqn = false;
                    } else if (psiClass.isValid()) {
                        try {
                            PsiElement psiElement;
                            PsiElement newUnderlying = psiReference.bindToElement((PsiElement)psiClass);
                            if (newUnderlying == null || (psiElement = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(newUnderlying)) == null) break block18;
                            for (PsiReference reference : psiElement.getReferences()) {
                                if (!psiManager.areElementsEquivalent((PsiElement)psiClass, DefaultInsertHandler.resolveReference(reference))) continue;
                                insertFqn = false;
                                endOffset = reference.getRangeInElement().getEndOffset() + reference.getElement().getTextRange().getStartOffset();
                                break;
                            }
                        }
                        catch (IncorrectOperationException e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (toDelete.isValid()) {
                document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
                if (insertFqn) {
                    endOffset = toDelete.getStartOffset();
                }
            }
            if (insertFqn) {
                char ch;
                int i;
                for (i = endOffset - 1; i >= 0 && (Character.isJavaIdentifierPart(ch = document.getCharsSequence().charAt(i)) || ch == '.'); --i) {
                }
                document.replaceString(i + 1, endOffset, (CharSequence)qname);
            }
        }

        public void handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
            context.setAddCompletionChar(false);
            this._handleInsert(context, item);
            item.getTailType().processTail(context.getEditor(), context.getEditor().getCaretModel().getOffset());
        }
    };

    public AllClassesGetter(ElementFilter filter) {
        this.myFilter = filter;
    }

    public void getClasses(final PsiElement context, CompletionResultSet set, int offset, final boolean filterByScope) {
        if (context == null || !context.isValid()) {
            return;
        }
        final String packagePrefix = AllClassesGetter.getPackagePrefix(context, offset);
        THashSet qnames = new THashSet();
        GlobalSearchScope scope = (GlobalSearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<GlobalSearchScope>(){

            public GlobalSearchScope compute() {
                return filterByScope ? context.getContainingFile().getResolveScope() : GlobalSearchScope.allScope((Project)context.getProject());
            }
        });
        final PrefixMatcher prefixMatcher = set.getPrefixMatcher();
        boolean lookingForAnnotations = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"@"})).accepts((Object)context);
        AllClassesSearch.search((SearchScope)scope, (Project)context.getProject(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return prefixMatcher.prefixMatches(s);
            }
        }).forEach((Processor)new Processor<PsiClass>((Set)qnames, lookingForAnnotations, filterByScope, set){
            final /* synthetic */ Set val$qnames;
            final /* synthetic */ boolean val$lookingForAnnotations;
            final /* synthetic */ boolean val$filterByScope;
            final /* synthetic */ CompletionResultSet val$set;
            {
                this.val$qnames = set;
                this.val$lookingForAnnotations = bl;
                this.val$filterByScope = bl2;
                this.val$set = completionResultSet;
            }

            public boolean process(PsiClass psiClass) {
                assert (psiClass != null);
                if (AllClassesGetter.this.isSuitable(context, packagePrefix, this.val$qnames, this.val$lookingForAnnotations, psiClass, this.val$filterByScope)) {
                    this.val$set.addElement(AllClassesGetter.createLookupItem(psiClass));
                }
                return true;
            }
        });
    }

    private static String getPackagePrefix(final PsiElement context, int offset) {
        char c;
        int i;
        String fileText = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                ProgressManager.checkCanceled();
                return context.getContainingFile().getText();
            }
        });
        for (i = offset - 1; i >= 0 && (Character.isJavaIdentifierPart(c = fileText.charAt(i)) || c == '.'); --i) {
        }
        String prefix = fileText.substring(i + 1, offset);
        int j = prefix.lastIndexOf(46);
        return j > 0 ? prefix.substring(0, j) : "";
    }

    private boolean isSuitable(final @NotNull PsiElement context, final String packagePrefix, final Set<String> qnames, final boolean lookingForAnnotations, final @NotNull PsiClass psiClass, final boolean filterByScope) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/AllClassesGetter.isSuitable must not be null");
        }
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/completion/AllClassesGetter.isSuitable must not be null");
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                ProgressManager.checkCanceled();
                if (!context.isValid() || !psiClass.isValid()) {
                    return false;
                }
                if (lookingForAnnotations && !psiClass.isAnnotationType()) {
                    return false;
                }
                if (JavaCompletionUtil.isInExcludedPackage(psiClass)) {
                    return false;
                }
                String qualifiedName = psiClass.getQualifiedName();
                if (qualifiedName == null || !qualifiedName.startsWith(packagePrefix)) {
                    return false;
                }
                if (!AllClassesGetter.this.myFilter.isAcceptable((Object)psiClass, context)) {
                    return false;
                }
                if (!(psiClass instanceof PsiCompiledElement) || !filterByScope || JavaPsiFacade.getInstance((Project)psiClass.getProject()).getResolveHelper().isAccessible((PsiMember)psiClass, context, psiClass)) {
                    return qnames.add(qualifiedName);
                }
                return false;
            }
        });
    }

    public static LookupElement createLookupItem(final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/AllClassesGetter.createLookupItem must not be null");
        }
        return (LookupElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LookupElement>(){

            public LookupElement compute() {
                return new JavaPsiClassReferenceElement(psiClass).setInsertHandler(INSERT_HANDLER);
            }
        });
    }

    public static enum ClassNameInsertHandlerResult {
        INSERT_FQN,
        REFERENCE_CORRECTED,
        CHECK_FOR_CORRECT_REFERENCE;

    }

    public static interface ClassNameInsertHandler {
        public static final LanguageExtension<ClassNameInsertHandler> EP_NAME = new LanguageExtension("com.intellij.classNameInsertHandler");

        public ClassNameInsertHandlerResult handleInsert(InsertionContext var1, JavaPsiClassReferenceElement var2);
    }
}

