/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypeEx;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionBundle;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.TemplateInsertHandler;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultInsertHandler
extends TemplateInsertHandler
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.DefaultInsertHandler");
    protected InsertionContext myContext;
    private LookupItem<?> myLookupItem;
    private Project myProject;
    private PsiFile myFile;
    private Editor myEditor;
    protected Document myDocument;
    private InsertHandlerState myState;

    @Override
    public void handleInsert(InsertionContext context, LookupElement item) {
        super.handleInsert(context, item);
        this.handleInsertInner(context, (LookupItem)item, context.getCompletionChar());
    }

    private void clear() {
        this.myEditor = null;
        this.myDocument = null;
        this.myProject = null;
        this.myFile = null;
        this.myState = null;
        this.myLookupItem = null;
        this.myContext = null;
    }

    private void handleInsertInner(InsertionContext context, LookupItem item, char completionChar) {
        boolean generateAnonymousBody;
        boolean hasParams;
        LOG.assertTrue(CommandProcessor.getInstance().getCurrentCommand() != null);
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
        this.myContext = context;
        this.myLookupItem = item;
        this.myProject = this.myContext.getProject();
        this.myFile = this.myContext.getFile();
        this.myEditor = this.myContext.getEditor();
        this.myDocument = this.myEditor.getDocument();
        TailType tailType = this.getTailType(completionChar);
        if (completionChar == '\r') {
            tailType = TailType.SMART_COMPLETION;
        }
        this.myState = new InsertHandlerState(this.myContext.getSelectionEndOffset(), this.myContext.getSelectionEndOffset());
        boolean needLeftParenth = this.isToInsertParenth();
        boolean bl = hasParams = needLeftParenth && this.hasParams();
        if (CompletionUtil.isOverwrite((LookupElement)item, completionChar)) {
            this.removeEndOfIdentifier(needLeftParenth && hasParams);
        } else if (this.myContext.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != this.myContext.getSelectionEndOffset()) {
            JavaCompletionUtil.resetParensInfo(context.getOffsetMap());
        }
        this.handleParenses(hasParams, needLeftParenth, tailType);
        this.handleBrackets();
        if (this.myLookupItem.getObject() instanceof PsiVariable && completionChar == '!' && PsiType.BOOLEAN.isAssignableFrom(((PsiVariable)this.myLookupItem.getObject()).getType())) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
            PsiReferenceExpression ref = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.myFile, (int)(this.myState.tailOffset - 1), PsiReferenceExpression.class, (boolean)false);
            if (ref != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByExclamation");
                this.myDocument.insertString(ref.getTextRange().getStartOffset(), (CharSequence)"!");
                ++this.myState.caretOffset;
                ++this.myState.tailOffset;
            }
        }
        RangeMarker saveMaker = null;
        boolean bl2 = generateAnonymousBody = this.myLookupItem.getAttribute(LookupItem.GENERATE_ANONYMOUS_BODY_ATTR) != null;
        if (generateAnonymousBody) {
            saveMaker = this.myDocument.createRangeMarker(this.myState.caretOffset, this.myState.caretOffset);
            this.myDocument.insertString(this.myState.tailOffset, (CharSequence)"{}");
            this.myState.caretOffset = this.myState.tailOffset + 1;
            this.myState.tailOffset += 2;
        }
        this.myContext.setTailOffset(this.myState.tailOffset);
        this.myState.caretOffset = this.processTail(tailType, this.myState.caretOffset, this.myState.tailOffset);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.myEditor.getSelectionModel().removeSelection();
        this.qualifyIfNeeded();
        if (needLeftParenth && hasParams) {
            AutoPopupController.getInstance(this.myProject).autoPopupParameterInfo(this.myEditor, null);
        }
        if (tailType == TailType.DOT) {
            AutoPopupController.getInstance(this.myProject).autoPopupMemberLookup(this.myEditor, null);
        }
        if (generateAnonymousBody) {
            context.setLaterRunnable(this.generateAnonymousBody());
            if (hasParams) {
                int offset = saveMaker.getStartOffset();
                this.myEditor.getCaretModel().moveToOffset(offset);
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                this.myEditor.getSelectionModel().removeSelection();
            }
            return;
        }
        if (completionChar == '#') {
            context.setLaterRunnable(new Runnable(){

                @Override
                public void run() {
                    new CodeCompletionHandlerBase(CompletionType.BASIC){}.invoke(DefaultInsertHandler.this.myProject, DefaultInsertHandler.this.myEditor, DefaultInsertHandler.this.myFile);
                }
            });
        }
        if (this.insertingAnnotation()) {
            PsiElement parentElement;
            PsiElement elementAt = this.myFile.findElementAt(this.myContext.getStartOffset());
            PsiElement psiElement = parentElement = elementAt != null ? elementAt.getParent() : null;
            if (elementAt instanceof PsiIdentifier && (PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiAnnotationParameterList.class) != null || parentElement instanceof PsiErrorElement && parentElement.getParent() instanceof PsiJavaFile) && this.isAtTokenNeeded()) {
                int expectedOffsetForAtToken = elementAt.getTextRange().getStartOffset();
                this.myDocument.insertString(expectedOffsetForAtToken, (CharSequence)"@");
            }
        }
    }

    private void qualifyIfNeeded() {
        try {
            if (this.myLookupItem.getObject() instanceof PsiField) {
                PsiDocumentManager.getInstance((Project)this.myFile.getProject()).commitAllDocuments();
                PsiReference reference = this.myFile.findReferenceAt(this.myContext.getStartOffset());
                if (reference instanceof PsiReferenceExpression && !((PsiReferenceExpression)reference).isQualified()) {
                    PsiField member = (PsiField)this.myLookupItem.getObject();
                    PsiVariable target = JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper().resolveReferencedVariable(member.getName(), (PsiElement)reference);
                    if (member.getManager().areElementsEquivalent((PsiElement)target, (PsiElement)JavaCompletionUtil.getOriginalElement(member))) {
                        return;
                    }
                    PsiClass psiClass = member.getContainingClass();
                    if (psiClass != null && StringUtil.isNotEmpty((String)psiClass.getName())) {
                        this.myDocument.insertString(this.myContext.getStartOffset(), (CharSequence)(psiClass.getName() + "."));
                    }
                }
            }
            DefaultInsertHandler.addImportForItem(this.myFile, this.myContext.getStartOffset(), this.myLookupItem);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean isAtTokenNeeded() {
        HighlighterIterator iterator = ((EditorEx)this.myContext.getEditor()).getHighlighter().createIterator(this.myContext.getStartOffset());
        LOG.assertTrue(iterator.getTokenType() == JavaTokenType.IDENTIFIER);
        iterator.retreat();
        if (iterator.getTokenType() == TokenType.WHITE_SPACE) {
            iterator.retreat();
        }
        return iterator.getTokenType() != JavaTokenType.AT && iterator.getTokenType() != JavaTokenType.DOT;
    }

    private void handleBrackets() {
        Integer bracketsAttr = (Integer)this.myLookupItem.getUserData(LookupItem.BRACKETS_COUNT_ATTR);
        if (bracketsAttr != null) {
            int count = bracketsAttr;
            if (count > 0) {
                this.myState.caretOffset = this.myState.tailOffset + 1;
            }
            for (int i = 0; i < count; ++i) {
                this.myDocument.insertString(this.myState.tailOffset, (CharSequence)"[]");
                this.myState.tailOffset += 2;
            }
        }
    }

    private void handleParenses(boolean hasParams, boolean needParenth, TailType tailType) {
        boolean insertRightParenth;
        boolean generateAnonymousBody = this.myLookupItem.getAttribute(LookupItem.GENERATE_ANONYMOUS_BODY_ATTR) != null;
        boolean bl = insertRightParenth = tailType != TailType.SMART_COMPLETION;
        if (needParenth) {
            if (this.myContext.getOffsetMap().getOffset(JavaCompletionUtil.LPAREN_OFFSET) >= 0 && this.myContext.getOffsetMap().getOffset(JavaCompletionUtil.ARG_LIST_END_OFFSET) >= 0) {
                this.myState.tailOffset = this.myContext.getOffsetMap().getOffset(JavaCompletionUtil.ARG_LIST_END_OFFSET);
                if (this.myContext.getOffsetMap().getOffset(JavaCompletionUtil.RPAREN_OFFSET) < 0 && insertRightParenth) {
                    this.myDocument.insertString(this.myState.tailOffset, (CharSequence)")");
                    ++this.myState.tailOffset;
                }
                this.myState.caretOffset = hasParams ? this.myContext.getOffsetMap().getOffset(JavaCompletionUtil.LPAREN_OFFSET) + 1 : this.myContext.getOffsetMap().getOffset(JavaCompletionUtil.ARG_LIST_END_OFFSET);
            } else {
                CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
                this.myState.tailOffset = this.myContext.getSelectionEndOffset();
                this.myState.caretOffset = this.myContext.getSelectionEndOffset();
                if (styleSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES) {
                    this.myDocument.insertString(this.myState.tailOffset++, (CharSequence)" ");
                    ++this.myState.caretOffset;
                }
                if (insertRightParenth) {
                    CharSequence charsSequence = this.myDocument.getCharsSequence();
                    if (charsSequence.length() <= this.myState.tailOffset || charsSequence.charAt(this.myState.tailOffset) != '(') {
                        this.myDocument.insertString(this.myState.tailOffset, (CharSequence)"(");
                    }
                    this.myDocument.insertString(this.myState.tailOffset + 1, (CharSequence)")");
                    if (hasParams) {
                        this.myState.tailOffset += 2;
                        ++this.myState.caretOffset;
                    } else if (tailType != TailTypes.CALL_RPARENTH || generateAnonymousBody) {
                        this.myState.tailOffset += 2;
                        this.myState.caretOffset += 2;
                    } else {
                        ++this.myState.tailOffset;
                        ++this.myState.caretOffset;
                    }
                } else {
                    this.myDocument.insertString(this.myState.tailOffset++, (CharSequence)"(");
                    ++this.myState.caretOffset;
                }
                if (hasParams && styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES) {
                    this.myDocument.insertString(this.myState.caretOffset++, (CharSequence)" ");
                    ++this.myState.tailOffset;
                }
            }
        }
    }

    private boolean isToInsertParenth() {
        boolean needParens = false;
        if (this.myLookupItem.getAttribute(LookupItem.NEW_OBJECT_ATTR) != null) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
            needParens = true;
            PsiClass aClass = (PsiClass)this.myLookupItem.getObject();
            PsiElement place = this.myFile.findElementAt(this.myContext.getStartOffset());
            if (this.myLookupItem.getAttribute(LookupItem.DONT_CHECK_FOR_INNERS) == null) {
                PsiClass[] classes;
                for (PsiClass inner : classes = aClass.getInnerClasses()) {
                    if (!inner.hasModifierProperty("static") || !JavaPsiFacade.getInstance((Project)inner.getProject()).getResolveHelper().isAccessible((PsiMember)inner, place, null)) continue;
                    needParens = false;
                    break;
                }
            }
        } else if (this.insertingAnnotationWithParameters()) {
            needParens = true;
        }
        return needParens;
    }

    private boolean hasParams() {
        boolean hasParms = false;
        if (this.myLookupItem.getAttribute(LookupItem.NEW_OBJECT_ATTR) != null) {
            PsiMethod[] constructors;
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
            PsiClass aClass = (PsiClass)this.myLookupItem.getObject();
            PsiElement place = this.myFile.findElementAt(this.myContext.getStartOffset());
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                if (!JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper().isAccessible((PsiMember)constructor, place, null) || constructor.getParameterList().getParametersCount() <= 0) continue;
                hasParms = true;
                break;
            }
        } else {
            String lookupString = this.myLookupItem.getLookupString();
            if ("synchronized".equals(lookupString)) {
                PsiElement place = this.myFile.findElementAt(this.myContext.getStartOffset());
                hasParms = PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{PsiMember.class, PsiCodeBlock.class}) instanceof PsiCodeBlock;
            } else if ("catch".equals(lookupString) || "switch".equals(lookupString) || "while".equals(lookupString) || "for".equals(lookupString)) {
                hasParms = true;
            } else if (this.insertingAnnotationWithParameters()) {
                hasParms = true;
            }
        }
        return hasParms;
    }

    private boolean insertingAnnotationWithParameters() {
        if (this.insertingAnnotation()) {
            PsiModifierListOwner parent;
            Document document = this.myContext.getEditor().getDocument();
            PsiDocumentManager.getInstance((Project)this.myContext.getProject()).commitDocument(document);
            PsiElement elementAt = this.myFile.findElementAt(this.myContext.getStartOffset());
            if (elementAt instanceof PsiIdentifier && (parent = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiModifierListOwner.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class})) != null) {
                for (PsiMethod m : ((PsiClass)this.myLookupItem.getObject()).getMethods()) {
                    PsiAnnotationMemberValue defaultValue;
                    if (!(m instanceof PsiAnnotationMethod) || (defaultValue = ((PsiAnnotationMethod)m).getDefaultValue()) != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean insertingAnnotation() {
        Object obj = this.myLookupItem.getObject();
        if (!(obj instanceof PsiClass) || !((PsiClass)obj).isAnnotationType()) {
            return false;
        }
        Document document = this.myEditor.getDocument();
        PsiDocumentManager.getInstance((Project)this.myFile.getProject()).commitDocument(document);
        int offset = this.myContext.getStartOffset();
        if (PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.myFile, (int)offset, PsiImportStatement.class, (boolean)false) != null) {
            return false;
        }
        if (PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.myFile, (int)offset, PsiClass.class, (boolean)false) == null) {
            return true;
        }
        return PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.myFile, (int)offset, PsiAnnotation.class, (boolean)false) != null;
    }

    protected void removeEndOfIdentifier(boolean needParenth) {
        JavaCompletionUtil.initOffsets(this.myContext.getFile(), this.myContext.getProject(), this.myContext.getOffsetMap());
        this.myDocument.deleteString(this.myContext.getSelectionEndOffset(), this.myContext.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
        if (this.myContext.getOffsetMap().getOffset(JavaCompletionUtil.LPAREN_OFFSET) > 0 && !needParenth) {
            this.myDocument.deleteString(this.myContext.getOffsetMap().getOffset(JavaCompletionUtil.LPAREN_OFFSET), this.myContext.getOffsetMap().getOffset(JavaCompletionUtil.ARG_LIST_END_OFFSET));
            JavaCompletionUtil.resetParensInfo(this.myContext.getOffsetMap());
        }
    }

    protected TailType getTailType(char completionChar) {
        switch (completionChar) {
            case '.': {
                return TailType.DOT;
            }
            case ',': {
                return TailType.COMMA;
            }
            case ';': {
                return TailType.SEMICOLON;
            }
            case '=': {
                return TailType.EQ;
            }
            case ' ': {
                return TailType.SPACE;
            }
            case ':': {
                return TailType.CASE_COLON;
            }
            case '(': {
                return TailTypeEx.SMART_LPARENTH;
            }
            case '\"': 
            case '#': 
            case '<': 
            case '>': 
            case '[': {
                return TailType.createSimpleTailType((char)completionChar);
            }
        }
        TailType attr = this.myLookupItem.getTailType();
        return attr == TailType.UNKNOWN ? TailType.NONE : attr;
    }

    private int processTail(TailType tailType, int caretOffset, int tailOffset) {
        this.myEditor.getCaretModel().moveToOffset(caretOffset);
        tailType.processTail(this.myEditor, tailOffset);
        return this.myEditor.getCaretModel().getOffset();
    }

    private Runnable generateAnonymousBody() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        int offset = this.myEditor.getCaretModel().getOffset();
        PsiElement element = this.myFile.findElementAt(offset);
        if (element == null) {
            return null;
        }
        if (element.getParent() instanceof PsiAnonymousClass) {
            try {
                CodeStyleManager.getInstance((Project)this.myProject).reformat(element.getParent());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            offset = element.getParent().getTextRange().getEndOffset() - 1;
            this.myEditor.getCaretModel().moveToOffset(offset);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this.myEditor.getSelectionModel().removeSelection();
        }
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(element);
        return new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(DefaultInsertHandler.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        PsiDocumentManager.getInstance((Project)DefaultInsertHandler.this.myProject).commitDocument(DefaultInsertHandler.this.myDocument);
                        PsiElement element = pointer.getElement();
                        if (element == null) {
                            return;
                        }
                        while (true) {
                            if (element instanceof PsiFile) {
                                return;
                            }
                            PsiElement parent = element.getParent();
                            if (parent instanceof PsiAnonymousClass) break;
                            element = parent;
                        }
                        final PsiAnonymousClass aClass = (PsiAnonymousClass)element.getParent();
                        final Collection<CandidateInfo> candidatesToImplement = OverrideImplementUtil.getMethodsToOverrideImplement((PsiClass)aClass, true);
                        boolean invokeOverride = candidatesToImplement.isEmpty();
                        if (invokeOverride) {
                            DefaultInsertHandler.chooseAndOverrideMethodsInAdapter(DefaultInsertHandler.this.myProject, DefaultInsertHandler.this.myEditor, aClass);
                        } else {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        List<PsiMethod> methods = OverrideImplementUtil.overrideOrImplementMethodCandidates((PsiClass)aClass, candidatesToImplement, false);
                                        List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.convert2GenerationInfos(methods);
                                        List<PsiGenerationInfo<PsiMethod>> resultMembers = GenerateMembersUtil.insertMembersBeforeAnchor((PsiClass)aClass, null, prototypes);
                                        GenerateMembersUtil.positionCaret(DefaultInsertHandler.this.myEditor, (PsiElement)resultMembers.get(0).getPsiMember(), true);
                                    }
                                    catch (IncorrectOperationException ioe) {
                                        LOG.error((Throwable)ioe);
                                    }
                                }
                            });
                        }
                        DefaultInsertHandler.this.clear();
                    }
                }, CompletionBundle.message("completion.smart.type.generate.anonymous.body", new Object[0]), null, UndoConfirmationPolicy.DEFAULT, DefaultInsertHandler.this.myDocument);
            }
        };
    }

    private static void chooseAndOverrideMethodsInAdapter(Project project, final Editor editor, final PsiAnonymousClass aClass) {
        PsiClass baseClass = aClass.getBaseClassType().resolve();
        if (baseClass == null) {
            return;
        }
        PsiMethod[] allBaseMethods = baseClass.getMethods();
        if (allBaseMethods.length == 0) {
            return;
        }
        ArrayList<PsiMethodMember> methods = new ArrayList<PsiMethodMember>();
        for (PsiMethod method : allBaseMethods) {
            if (!OverrideImplementUtil.isOverridable(method)) continue;
            methods.add(new PsiMethodMember(method, PsiSubstitutor.UNKNOWN));
        }
        boolean canInsertOverride = PsiUtil.isLanguageLevel5OrHigher((PsiElement)aClass) && (PsiUtil.isLanguageLevel6OrHigher((PsiElement)aClass) || !aClass.isInterface());
        ClassMember[] array = methods.toArray(new PsiMethodMember[methods.size()]);
        MemberChooser chooser = new MemberChooser(array, false, true, project, canInsertOverride);
        chooser.setTitle(CompletionBundle.message("completion.smarttype.select.methods.to.override", new Object[0]));
        chooser.setCopyJavadocVisible(true);
        chooser.show();
        List<PsiMethodMember> selected = chooser.getSelectedElements();
        if (selected == null || selected.isEmpty()) {
            return;
        }
        try {
            final List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.overrideOrImplementMethods((PsiClass)aClass, selected, chooser.isCopyJavadoc(), chooser.isInsertOverrideAnnotation());
            final int offset = editor.getCaretModel().getOffset();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (PsiGenerationInfo prototype : prototypes) {
                            PsiStatement[] statements = ((PsiMethod)prototype.getPsiMember()).getBody().getStatements();
                            if (statements.length <= 0 || !PsiType.VOID.equals(((PsiMethod)prototype.getPsiMember()).getReturnType())) continue;
                            statements[0].delete();
                        }
                        List resultMembers = GenerateMembersUtil.insertMembersAtOffset(aClass.getContainingFile(), offset, prototypes);
                        GenerateMembersUtil.positionCaret(editor, ((PsiGenerationInfo)resultMembers.get(0)).getPsiMember(), true);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        }
        catch (IncorrectOperationException ioe) {
            LOG.error((Throwable)ioe);
        }
    }

    @Override
    protected void populateInsertMap(@NotNull PsiFile file, @NotNull OffsetMap offsetMap) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/DefaultInsertHandler.populateInsertMap must not be null");
        }
        if (offsetMap == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/DefaultInsertHandler.populateInsertMap must not be null");
        }
        JavaCompletionUtil.initOffsets(file, file.getProject(), offsetMap);
    }

    public static void addImportForItem(PsiFile file, int startOffset, LookupElement item) throws IncorrectOperationException {
        PsiClass aClass;
        PsiMethod method;
        PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        Object o = item.getObject();
        if (o instanceof PsiClass) {
            PsiClass aClass2 = (PsiClass)o;
            if (aClass2.getQualifiedName() == null) {
                return;
            }
            String lookupString = item.getLookupString();
            int length = lookupString.length();
            int i = lookupString.indexOf(60);
            if (i >= 0) {
                length = i;
            }
            int newOffset = DefaultInsertHandler.addImportForClass(file, startOffset, startOffset + length, aClass2);
            DefaultInsertHandler.shortenReference(file, newOffset);
        } else if (o instanceof PsiType) {
            PsiClass refClass;
            PsiType type = ((PsiType)o).getDeepComponentType();
            if (type instanceof PsiClassType && (refClass = ((PsiClassType)type).resolve()) != null) {
                int length = refClass.getName().length();
                DefaultInsertHandler.addImportForClass(file, startOffset, startOffset + length, refClass);
            }
        } else if (o instanceof PsiMethod && (method = (PsiMethod)o).isConstructor() && (aClass = method.getContainingClass()) != null) {
            int length = method.getName().length();
            DefaultInsertHandler.addImportForClass(file, startOffset, startOffset + length, aClass);
        }
    }

    private static void shortenReference(PsiFile file, int offset) throws IncorrectOperationException {
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
        Document document = manager.getDocument(file);
        manager.commitDocument(document);
        PsiReference ref = file.findReferenceAt(offset);
        if (ref instanceof PsiJavaCodeReferenceElement) {
            JavaCodeStyleManager.getInstance((Project)file.getProject()).shortenClassReferences((PsiElement)((PsiJavaCodeReferenceElement)ref));
        }
    }

    private static int addImportForClass(PsiFile file, int startOffset, int endOffset, PsiClass aClass) throws IncorrectOperationException {
        PsiElement parent;
        PsiElement resolved;
        if (!aClass.isValid()) {
            return startOffset;
        }
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiElementPointer((PsiElement)aClass);
        LOG.assertTrue(CommandProcessor.getInstance().getCurrentCommand() != null);
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().getCurrentWriteAction(null) != null);
        PsiManager manager = file.getManager();
        Document document = FileDocumentManager.getInstance().getDocument(file.getViewProvider().getVirtualFile());
        PsiReference reference = file.findReferenceAt(startOffset);
        if (reference != null && (resolved = reference.resolve()) instanceof PsiClass && (((PsiClass)resolved).getQualifiedName() == null || manager.areElementsEquivalent((PsiElement)aClass, resolved))) {
            return startOffset;
        }
        String name = aClass.getName();
        document.replaceString(startOffset, endOffset, (CharSequence)name);
        RangeMarker toDelete = DefaultInsertHandler.insertSpace(endOffset, document);
        PsiDocumentManager.getInstance((Project)manager.getProject()).commitAllDocuments();
        int newStartOffset = startOffset;
        PsiElement element = file.findElementAt(startOffset);
        if (element instanceof PsiIdentifier && (parent = element.getParent()) instanceof PsiJavaCodeReferenceElement && !((PsiJavaCodeReferenceElement)parent).isQualified() && !(parent.getParent() instanceof PsiPackageStatement)) {
            PsiElement pointerElement;
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)parent;
            if (!aClass.getManager().areElementsEquivalent((PsiElement)aClass, DefaultInsertHandler.resolveReference((PsiReference)ref)) && (pointerElement = pointer.getElement()) instanceof PsiClass) {
                Object newElement = !(ref instanceof PsiImportStaticReferenceElement) ? ref.bindToElement(pointerElement) : ((PsiImportStaticReferenceElement)ref).bindToTargetClass((PsiClass)pointerElement);
                RangeMarker marker = document.createRangeMarker(newElement.getTextRange());
                CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(newElement);
                newStartOffset = marker.getStartOffset();
            }
        }
        if (toDelete.isValid()) {
            document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
        }
        return newStartOffset;
    }

    public static RangeMarker insertSpace(int endOffset, Document document) {
        RangeMarker toDelete;
        CharSequence chars = document.getCharsSequence();
        int length = chars.length();
        if (endOffset < length && Character.isJavaIdentifierPart(chars.charAt(endOffset))) {
            document.insertString(endOffset, (CharSequence)" ");
            toDelete = document.createRangeMarker(endOffset, endOffset + 1);
        } else {
            toDelete = endOffset >= length ? document.createRangeMarker(length, length) : document.createRangeMarker(endOffset, endOffset);
        }
        toDelete.setGreedyToLeft(true);
        toDelete.setGreedyToRight(true);
        return toDelete;
    }

    static PsiElement resolveReference(PsiReference psiReference) {
        ResolveResult[] results;
        if (psiReference instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)psiReference).multiResolve(true)).length == 1) {
            return results[0].getElement();
        }
        return psiReference.resolve();
    }

    public static class InsertHandlerState {
        int tailOffset;
        int caretOffset;

        public InsertHandlerState(int caretOffset, int tailOffset) {
            this.caretOffset = caretOffset;
            this.tailOffset = tailOffset;
        }
    }
}

