/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.FilePathCompletionContributor");

    public FilePathCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/FilePathCompletionContributor$1.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/FilePathCompletionContributor$1.addCompletions must not be null");
                }
                PsiReference psiReference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
                if (FilePathCompletionContributor.getReference(psiReference) != null) {
                    String shortcut = CompletionContributor.getActionShortcut((String)"ClassNameCompletion");
                    CompletionService service = CompletionService.getCompletionService();
                    if (shortcut != null) {
                        service.setAdvertisementText(CodeInsightBundle.message((String)"class.completion.file.path", (Object[])new Object[]{shortcut}));
                    }
                }
            }
        });
        this.extend(CompletionType.CLASS_NAME, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(false){

            protected void addCompletions(final @NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet _result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/FilePathCompletionContributor$2.addCompletions must not be null");
                }
                if (_result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/FilePathCompletionContributor$2.addCompletions must not be null");
                }
                CompletionResultSet result = _result.caseInsensitive();
                PsiElement e = parameters.getPosition();
                final Project project = e.getProject();
                PsiReference psiReference = (PsiReference)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiReference>(){

                    public PsiReference compute() {
                        return parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
                    }
                });
                Pair fileReferencePair = FilePathCompletionContributor.getReference(psiReference);
                if (fileReferencePair != null) {
                    FileReference first = (FileReference)fileReferencePair.getFirst();
                    if (first == null) {
                        return;
                    }
                    FileReferenceSet set = first.getFileReferenceSet();
                    String prefix = set.getPathString().substring(0, parameters.getOffset() - set.getElement().getTextRange().getStartOffset() - set.getStartInElement());
                    final List[] pathPrefixParts = new List[]{null};
                    int lastSlashIndex = prefix.lastIndexOf(47);
                    if (lastSlashIndex != -1) {
                        pathPrefixParts[0] = StringUtil.split((String)prefix.substring(0, lastSlashIndex), (String)"/");
                        prefix = prefix.substring(lastSlashIndex + 1);
                    }
                    final CompletionResultSet __result = result.withPrefixMatcher(prefix).caseInsensitive();
                    PsiFile originalFile = parameters.getOriginalFile();
                    final VirtualFile contextFile = originalFile.getVirtualFile();
                    if (contextFile != null) {
                        String[] fileNames = FilePathCompletionContributor.getAllNames(project);
                        TreeSet<String> resultNames = new TreeSet<String>();
                        for (String fileName : fileNames) {
                            if (!FilePathCompletionContributor.filenameMatchesPrefixOrType(fileName, prefix, set.getSuitableFileTypes(), parameters.getInvocationCount())) continue;
                            resultNames.add(fileName);
                        }
                        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
                        Module contextModule = index.getModuleForFile(contextFile);
                        if (contextModule != null) {
                            final FileReferenceHelper contextHelper = FileReferenceHelperRegistrar.getNotNullHelper(originalFile);
                            final GlobalSearchScope scope = ProjectScope.getProjectScope((Project)project);
                            for (final String name : resultNames) {
                                ProgressManager.checkCanceled();
                                PsiFile[] files = (PsiFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile[]>(){

                                    public PsiFile[] compute() {
                                        return FilenameIndex.getFilesByName(project, name, scope);
                                    }
                                });
                                if (files.length <= 0) continue;
                                for (final PsiFile file : files) {
                                    ProgressManager.checkCanceled();
                                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                                        @Override
                                        public void run() {
                                            VirtualFile virtualFile = file.getVirtualFile();
                                            if (virtualFile != null && virtualFile.isValid() && virtualFile != contextFile && contextHelper.isMine(project, virtualFile) && (pathPrefixParts[0] == null || FilePathCompletionContributor.fileMatchesPathPrefix(contextHelper.getPsiFileSystemItem(project, virtualFile), pathPrefixParts[0]))) {
                                                __result.addElement((LookupElement)new FilePathLookupItem(file, contextHelper));
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    }
                    if (set.getSuitableFileTypes().length > 0 && parameters.getInvocationCount() == 1) {
                        String shortcut = CompletionContributor.getActionShortcut((String)"ClassNameCompletion");
                        CompletionService service = CompletionService.getCompletionService();
                        if (shortcut != null) {
                            service.setAdvertisementText(CodeInsightBundle.message((String)"class.completion.file.path.all.variants", (Object[])new Object[]{shortcut}));
                        }
                    }
                    if (((Boolean)fileReferencePair.getSecond()).booleanValue()) {
                        result.stopHere();
                    }
                }
            }
        });
    }

    private static boolean filenameMatchesPrefixOrType(String fileName, String prefix, FileType[] suitableFileTypes, int invocationCount) {
        boolean prefixMatched;
        boolean bl = prefixMatched = prefix.length() == 0 || StringUtil.startsWithIgnoreCase((String)fileName, (String)prefix);
        if (prefixMatched && (suitableFileTypes.length == 0 || invocationCount > 1)) {
            return true;
        }
        if (prefixMatched) {
            String extension = FileUtil.getExtension((String)fileName);
            if (extension.length() == 0) {
                return false;
            }
            for (FileType fileType : suitableFileTypes) {
                List matchers = FileTypeManager.getInstance().getAssociations(fileType);
                for (FileNameMatcher matcher : matchers) {
                    if (!matcher.accept(fileName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean fileMatchesPathPrefix(@Nullable PsiFileSystemItem file, @NotNull List<String> pathPrefix) {
        PsiFileSystemItem parent;
        if (pathPrefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/FilePathCompletionContributor.fileMatchesPathPrefix must not be null");
        }
        if (file == null) {
            return false;
        }
        ArrayList<String> contextParts = new ArrayList<String>();
        PsiFileSystemItem parentFile = file;
        while ((parent = parentFile.getParent()) != null) {
            if (parent.getName().length() > 0) {
                contextParts.add(0, parent.getName().toLowerCase());
            }
            parentFile = parent;
        }
        String path = StringUtil.join(contextParts, (String)"/");
        int nextIndex = 0;
        for (String s : pathPrefix) {
            nextIndex = path.indexOf(s.toLowerCase(), nextIndex);
            if (nextIndex != -1) continue;
            return false;
        }
        return true;
    }

    private static String[] getAllNames(final @NotNull Project project) {
        ChooseByNameContributor[] nameContributors;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/FilePathCompletionContributor.getAllNames must not be null");
        }
        HashSet names = new HashSet();
        for (final ChooseByNameContributor contributor : nameContributors = (ChooseByNameContributor[])ChooseByNameContributor.FILE_EP_NAME.getExtensions()) {
            try {
                names.addAll((Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<? extends String>>(){

                    public Collection<? extends String> compute() {
                        return Arrays.asList(contributor.getNames(project, false));
                    }
                }));
            }
            catch (ProcessCanceledException ex) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
        return ArrayUtil.toStringArray(names);
    }

    @Nullable
    private static Pair<FileReference, Boolean> getReference(PsiReference original) {
        FileReference fileReference;
        if (original == null) {
            return null;
        }
        if (original instanceof PsiMultiReference) {
            PsiMultiReference multiReference = (PsiMultiReference)original;
            for (PsiReference reference : multiReference.getReferences()) {
                if (!(reference instanceof FileReference)) continue;
                return Pair.create((Object)((FileReference)reference), (Object)false);
            }
        } else if (original instanceof FileReferenceOwner && (fileReference = ((FileReferenceOwner)original).getLastFileReference()) != null) {
            return Pair.create((Object)fileReference, (Object)true);
        }
        return null;
    }

    public class FilePathLookupItem
    extends LookupElement {
        private final String myName;
        private final String myPath;
        private final String myInfo;
        private final Icon myIcon;
        private final PsiFile myFile;
        private FileReferenceHelper myReferenceHelper;

        public FilePathLookupItem(@NotNull PsiFile file, FileReferenceHelper referenceHelper) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem.<init> must not be null");
            }
            if (referenceHelper == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem.<init> must not be null");
            }
            this.myName = file.getName();
            this.myPath = file.getVirtualFile().getPath();
            this.myReferenceHelper = referenceHelper;
            this.myInfo = FileInfoManager.getFileAdditionalInfo((PsiElement)file);
            this.myIcon = file.getFileType().getIcon();
            this.myFile = file;
        }

        public String toString() {
            return String.format("%s%s", this.myName, this.myInfo == null ? "" : " (" + this.myInfo + ")");
        }

        @NotNull
        public Object getObject() {
            PsiFile psiFile = this.myFile;
            if (psiFile == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem.getObject must not return null");
            }
            return psiFile;
        }

        @NotNull
        public String getLookupString() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem.getLookupString must not return null");
            }
            return string;
        }

        public void handleInsert(InsertionContext context) {
            if (this.myFile.isValid()) {
                PsiReference psiReference = context.getFile().findReferenceAt(context.getStartOffset());
                Pair fileReferencePair = FilePathCompletionContributor.getReference(psiReference);
                LOG.assertTrue(fileReferencePair != null);
                ((FileReference)fileReferencePair.getFirst()).bindToElement((PsiElement)this.myFile, true);
            }
        }

        public void renderElement(LookupElementPresentation presentation) {
            VirtualFile virtualFile = this.myFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            PsiFileSystemItem root = this.myReferenceHelper.findRoot(this.myFile.getProject(), virtualFile);
            String relativePath = PsiFileSystemItemUtil.getRelativePath(root, this.myReferenceHelper.getPsiFileSystemItem(this.myFile.getProject(), virtualFile));
            StringBuilder sb = new StringBuilder();
            if (this.myInfo != null) {
                sb.append(" (").append(this.myInfo);
            }
            if (relativePath != null && !relativePath.equals(this.myName)) {
                if (this.myInfo != null) {
                    sb.append(", ");
                } else {
                    sb.append(" (");
                }
                sb.append(relativePath);
            }
            if (sb.length() > 0) {
                sb.append(')');
            }
            presentation.setItemText(this.myName);
            if (sb.length() > 0) {
                presentation.setTailText(sb.toString(), true);
            }
            presentation.setIcon(this.myIcon);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            FilePathLookupItem that = (FilePathLookupItem)((Object)o);
            if (!this.myName.equals(that.myName)) {
                return false;
            }
            return this.myPath.equals(that.myPath);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.myPath.hashCode();
            return result;
        }
    }
}

