/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.actions.AddSuppressInspectionFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSuppressInspectionAllForClassFix
extends AddSuppressInspectionFix {
    @NonNls
    private static final String ID = "ALL";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.actions.AddNoInspectionAllForClassFix");

    public AddSuppressInspectionAllForClassFix() {
        super(ID);
    }

    @Override
    @Nullable
    protected PsiDocCommentOwner getContainer(PsiElement element) {
        PsiDocCommentOwner container = super.getContainer(element);
        if (container == null) {
            return null;
        }
        while (container != null) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)container, PsiClass.class);
            if (parentClass == null && container instanceof PsiClass) {
                return container;
            }
            container = parentClass;
        }
        return container;
    }

    @Override
    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"suppress.all.for.class", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/actions/AddSuppressInspectionAllForClassFix.getText must not return null");
        }
        return string;
    }

    @Override
    public void invoke(Project project, Editor editor, PsiElement element) throws IncorrectOperationException {
        PsiDocCommentOwner container = this.getContainer(element);
        LOG.assertTrue(container != null);
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{container.getContainingFile().getVirtualFile()});
        if (status.hasReadonlyFiles()) {
            return;
        }
        if (this.use15Suppressions(container)) {
            PsiAnnotation annotation;
            PsiModifierList modifierList = container.getModifierList();
            if (modifierList != null && (annotation = modifierList.findAnnotation("java.lang.SuppressWarnings")) != null) {
                annotation.replace((PsiElement)JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@java.lang.SuppressWarnings({\"ALL\"})", (PsiElement)container));
                return;
            }
        } else {
            PsiDocTag noInspectionTag;
            PsiDocComment docComment = container.getDocComment();
            if (docComment != null && (noInspectionTag = docComment.findTagByName("noinspection")) != null) {
                String tagText = "@noinspection ALL";
                noInspectionTag.replace((PsiElement)JavaPsiFacade.getInstance((Project)project).getElementFactory().createDocTagFromText(tagText, null));
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
                return;
            }
        }
        super.invoke(project, editor, element);
    }
}

