/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreatePropertyFromUsageFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreatePropertyFromUsageFix");
    @NonNls
    private static final String FIELD_VARIABLE = "FIELD_NAME_VARIABLE";
    @NonNls
    private static final String TYPE_VARIABLE = "FIELD_TYPE_VARIABLE";
    @NonNls
    private static final String GET_PREFIX = "get";
    @NonNls
    private static final String IS_PREFIX = "is";
    @NonNls
    private static final String SET_PREFIX = "set";
    private final PsiMethodCallExpression myMethodCall;

    public CreatePropertyFromUsageFix(PsiMethodCallExpression methodCall) {
        this.myMethodCall = methodCall;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.property.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreatePropertyFromUsageFix.getFamilyName must not return null");
        }
        return string;
    }

    @Override
    protected PsiElement getElement() {
        if (!this.myMethodCall.isValid() || !this.myMethodCall.getManager().isInProject((PsiElement)this.myMethodCall)) {
            return null;
        }
        return this.myMethodCall;
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        if (CreateMethodFromUsageFix.hasErrorsInArgumentList(this.myMethodCall)) {
            return false;
        }
        PsiReferenceExpression ref = this.myMethodCall.getMethodExpression();
        String methodName = this.myMethodCall.getMethodExpression().getReferenceName();
        LOG.assertTrue(methodName != null);
        String propertyName = PropertyUtil.getPropertyName((String)methodName);
        if (propertyName == null || propertyName.length() == 0) {
            return false;
        }
        String getterOrSetter = null;
        if (methodName.startsWith(GET_PREFIX) || methodName.startsWith(IS_PREFIX)) {
            if (this.myMethodCall.getArgumentList().getExpressions().length != 0) {
                return false;
            }
            getterOrSetter = QuickFixBundle.message("create.getter", new Object[0]);
        } else if (methodName.startsWith(SET_PREFIX)) {
            if (this.myMethodCall.getArgumentList().getExpressions().length != 1) {
                return false;
            }
            getterOrSetter = QuickFixBundle.message("create.setter", new Object[0]);
        } else {
            LOG.error("Internal error in create property intention");
        }
        List<PsiClass> classes = this.getTargetClasses((PsiElement)this.myMethodCall);
        if (classes.isEmpty()) {
            return false;
        }
        for (PsiClass aClass : classes) {
            if (aClass.isInterface()) continue;
            if (CreateFromUsageUtils.shouldShowTag(offset, ref.getReferenceNameElement(), (PsiElement)this.myMethodCall)) {
                this.setText(getterOrSetter);
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        List<PsiClass> list;
        List<PsiClass> all = super.getTargetClasses(element);
        if (all.isEmpty()) {
            list = all;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreatePropertyFromUsageFix.getTargetClasses must not return null");
            return list;
        }
        ArrayList<PsiClass> nonInterfaces = new ArrayList<PsiClass>();
        for (PsiClass aClass : all) {
            if (aClass.isInterface()) continue;
            nonInterfaces.add(aClass);
        }
        list = nonInterfaces;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreatePropertyFromUsageFix.getTargetClasses must not return null");
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        PsiType type;
        PsiType[] expectedTypes;
        PsiManager manager = this.myMethodCall.getManager();
        final Project project = manager.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        boolean isStatic = false;
        PsiExpression qualifierExpression = this.myMethodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression != null) {
            PsiReference reference = qualifierExpression.getReference();
            if (reference != null) {
                isStatic = reference.resolve() instanceof PsiClass;
            }
        } else {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myMethodCall, PsiMethod.class);
            if (method != null) {
                isStatic = method.hasModifierProperty("static");
            }
        }
        String fieldName = CreatePropertyFromUsageFix.getVariableName(this.myMethodCall, isStatic);
        LOG.assertTrue(fieldName != null);
        String callText = this.myMethodCall.getMethodExpression().getReferenceName();
        LOG.assertTrue(callText != null, (Object)this.myMethodCall.getMethodExpression());
        if (callText.startsWith(GET_PREFIX)) {
            expectedTypes = CreateFromUsageUtils.guessType((PsiExpression)this.myMethodCall, false);
            type = expectedTypes[0];
        } else if (callText.startsWith(IS_PREFIX)) {
            type = PsiType.BOOLEAN;
            expectedTypes = new PsiType[]{type};
        } else {
            type = this.myMethodCall.getArgumentList().getExpressions()[0].getType();
            if (type == null || PsiType.NULL.equals(type)) {
                type = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)this.myMethodCall.getResolveScope());
            }
            expectedTypes = new PsiType[]{type};
        }
        CreatePropertyFromUsageFix.positionCursor(project, targetClass.getContainingFile(), (PsiElement)targetClass);
        IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
        try {
            PsiTypeElement typeReference;
            PsiExpression fieldReference;
            PsiCodeBlock body;
            PsiMethod accessor;
            PsiField field = targetClass.findFieldByName(fieldName, true);
            if (field == null) {
                field = factory.createField(fieldName, type);
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)isStatic);
            }
            if (callText.startsWith(GET_PREFIX) || callText.startsWith(IS_PREFIX)) {
                accessor = (PsiMethod)targetClass.add((PsiElement)PropertyUtil.generateGetterPrototype((PsiField)field));
                body = accessor.getBody();
                LOG.assertTrue(body != null, (Object)accessor.getText());
                fieldReference = ((PsiReturnStatement)body.getStatements()[0]).getReturnValue();
                typeReference = accessor.getReturnTypeElement();
            } else {
                accessor = (PsiMethod)targetClass.add((PsiElement)PropertyUtil.generateSetterPrototype((PsiField)field, (PsiClass)targetClass));
                body = accessor.getBody();
                LOG.assertTrue(body != null, (Object)accessor.getText());
                PsiAssignmentExpression expr = (PsiAssignmentExpression)((PsiExpressionStatement)body.getStatements()[0]).getExpression();
                fieldReference = ((PsiReferenceExpression)expr.getLExpression()).getReferenceNameElement();
                typeReference = accessor.getParameterList().getParameters()[0].getTypeElement();
            }
            accessor.setName(callText);
            PsiUtil.setModifierProperty((PsiModifierListOwner)accessor, (String)"static", (boolean)isStatic);
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)accessor);
            builder.replaceElement((PsiElement)typeReference, TYPE_VARIABLE, (Expression)new TypeExpression(project, expectedTypes), true);
            builder.replaceElement((PsiElement)fieldReference, FIELD_VARIABLE, (Expression)new FieldExpression(field, targetClass, expectedTypes), true);
            builder.setEndVariableAfter((PsiElement)body.getLBrace());
            accessor = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(accessor);
            targetClass = accessor.getContainingClass();
            LOG.assertTrue(targetClass != null);
            Template template = builder.buildTemplate();
            TextRange textRange = accessor.getTextRange();
            final PsiFile file = targetClass.getContainingFile();
            final Editor editor = CreatePropertyFromUsageFix.positionCursor(project, targetClass.getContainingFile(), (PsiElement)accessor);
            editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
            editor.getCaretModel().moveToOffset(textRange.getStartOffset());
            final boolean isStatic1 = isStatic;
            CreatePropertyFromUsageFix.startTemplate(editor, template, project, new TemplateEditingAdapter(){

                @Override
                public void beforeTemplateFinished(final TemplateState state, Template template) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            String fieldName = state.getVariableValue(CreatePropertyFromUsageFix.FIELD_VARIABLE).getText();
                            if (!JavaPsiFacade.getInstance((Project)project).getNameHelper().isIdentifier(fieldName)) {
                                return;
                            }
                            String fieldType = state.getVariableValue(CreatePropertyFromUsageFix.TYPE_VARIABLE).getText();
                            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
                            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                            if (aClass == null) {
                                return;
                            }
                            if (aClass.findFieldByName(fieldName, true) != null) {
                                return;
                            }
                            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
                            try {
                                PsiType type = factory.createTypeFromText(fieldType, (PsiElement)aClass);
                                try {
                                    PsiField field = factory.createField(fieldName, type);
                                    field = (PsiField)aClass.add((PsiElement)field);
                                    PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)isStatic1);
                                    CreateFromUsageBaseFix.positionCursor(project, field.getContainingFile(), (PsiElement)field);
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                            catch (IncorrectOperationException e) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static String getVariableName(PsiMethodCallExpression methodCall, boolean isStatic) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)methodCall.getProject());
        String methodName = methodCall.getMethodExpression().getReferenceName();
        String propertyName = PropertyUtil.getPropertyName((String)methodName);
        if (propertyName != null && propertyName.length() > 0) {
            VariableKind kind = isStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
            return codeStyleManager.propertyNameToVariableName(propertyName, kind);
        }
        return null;
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
        return methodCall.getMethodExpression().resolve() != null;
    }

    static class FieldExpression
    extends Expression {
        private final String myDefaultFieldName;
        private final PsiField myField;
        private final PsiClass myClass;
        private final PsiType[] myExpectedTypes;

        public FieldExpression(PsiField field, PsiClass aClass, PsiType[] expectedTypes) {
            this.myField = field;
            this.myClass = aClass;
            this.myExpectedTypes = expectedTypes;
            this.myDefaultFieldName = field.getName();
        }

        public Result calculateResult(ExpressionContext context) {
            return new TextResult(this.myDefaultFieldName);
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return new TextResult(this.myDefaultFieldName);
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            PsiField[] fields;
            LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
            set.add(LookupItemUtil.objectToLookupItem(this.myField));
            for (PsiField otherField : fields = this.myClass.getFields()) {
                if (this.myDefaultFieldName.equals(otherField.getName())) continue;
                PsiType otherType = otherField.getType();
                for (PsiType type : this.myExpectedTypes) {
                    if (!type.equals(otherType)) continue;
                    set.add(LookupItemUtil.objectToLookupItem(otherField));
                }
            }
            if (set.size() < 2) {
                return null;
            }
            return set.toArray(new LookupElement[set.size()]);
        }
    }
}

