/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.daemon.impl.quickfix.LocateLibraryDialog;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OrderEntryFix
implements IntentionAction,
LocalQuickFix {
    private OrderEntryFix() {
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix.getName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix.applyFix must not be null");
        }
        try {
            this.invoke(project, null, descriptor.getPsiElement().getContainingFile());
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static List<LocalQuickFix> registerFixes(@NotNull QuickFixActionRegistrar registrar, final PsiReference reference) {
        PsiClass[] classes;
        if (registrar == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix.registerFixes must not be null");
        }
        PsiElement psiElement = reference.getElement();
        final String referenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project = psiElement.getProject();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile classVFile = containingFile.getVirtualFile();
        if (classVFile == null) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        final Module currentModule = fileIndex.getModuleForFile(classVFile);
        if (currentModule == null) {
            return null;
        }
        if ("TestCase".equals(referenceName) || OrderEntryFix.isAnnotation(psiElement) && OrderEntryFix.isJunitAnnotationName(referenceName)) {
            final boolean isJunit4 = !referenceName.equals("TestCase");
            final String className = isJunit4 ? "org.junit." + referenceName : "junit.framework.TestCase";
            PsiClass found = JavaPsiFacade.getInstance((Project)project).findClass(className, currentModule.getModuleWithDependenciesAndLibrariesScope(true));
            if (found != null) {
                return null;
            }
            OrderEntryFix fix = new OrderEntryFix(){

                @NotNull
                public String getText() {
                    String string = QuickFixBundle.message("orderEntry.fix.add.junit.jar.to.classpath", new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$1.getText must not return null");
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = this.getText();
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$1.getFamilyName must not return null");
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$1.isAvailable must not be null");
                    }
                    return !project.isDisposed() && !currentModule.isDisposed();
                }

                public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$1.invoke must not be null");
                    }
                    String jarPath = isJunit4 ? JavaSdkUtil.getJunit4JarPath() : JavaSdkUtil.getJunit3JarPath();
                    1.addBundledJarToRoots(project, editor, currentModule, reference, className, jarPath);
                }
            };
            registrar.register((IntentionAction)fix);
            return Arrays.asList(fix);
        }
        if (OrderEntryFix.isAnnotation(psiElement) && AnnotationUtil.isJetbrainsAnnotation((String)referenceName)) {
            String className = "org.jetbrains.annotations." + referenceName;
            PsiClass found = JavaPsiFacade.getInstance((Project)project).findClass(className, currentModule.getModuleWithDependenciesAndLibrariesScope(true));
            if (found != null) {
                return null;
            }
            OrderEntryFix fix = new OrderEntryFix(){

                @NotNull
                public String getText() {
                    String string = QuickFixBundle.message("orderEntry.fix.add.annotations.jar.to.classpath", new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$2.getText must not return null");
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = this.getText();
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$2.getFamilyName must not return null");
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$2.isAvailable must not be null");
                    }
                    return !project.isDisposed() && !currentModule.isDisposed();
                }

                public void invoke(final @NotNull Project project, final Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$2.invoke must not be null");
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            final LocateLibraryDialog dialog = new LocateLibraryDialog(currentModule, PathManager.getLibPath(), "annotations.jar", QuickFixBundle.message("add.library.annotations.description", new Object[0]));
                            dialog.show();
                            if (dialog.isOK()) {
                                new WriteCommandAction(project, new PsiFile[0]){

                                    protected void run(Result result) throws Throwable {
                                        OrderEntryFix.addBundledJarToRoots(project, editor, currentModule, reference, "org.jetbrains.annotations." + referenceName, dialog.getResultingLibraryPath());
                                    }
                                }.execute();
                            }
                        }
                    });
                }
            };
            registrar.register((IntentionAction)fix);
            return Arrays.asList(fix);
        }
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        THashSet librariesToAdd = new THashSet();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)psiElement.getProject());
        for (final PsiClass aClass : classes = facade.getShortNamesCache().getClassesByName(referenceName, GlobalSearchScope.allScope((Project)project))) {
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || (psiFile = aClass.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            final Module classModule = fileIndex.getModuleForFile(virtualFile);
            if (classModule != null && classModule != currentModule && !ModuleRootManager.getInstance((Module)currentModule).isDependsOn(classModule)) {
                OrderEntryFix fix = new OrderEntryFix(){

                    @NotNull
                    public String getText() {
                        String string = QuickFixBundle.message("orderEntry.fix.add.dependency.on.module", classModule.getName());
                        if (string == null) {
                            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$3.getText must not return null");
                        }
                        return string;
                    }

                    @NotNull
                    public String getFamilyName() {
                        String string = QuickFixBundle.message("orderEntry.fix.family.add.module.dependency", new Object[0]);
                        if (string == null) {
                            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$3.getFamilyName must not return null");
                        }
                        return string;
                    }

                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                        if (project == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$3.isAvailable must not be null");
                        }
                        return !project.isDisposed() && !classModule.isDisposed() && !currentModule.isDisposed();
                    }

                    public void invoke(final @NotNull Project project, final @Nullable Editor editor, PsiFile file) {
                        if (project == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$3.invoke must not be null");
                        }
                        Runnable doit = new Runnable(){

                            @Override
                            public void run() {
                                ModifiableRootModel model = ModuleRootManager.getInstance((Module)currentModule).getModifiableModel();
                                model.addModuleOrderEntry(classModule);
                                model.commit();
                                if (editor != null) {
                                    new AddImportAction(project, reference, editor, aClass).execute();
                                }
                            }
                        };
                        Pair circularModules = ModuleCompilerUtil.addingDependencyFormsCircularity((Module)currentModule, (Module)classModule);
                        if (circularModules == null) {
                            doit.run();
                        } else {
                            OrderEntryFix.showCircularWarningAndContinue(project, (Pair<Module, Module>)circularModules, classModule, doit);
                        }
                    }
                };
                registrar.register((IntentionAction)fix);
                result.add(fix);
            }
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)currentModule).getFileIndex();
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(virtualFile)) {
                VirtualFile jar;
                VirtualFile[] files;
                LibraryOrderEntry libraryEntry;
                Library library;
                if (!(orderEntry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)orderEntry).getLibrary()) == null || (files = library.getFiles(OrderRootType.CLASSES)).length == 0 || (jar = files[0]) == null || libraryEntry.isModuleLevel() && !librariesToAdd.add(jar) || !librariesToAdd.add(library) || moduleFileIndex.getOrderEntryForFile(virtualFile) != null) continue;
                OrderEntryFix fix = new OrderEntryFix(){

                    @NotNull
                    public String getText() {
                        String string = QuickFixBundle.message("orderEntry.fix.add.library.to.classpath", libraryEntry.getPresentableName());
                        if (string == null) {
                            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$4.getText must not return null");
                        }
                        return string;
                    }

                    @NotNull
                    public String getFamilyName() {
                        String string = QuickFixBundle.message("orderEntry.fix.family.add.library.to.classpath", new Object[0]);
                        if (string == null) {
                            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$4.getFamilyName must not return null");
                        }
                        return string;
                    }

                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                        if (project == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$4.isAvailable must not be null");
                        }
                        return !project.isDisposed() && !currentModule.isDisposed() && libraryEntry.isValid();
                    }

                    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
                        if (project == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$4.invoke must not be null");
                        }
                        OrderEntryUtil.addLibraryToRoots(libraryEntry, currentModule);
                        if (editor != null) {
                            new AddImportAction(project, reference, editor, aClass).execute();
                        }
                    }
                };
                registrar.register((IntentionAction)fix);
                result.add(fix);
            }
        }
        return result;
    }

    private static boolean isAnnotation(PsiElement psiElement) {
        return psiElement.getParent() instanceof PsiAnnotation && PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiElement);
    }

    private static boolean isJunitAnnotationName(@NonNls String referenceName) {
        return "Test".equals(referenceName) || "Ignore".equals(referenceName) || "RunWith".equals(referenceName) || "Before".equals(referenceName) || "BeforeClass".equals(referenceName) || "After".equals(referenceName) || "AfterClass".equals(referenceName);
    }

    public static void addBundledJarToRoots(Project project, @Nullable Editor editor, Module currentModule, PsiReference reference, @NonNls String className, @NonNls String libVirtFile) {
        OrderEntryFix.addJarToRoots(libVirtFile, currentModule, reference.getElement());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithLibrariesScope((Module)currentModule);
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
        if (aClass != null && editor != null) {
            new AddImportAction(project, reference, editor, aClass).execute();
        }
    }

    public static void addJarToRoots(String libPath, Module module, @Nullable PsiElement location) {
        VirtualFile vFile;
        String url = VfsUtil.getUrlForLibraryRoot((File)new File(libPath));
        VirtualFile libVirtFile = VirtualFileManager.getInstance().findFileByUrl(url);
        assert (libVirtFile != null) : libPath;
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = manager.getModifiableModel();
        Library jarLibrary = rootModel.getModuleLibraryTable().createLibrary();
        Library.ModifiableModel libraryModel = jarLibrary.getModifiableModel();
        libraryModel.addRoot(libVirtFile, OrderRootType.CLASSES);
        libraryModel.commit();
        if (location != null && (vFile = location.getContainingFile().getVirtualFile()) != null && ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(vFile)) {
            LibraryOrderEntry orderEntry = rootModel.findLibraryOrderEntry(jarLibrary);
            orderEntry.setScope(DependencyScope.TEST);
        }
        rootModel.commit();
    }

    private static void showCircularWarningAndContinue(final Project project, Pair<Module, Module> circularModules, Module classModule, final Runnable doit) {
        final String message = QuickFixBundle.message("orderEntry.fix.circular.dependency.warning", classModule.getName(), ((Module)circularModules.getFirst()).getName(), ((Module)circularModules.getSecond()).getName());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!project.isOpen()) {
                    return;
                }
                int ret = Messages.showOkCancelDialog((Project)project, (String)message, (String)QuickFixBundle.message("orderEntry.fix.title.circular.dependency.warning", new Object[0]), (Icon)Messages.getWarningIcon());
                if (ret == 0) {
                    ApplicationManager.getApplication().runWriteAction(doit);
                }
            }
        });
    }

    public static boolean ensureAnnotationsJarInPath(final Module module, String annotationName) {
        if (module == null) {
            return false;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(annotationName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (psiClass != null) {
            return true;
        }
        final LocateLibraryDialog dialog = new LocateLibraryDialog(module, PathManager.getLibPath(), "annotations.jar", QuickFixBundle.message("add.library.annotations.description", new Object[0]));
        dialog.show();
        if (dialog.isOK()) {
            new WriteCommandAction(module.getProject(), new PsiFile[0]){

                protected void run(Result result) throws Throwable {
                    OrderEntryFix.addJarToRoots(dialog.getResultingLibraryPath(), module, null);
                }
            }.execute();
            return true;
        }
        return false;
    }
}

