/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SafeDeleteFix
implements IntentionAction {
    private final PsiElement myElement;

    public SafeDeleteFix(PsiElement element) {
        this.myElement = element;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("safe.delete.text", HighlightMessageUtil.getSymbolName(this.myElement, PsiSubstitutor.EMPTY));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/SafeDeleteFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("safe.delete.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/SafeDeleteFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SafeDeleteFix.isAvailable must not be null");
        }
        return this.myElement.isValid() && this.myElement.getManager().isInProject(this.myElement);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SafeDeleteFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myElement.getContainingFile())) {
            return;
        }
        SafeDeleteHandler.invoke(project, new PsiElement[]{this.myElement}, false);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

