/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.FoldingTransferableData;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class CopyPasteFoldingProcessor
implements CopyPastePostProcessor {
    @Override
    public TextBlockTransferableData collectTransferableData(PsiFile file, Editor editor, int[] startOffsets, int[] endOffsets) {
        FoldRegion[] regions;
        ArrayList<FoldingTransferableData.FoldingData> list = new ArrayList<FoldingTransferableData.FoldingData>();
        for (FoldRegion region : regions = editor.getFoldingModel().getAllFoldRegions()) {
            if (!region.isValid()) continue;
            for (int j = 0; j < startOffsets.length; ++j) {
                if (startOffsets[j] > region.getStartOffset() || region.getEndOffset() > endOffsets[j]) continue;
                list.add(new FoldingTransferableData.FoldingData(region.getStartOffset() - startOffsets[j], region.getEndOffset() - startOffsets[j], region.isExpanded()));
            }
        }
        return new FoldingTransferableData(list.toArray(new FoldingTransferableData.FoldingData[list.size()]));
    }

    @Override
    @Nullable
    public TextBlockTransferableData extractTransferableData(Transferable content) {
        FoldingTransferableData foldingData = null;
        try {
            DataFlavor flavor = FoldingTransferableData.FoldingData.getDataFlavor();
            if (flavor != null) {
                foldingData = (FoldingTransferableData)content.getTransferData(flavor);
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (foldingData != null) {
            return foldingData.clone();
        }
        return null;
    }

    @Override
    public void processTransferableData(Project project, final Editor editor, final RangeMarker bounds, final TextBlockTransferableData value) {
        final CodeFoldingManagerImpl foldingManager = (CodeFoldingManagerImpl)CodeFoldingManager.getInstance(project);
        foldingManager.updateFoldRegions(editor, true);
        Runnable operation = new Runnable(){

            @Override
            public void run() {
                for (FoldingTransferableData.FoldingData data : ((FoldingTransferableData)value).getData()) {
                    FoldRegion region = foldingManager.findFoldRegion(editor, data.startOffset + bounds.getStartOffset(), data.endOffset + bounds.getStartOffset());
                    if (region == null) continue;
                    region.setExpanded(data.isExpanded);
                }
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(operation);
    }
}

