/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiGenerationInfo<T extends PsiMember>
extends GenerationInfo {
    private T myMember;
    private final boolean myMergeIfExists;

    public PsiGenerationInfo(@NotNull T member) {
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/PsiGenerationInfo.<init> must not be null");
        }
        this.myMember = member;
        this.myMergeIfExists = true;
    }

    public PsiGenerationInfo(@NotNull T member, boolean mergeIfExists) {
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/PsiGenerationInfo.<init> must not be null");
        }
        this.myMember = member;
        this.myMergeIfExists = mergeIfExists;
    }

    public final T getPsiMember() {
        return this.myMember;
    }

    @Override
    public void insert(PsiClass aClass, PsiElement anchor, boolean before) throws IncorrectOperationException {
        Object existingMember = this.myMember instanceof PsiField ? aClass.findFieldByName(this.myMember.getName(), false) : (this.myMember instanceof PsiMethod ? aClass.findMethodBySignature((PsiMethod)this.myMember, false) : null);
        if (existingMember == null || !this.myMergeIfExists) {
            PsiElement newMember = GenerateMembersUtil.insert(aClass, this.myMember, anchor, before);
            this.myMember = (PsiMember)JavaCodeStyleManager.getInstance((Project)aClass.getProject()).shortenClassReferences(newMember);
        } else {
            PsiModifierList modifierList = this.myMember.getModifierList();
            PsiModifierList existingModifierList = existingMember.getModifierList();
            if (modifierList != null && existingModifierList != null) {
                PsiElement annoAnchor;
                PsiAnnotation[] psiAnnotations = modifierList.getAnnotations();
                Object object = annoAnchor = existingModifierList.getAnnotations().length > 0 ? existingModifierList.getAnnotations()[0] : existingModifierList.getFirstChild();
                if (psiAnnotations.length > 0) {
                    for (PsiAnnotation annotation : psiAnnotations) {
                        PsiAnnotation existingAnno = existingModifierList.findAnnotation(annotation.getQualifiedName());
                        if (existingAnno != null) {
                            existingAnno.replace((PsiElement)annotation);
                            continue;
                        }
                        existingModifierList.addBefore((PsiElement)annotation, annoAnchor);
                    }
                }
            }
            this.myMember = existingMember;
        }
        if (this.myMember instanceof PsiMethod) {
            final Project project = this.myMember.getProject();
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(this.myMember);
            PostprocessReformattingAspect reformattingAspect = (PostprocessReformattingAspect)project.getComponent(PostprocessReformattingAspect.class);
            reformattingAspect.doPostponedFormatting(this.myMember.getContainingFile().getViewProvider());
            this.myMember = (PsiMember)pointer.getElement();
            if (this.myMember != null) {
                final PsiParameterList parameterList = ((PsiMethod)this.myMember).getParameterList();
                reformattingAspect.disablePostprocessFormattingInside(new Runnable(){

                    @Override
                    public void run() {
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)parameterList);
                    }
                });
            }
        }
    }
}

