/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.codeInsight.navigation.actions.GotoTypeDeclarationAction;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.searches.DefinitionsSearch;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CtrlMouseHandler
extends AbstractProjectComponent {
    private final TextAttributes ourReferenceAttributes;
    private RangeHighlighter myHighlighter;
    private Editor myHighlighterView;
    private Cursor myStoredCursor;
    private Info myStoredInfo;
    private int myStoredModifiers = 0;
    private TooltipProvider myTooltipProvider = null;
    private final FileEditorManager myFileEditorManager;
    private final KeyListener myEditorKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            this.handleKey(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.handleKey(e);
        }

        private void handleKey(KeyEvent e) {
            int modifiers = e.getModifiers();
            if (modifiers == CtrlMouseHandler.this.myStoredModifiers) {
                return;
            }
            BrowseMode browseMode = CtrlMouseHandler.getBrowseMode(modifiers);
            if (browseMode != BrowseMode.None) {
                if (CtrlMouseHandler.this.myTooltipProvider != null) {
                    if (browseMode != CtrlMouseHandler.this.myTooltipProvider.getBrowseMode()) {
                        CtrlMouseHandler.this.disposeHighlighter();
                    }
                    CtrlMouseHandler.this.myStoredModifiers = modifiers;
                    CtrlMouseHandler.this.myTooltipProvider.execute(browseMode);
                }
            } else {
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.myTooltipProvider = null;
            }
        }
    };
    private final FileEditorManagerListener myFileEditorManagerListener = new FileEditorManagerAdapter(){

        public void selectionChanged(FileEditorManagerEvent e) {
            CtrlMouseHandler.this.disposeHighlighter();
            CtrlMouseHandler.this.myTooltipProvider = null;
        }
    };
    private final VisibleAreaListener myVisibleAreaListener = new VisibleAreaListener(){

        public void visibleAreaChanged(VisibleAreaEvent e) {
            CtrlMouseHandler.this.disposeHighlighter();
            CtrlMouseHandler.this.myTooltipProvider = null;
        }
    };
    private final EditorMouseAdapter myEditorMouseAdapter = new EditorMouseAdapter(){

        public void mouseReleased(EditorMouseEvent e) {
            CtrlMouseHandler.this.disposeHighlighter();
            CtrlMouseHandler.this.myTooltipProvider = null;
        }
    };
    private final EditorMouseMotionListener myEditorMouseMotionListener = new EditorMouseMotionAdapter(){

        public void mouseMoved(EditorMouseEvent e) {
            if (e.isConsumed() || CtrlMouseHandler.this.myProject.isDisposed()) {
                return;
            }
            MouseEvent mouseEvent = e.getMouseEvent();
            Editor editor = e.getEditor();
            if (editor.getProject() != null && editor.getProject() != CtrlMouseHandler.this.myProject) {
                return;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile(editor.getDocument());
            Point point = new Point(mouseEvent.getPoint());
            if (!PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).isUncommited(editor.getDocument())) {
                editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile, editor.logicalPositionToOffset(editor.xyToLogicalPosition(point)));
            }
            LogicalPosition pos = editor.xyToLogicalPosition(point);
            int offset = editor.logicalPositionToOffset(pos);
            int selStart = editor.getSelectionModel().getSelectionStart();
            int selEnd = editor.getSelectionModel().getSelectionEnd();
            CtrlMouseHandler.this.myStoredModifiers = mouseEvent.getModifiers();
            BrowseMode browseMode = CtrlMouseHandler.getBrowseMode(CtrlMouseHandler.this.myStoredModifiers);
            if (CtrlMouseHandler.this.myTooltipProvider != null) {
                CtrlMouseHandler.this.myTooltipProvider.dispose();
            }
            if (browseMode == BrowseMode.None || offset >= selStart && offset < selEnd) {
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.myTooltipProvider = null;
                return;
            }
            CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider(editor, pos);
            CtrlMouseHandler.this.myTooltipProvider.execute(browseMode);
        }
    };
    private static final TextAttributesKey CTRL_CLICKABLE_ATTRIBUTES_KEY = TextAttributesKey.createTextAttributesKey((String)"CTRL_CLICKABLE", (TextAttributes)new TextAttributes(Color.blue, null, Color.blue, EffectType.LINE_UNDERSCORE, 0));

    public CtrlMouseHandler(final Project project, StartupManager startupManager, EditorColorsManager colorsManager, FileEditorManager fileEditorManager) {
        super(project);
        startupManager.registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
                eventMulticaster.addEditorMouseListener((EditorMouseListener)CtrlMouseHandler.this.myEditorMouseAdapter, (Disposable)project);
                eventMulticaster.addEditorMouseMotionListener(CtrlMouseHandler.this.myEditorMouseMotionListener, (Disposable)project);
            }
        });
        this.ourReferenceAttributes = colorsManager.getGlobalScheme().getAttributes(CTRL_CLICKABLE_ATTRIBUTES_KEY);
        this.myFileEditorManager = fileEditorManager;
    }

    @NotNull
    public String getComponentName() {
        if ("CtrlMouseHandler" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/CtrlMouseHandler.getComponentName must not return null");
        }
        return "CtrlMouseHandler";
    }

    private static BrowseMode getBrowseMode(int modifiers) {
        if (modifiers != 0) {
            Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
            if (CtrlMouseHandler.matchMouseShortcut(activeKeymap, modifiers, "GotoDeclaration")) {
                return BrowseMode.Declaration;
            }
            if (CtrlMouseHandler.matchMouseShortcut(activeKeymap, modifiers, "GotoTypeDeclaration")) {
                return BrowseMode.TypeDeclaration;
            }
            if (CtrlMouseHandler.matchMouseShortcut(activeKeymap, modifiers, "GotoImplementation")) {
                return BrowseMode.Implementation;
            }
        }
        return BrowseMode.None;
    }

    private static boolean matchMouseShortcut(Keymap activeKeymap, int modifiers, String actionId) {
        MouseShortcut syntheticShortcut = new MouseShortcut(1, modifiers, 1);
        for (Shortcut shortcut : activeKeymap.getShortcuts(actionId)) {
            MouseShortcut mouseShortcut;
            if (!(shortcut instanceof MouseShortcut) || (mouseShortcut = (MouseShortcut)shortcut).getModifiers() != syntheticShortcut.getModifiers()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String generateInfo(PsiElement element) {
        ItemPresentation presentation;
        VirtualFile virtualFile;
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(element);
        String info = documentationProvider.getQuickNavigateInfo(element);
        if (info != null) {
            return info;
        }
        if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null) {
            return virtualFile.getPresentableUrl();
        }
        if (element instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            return presentation.getPresentableText();
        }
        return null;
    }

    private static void showDumbModeNotification(Project project) {
        DumbService.getInstance((Project)project).showDumbModeNotification("Element information is not available during index update");
    }

    @Nullable
    private Info getInfoAt(Editor editor, PsiFile file, int offset, BrowseMode browseMode) {
        PsiElement elementAtPointer;
        PsiElement targetElement = null;
        if (browseMode == BrowseMode.TypeDeclaration) {
            try {
                targetElement = GotoTypeDeclarationAction.findSymbolType(editor, offset);
            }
            catch (IndexNotReadyException e) {
                CtrlMouseHandler.showDumbModeNotification(this.myProject);
            }
        } else if (browseMode == BrowseMode.Declaration) {
            PsiElement resolvedElement;
            PsiReference ref = TargetElementUtilBase.findReference(editor, offset);
            if (ref != null && (resolvedElement = CtrlMouseHandler.resolve(ref)) != null) {
                return new InfoSingle(ref, resolvedElement);
            }
            targetElement = GotoDeclarationAction.findTargetElementNoVS(this.myProject, editor, offset);
        } else if (browseMode == BrowseMode.Implementation) {
            PsiElement element = TargetElementUtilBase.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
            PsiElement[] targetElements = new ImplementationSearcher(){

                @Override
                @NotNull
                protected PsiElement[] searchDefinitions(PsiElement element) {
                    final ArrayList found = new ArrayList(2);
                    DefinitionsSearch.search((PsiElement)element).forEach((Processor)new Processor<PsiElement>(){

                        public boolean process(PsiElement psiElement) {
                            found.add(psiElement);
                            return found.size() != 2;
                        }
                    });
                    PsiElement[] psiElementArray = found.toArray(new PsiElement[found.size()]);
                    if (psiElementArray == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/CtrlMouseHandler$7.searchDefinitions must not return null");
                    }
                    return psiElementArray;
                }
            }.searchImplementations(editor, element, offset);
            if (targetElements.length > 1) {
                PsiElement elementAtPointer2 = file.findElementAt(offset);
                if (elementAtPointer2 != null) {
                    return new InfoMultiple(elementAtPointer2);
                }
                return null;
            }
            if (targetElements.length == 1) {
                Navigatable descriptor = EditSourceUtil.getDescriptor((PsiElement)targetElements[0]);
                if (descriptor == null || !descriptor.canNavigate()) {
                    return null;
                }
                targetElement = targetElements[0];
            }
        }
        if (targetElement != null && targetElement.isPhysical() && (elementAtPointer = file.findElementAt(offset)) != null) {
            return new InfoSingle(elementAtPointer, targetElement);
        }
        return null;
    }

    @Nullable
    private static PsiElement resolve(PsiReference ref) {
        PsiElement resolvedElement = null;
        if (ref instanceof PsiPolyVariantReference) {
            ResolveResult resolveResult;
            ResolveResult[] psiElements = ((PsiPolyVariantReference)ref).multiResolve(false);
            if (psiElements.length > 0 && (resolveResult = psiElements[0]) != null) {
                resolvedElement = resolveResult.getElement();
            }
        } else {
            resolvedElement = ref.resolve();
        }
        return resolvedElement;
    }

    private void disposeHighlighter() {
        if (this.myHighlighter != null) {
            this.myHighlighterView.getMarkupModel().removeHighlighter(this.myHighlighter);
            JComponent internalComponent = this.myHighlighterView.getContentComponent();
            internalComponent.setCursor(this.myStoredCursor);
            internalComponent.removeKeyListener(this.myEditorKeyListener);
            this.myHighlighterView.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
            this.myFileEditorManager.removeFileEditorManagerListener(this.myFileEditorManagerListener);
            HintManager.getInstance().hideAllHints();
            this.myHighlighter = null;
            this.myHighlighterView = null;
            this.myStoredCursor = null;
        }
        this.myStoredInfo = null;
    }

    private class TooltipProvider {
        private final Editor myEditor;
        private final LogicalPosition myPosition;
        private BrowseMode myBrowseMode;
        private boolean myDisposed;

        public TooltipProvider(Editor editor, LogicalPosition pos) {
            this.myEditor = editor;
            this.myPosition = pos;
        }

        public void dispose() {
            this.myDisposed = true;
        }

        public BrowseMode getBrowseMode() {
            return this.myBrowseMode;
        }

        public void execute(BrowseMode browseMode) {
            this.myBrowseMode = browseMode;
            Document document = this.myEditor.getDocument();
            final PsiFile file = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile(document);
            if (file == null) {
                return;
            }
            PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).commitAllDocuments();
            if (TargetElementUtilBase.inVirtualSpace(this.myEditor, this.myPosition)) {
                return;
            }
            final int offset = this.myEditor.logicalPositionToOffset(this.myPosition);
            int selStart = this.myEditor.getSelectionModel().getSelectionStart();
            int selEnd = this.myEditor.getSelectionModel().getSelectionEnd();
            if (offset >= selStart && offset < selEnd) {
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            TooltipProvider.this.doExecute(file, offset);
                        }
                    });
                }
            });
        }

        private void doExecute(PsiFile file, int offset) {
            Info info;
            try {
                info = CtrlMouseHandler.this.getInfoAt(this.myEditor, file, offset, this.myBrowseMode);
            }
            catch (IndexNotReadyException e) {
                CtrlMouseHandler.showDumbModeNotification(CtrlMouseHandler.this.myProject);
                return;
            }
            if (info == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TooltipProvider.this.myDisposed || TooltipProvider.this.myEditor.isDisposed() || !TooltipProvider.this.myEditor.getComponent().isShowing()) {
                        return;
                    }
                    TooltipProvider.this.showHint(info);
                }
            });
        }

        private void showHint(Info info) {
            if (this.myDisposed) {
                return;
            }
            JComponent internalComponent = this.myEditor.getContentComponent();
            if (CtrlMouseHandler.this.myHighlighter != null) {
                if (!info.isSimilarTo(CtrlMouseHandler.this.myStoredInfo)) {
                    CtrlMouseHandler.this.disposeHighlighter();
                } else {
                    internalComponent.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
            }
            if (info.isValid(this.myEditor.getDocument())) {
                this.installLinkHighlighter(info);
                internalComponent.addKeyListener(CtrlMouseHandler.this.myEditorKeyListener);
                this.myEditor.getScrollingModel().addVisibleAreaListener(CtrlMouseHandler.this.myVisibleAreaListener);
                CtrlMouseHandler.this.myStoredCursor = internalComponent.getCursor();
                CtrlMouseHandler.this.myStoredInfo = info;
                internalComponent.setCursor(Cursor.getPredefinedCursor(12));
                CtrlMouseHandler.this.myFileEditorManager.addFileEditorManagerListener(CtrlMouseHandler.this.myFileEditorManagerListener);
                String text = info.getInfo();
                if (text == null) {
                    return;
                }
                JLabel label = HintUtil.createInformationLabel(text);
                label.setUI((LabelUI)new MultiLineLabelUI());
                Font FONT = UIUtil.getLabelFont();
                label.setFont(FONT);
                LightweightHint hint = new LightweightHint(label);
                final HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
                label.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        hintManager.hideAllHints();
                    }
                });
                Point p = HintManagerImpl.getHintPosition(hint, this.myEditor, this.myPosition, (short)1);
                hintManager.showEditorHint(hint, this.myEditor, p, 42, 0, false);
            }
        }

        private void installLinkHighlighter(Info info) {
            int startOffset = info.myStartOffset;
            int endOffset = info.myEndOffset;
            CtrlMouseHandler.this.myHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 6001, CtrlMouseHandler.this.ourReferenceAttributes, HighlighterTargetArea.EXACT_RANGE);
            CtrlMouseHandler.this.myHighlighterView = this.myEditor;
        }
    }

    private static class InfoMultiple
    extends Info {
        public InfoMultiple(@NotNull PsiElement elementAtPointer) {
            if (elementAtPointer == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/CtrlMouseHandler$InfoMultiple.<init> must not be null");
            }
            super(elementAtPointer);
        }

        @Override
        public String getInfo() {
            return CodeInsightBundle.message((String)"multiple.implementations.tooltip", (Object[])new Object[0]);
        }

        @Override
        public boolean isValid(Document document) {
            return new TextRange(0, document.getTextLength()).containsRange(this.myStartOffset, this.myEndOffset);
        }
    }

    private static class InfoSingle
    extends Info {
        @NotNull
        private final PsiElement myTargetElement;

        public InfoSingle(@NotNull PsiElement elementAtPointer, @NotNull PsiElement targetElement) {
            if (elementAtPointer == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/CtrlMouseHandler$InfoSingle.<init> must not be null");
            }
            if (targetElement == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/navigation/CtrlMouseHandler$InfoSingle.<init> must not be null");
            }
            super(elementAtPointer);
            this.myTargetElement = targetElement;
        }

        public InfoSingle(PsiReference ref, @NotNull PsiElement targetElement) {
            if (targetElement == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/navigation/CtrlMouseHandler$InfoSingle.<init> must not be null");
            }
            super(ref.getElement(), ref.getElement().getTextRange().getStartOffset() + ref.getRangeInElement().getStartOffset(), ref.getElement().getTextRange().getStartOffset() + ref.getRangeInElement().getEndOffset());
            this.myTargetElement = targetElement;
        }

        @Override
        @Nullable
        public String getInfo() {
            try {
                return CtrlMouseHandler.generateInfo(this.myTargetElement);
            }
            catch (IndexNotReadyException e) {
                CtrlMouseHandler.showDumbModeNotification(this.myTargetElement.getProject());
                return null;
            }
        }

        @Override
        public boolean isValid(Document document) {
            return this.myTargetElement.isValid() && this.myTargetElement != this.myElementAtPointer && this.myTargetElement != this.myElementAtPointer.getParent() && new TextRange(0, document.getTextLength()).containsRange(this.myStartOffset, this.myEndOffset);
        }
    }

    private static abstract class Info {
        @NotNull
        protected final PsiElement myElementAtPointer;
        public final int myStartOffset;
        public final int myEndOffset;

        public Info(@NotNull PsiElement elementAtPointer, int startOffset, int endOffset) {
            if (elementAtPointer == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/CtrlMouseHandler$Info.<init> must not be null");
            }
            this.myElementAtPointer = elementAtPointer;
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        public Info(@NotNull PsiElement elementAtPointer) {
            if (elementAtPointer == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/CtrlMouseHandler$Info.<init> must not be null");
            }
            this(elementAtPointer, elementAtPointer.getTextOffset(), elementAtPointer.getTextOffset() + elementAtPointer.getTextLength());
        }

        boolean isSimilarTo(Info that) {
            return Comparing.equal((Object)this.myElementAtPointer, (Object)that.myElementAtPointer) && this.myStartOffset == that.myStartOffset && this.myEndOffset == that.myEndOffset;
        }

        @Nullable
        public abstract String getInfo();

        public abstract boolean isValid(Document var1);
    }

    private static enum BrowseMode {
        None,
        Declaration,
        TypeDeclaration,
        Implementation;

    }
}

