/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

class EditVariableDialog
extends DialogWrapper {
    private ArrayList<Variable> myVariables = new ArrayList();
    private JButton myMoveUpButton;
    private JButton myMoveDownButton;
    private JTable myTable;
    private Editor myEditor;
    private boolean hasMoveVars;
    private List<Macro> additionalMacros;

    public EditVariableDialog(Editor editor, Component parent, ArrayList<Variable> variables, boolean _hasMoveVars, List<Macro> _additionalMacros) {
        super(parent, true);
        this.hasMoveVars = _hasMoveVars;
        this.additionalMacros = _additionalMacros;
        this.setButtonsMargin(null);
        this.myVariables = variables;
        this.myEditor = editor;
        this.init();
        this.setTitle(CodeInsightBundle.message((String)"templates.dialog.edit.variables.title", (Object[])new Object[0]));
        this.setOKButtonText(CommonBundle.getOkButtonText());
        this.updateButtons();
    }

    public EditVariableDialog(Editor editor, Component parent, ArrayList<Variable> variables) {
        this(editor, parent, variables, true, null);
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("editing.templates.defineTemplates.editTemplVars");
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.codeInsight.template.impl.EditVariableDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)CodeInsightBundle.message((String)"templates.dialog.edit.variables.border.title", (Object[])new Object[0])));
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.createVariablesTable(), "Center");
        if (this.hasMoveVars) {
            panel.add((Component)this.createTableButtonPanel(), "East");
        }
        return panel;
    }

    private JPanel createTableButtonPanel() {
        JPanel tableButtonsPanel = new JPanel();
        tableButtonsPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        tableButtonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 2;
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        this.myMoveUpButton = new JButton(CodeInsightBundle.message((String)"templates.dialog.edit.variables.action.move.up", (Object[])new Object[0]));
        tableButtonsPanel.add((Component)this.myMoveUpButton, gbConstraints);
        this.myMoveDownButton = new JButton(CodeInsightBundle.message((String)"templates.dialog.edit.variables.action.move.down", (Object[])new Object[0]));
        tableButtonsPanel.add((Component)this.myMoveDownButton, gbConstraints);
        gbConstraints.weighty = 1.0;
        tableButtonsPanel.add((Component)new JPanel(), gbConstraints);
        this.myMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditVariableDialog.this.moveRowUp();
            }
        });
        this.myMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditVariableDialog.this.moveRowDown();
            }
        });
        return tableButtonsPanel;
    }

    private JComponent createVariablesTable() {
        final String[] names = new String[]{CodeInsightBundle.message((String)"templates.dialog.edit.variables.table.column.name", (Object[])new Object[0]), CodeInsightBundle.message((String)"templates.dialog.edit.variables.table.column.expression", (Object[])new Object[0]), CodeInsightBundle.message((String)"templates.dialog.edit.variables.table.column.default.value", (Object[])new Object[0]), CodeInsightBundle.message((String)"templates.dialog.edit.variables.table.column.skip.if.defined", (Object[])new Object[0])};
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return names.length;
            }

            @Override
            public int getRowCount() {
                return EditVariableDialog.this.myVariables.size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                Variable variable = (Variable)EditVariableDialog.this.myVariables.get(row);
                if (col == 0) {
                    return variable.getName();
                }
                if (col == 1) {
                    return variable.getExpressionString();
                }
                if (col == 2) {
                    return variable.getDefaultValueString();
                }
                return variable.isAlwaysStopAt() ? Boolean.FALSE : Boolean.TRUE;
            }

            @Override
            public String getColumnName(int column) {
                return names[column];
            }

            public Class getColumnClass(int c) {
                if (c <= 2) {
                    return String.class;
                }
                return Boolean.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                Variable variable = (Variable)EditVariableDialog.this.myVariables.get(row);
                if (col == 0) {
                    String varName = (String)aValue;
                    Variable newVar = new Variable(varName, variable.getExpressionString(), variable.getDefaultValueString(), variable.isAlwaysStopAt());
                    EditVariableDialog.this.myVariables.set(row, newVar);
                    EditVariableDialog.this.updateTemplateTextByVarNameChange(variable, newVar);
                } else if (col == 1) {
                    variable.setExpressionString((String)aValue);
                } else if (col == 2) {
                    variable.setDefaultValueString((String)aValue);
                } else {
                    variable.setAlwaysStopAt((Boolean)aValue == false);
                }
            }
        };
        this.myTable = new Table((TableModel)dataModel);
        this.myTable.setSelectionMode(0);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(500, this.myTable.getRowHeight() * 8));
        this.myTable.getColumn(names[0]).setPreferredWidth(120);
        this.myTable.getColumn(names[1]).setPreferredWidth(200);
        this.myTable.getColumn(names[2]).setPreferredWidth(200);
        this.myTable.getColumn(names[3]).setPreferredWidth(100);
        if (this.myVariables.size() > 0) {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        JComboBox<String> comboField = new JComboBox<String>();
        Macro[] macros = MacroFactory.getMacros();
        if (this.additionalMacros != null) {
            ArrayList<Macro> list = new ArrayList<Macro>(macros.length + this.additionalMacros.size());
            list.addAll(Arrays.asList(macros));
            list.addAll(this.additionalMacros);
            macros = list.toArray(new Macro[0]);
        }
        Arrays.sort(macros, new Comparator<Macro>(){

            @Override
            public int compare(Macro m1, Macro m2) {
                return m1.getDescription().compareTo(m2.getDescription());
            }
        });
        for (Macro macro : macros) {
            comboField.addItem(macro.getDescription());
        }
        comboField.setEditable(true);
        DefaultCellEditor cellEditor = new DefaultCellEditor(comboField);
        cellEditor.setClickCountToStart(1);
        this.myTable.getColumn(names[1]).setCellEditor(cellEditor);
        this.myTable.setRowHeight(comboField.getPreferredSize().height);
        JTextField textField = new JTextField();
        cellEditor = new DefaultCellEditor(textField);
        cellEditor.setClickCountToStart(1);
        this.myTable.setDefaultEditor(String.class, cellEditor);
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EditVariableDialog.this.updateButtons();
            }
        });
        return ScrollPaneFactory.createScrollPane((JComponent)this.myTable);
    }

    private void updateButtons() {
        int selected = this.myTable.getSelectedRow();
        if (this.myMoveUpButton != null) {
            this.myMoveUpButton.setEnabled(selected >= 1);
        }
        if (this.myMoveDownButton != null) {
            this.myMoveDownButton.setEnabled(selected >= 0 && selected < this.myVariables.size() - 1);
        }
    }

    private void moveRowUp() {
        TableCellEditor editor;
        int selected = this.myTable.getSelectedRow();
        if (selected < 1) {
            return;
        }
        if (this.myTable.isEditing() && (editor = this.myTable.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        EditVariableDialog.moveElementUp(this.myVariables, selected);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsUpdated(selected - 1, selected);
        this.myTable.setRowSelectionInterval(selected - 1, selected - 1);
    }

    private static void moveElementUp(ArrayList<Variable> array, int offset) {
        Variable element = array.get(offset);
        Variable previousElement = array.get(offset - 1);
        array.set(offset, previousElement);
        array.set(offset - 1, element);
    }

    private void moveRowDown() {
        TableCellEditor editor;
        int selected = this.myTable.getSelectedRow();
        if (selected >= this.myVariables.size() - 1 || selected < 0) {
            return;
        }
        if (this.myTable.isEditing() && (editor = this.myTable.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        EditVariableDialog.moveElementDown(this.myVariables, selected);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsUpdated(selected, selected + 1);
        this.myTable.setRowSelectionInterval(selected + 1, selected + 1);
    }

    private static void moveElementDown(ArrayList<Variable> array, int offset) {
        Variable element = array.get(offset);
        Variable nextElement = array.get(offset + 1);
        array.set(offset, nextElement);
        array.set(offset + 1, element);
    }

    protected void doOKAction() {
        TableCellEditor editor;
        if (this.myTable.isEditing() && (editor = this.myTable.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        super.doOKAction();
    }

    private void updateTemplateTextByVarNameChange(final Variable oldVar, final Variable newVar) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(null, new Runnable(){

                    @Override
                    public void run() {
                        Document document = EditVariableDialog.this.myEditor.getDocument();
                        String templateText = document.getText();
                        templateText = templateText.replaceAll("\\$" + oldVar.getName() + "\\$", "\\$" + newVar.getName() + "\\$");
                        document.replaceString(0, document.getTextLength(), (CharSequence)templateText);
                    }
                }, null, null);
            }
        });
    }
}

