/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class SuppressionUtil {
    @NonNls
    public static final String SUPPRESS_INSPECTIONS_TAG_NAME = "noinspection";
    public static final String COMMON_SUPPRESS_REGEXP = "\\s*noinspection\\s+(\\w+(\\s*,\\w+)*\\s*\\w*)";
    @NonNls
    public static final Pattern SUPPRESS_IN_LINE_COMMENT_PATTERN = Pattern.compile("//\\s*noinspection\\s+(\\w+(\\s*,\\w+)*\\s*\\w*)");

    private SuppressionUtil() {
    }

    public static boolean isInspectionToolIdMentioned(String inspectionsList, String inspectionToolID) {
        Iterable ids = StringUtil.tokenize((String)inspectionsList, (String)"[, ]");
        for (String id : ids) {
            if (!id.trim().equals(inspectionToolID) && !id.trim().equals("ALL")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getStatementToolSuppressedIn(PsiElement place, String toolId, Class<? extends PsiElement> statementClass) {
        return SuppressionUtil.getStatementToolSuppressedIn(place, toolId, statementClass, SUPPRESS_IN_LINE_COMMENT_PATTERN);
    }

    @Nullable
    public static PsiElement getStatementToolSuppressedIn(PsiElement place, String toolId, Class<? extends PsiElement> statementClass, Pattern suppressInLineCommentPattern) {
        String text;
        Matcher matcher;
        PsiElement prev;
        PsiElement statement = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{statementClass});
        if (statement != null && (prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiComment && (matcher = suppressInLineCommentPattern.matcher(text = prev.getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned(matcher.group(1), toolId)) {
            return prev;
        }
        return null;
    }

    public static boolean isSuppressedInStatement(final PsiElement place, final String toolId, final Class<? extends PsiElement> statementClass) {
        return ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<PsiElement>(){

            public PsiElement compute() {
                return SuppressionUtil.getStatementToolSuppressedIn(place, toolId, statementClass);
            }
        }) != null;
    }
}

