/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.SortedIntSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaNotNullValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntProcedure;
import gnu.trove.TIntStack;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongHashSet;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaMemoryStateImpl
implements DfaMemoryState {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl");
    private final DfaValueFactory myFactory;
    private ArrayList<SortedIntSet> myEqClasses;
    private int myStateSize;
    private Stack<DfaValue> myStack;
    private TIntStack myOffsetStack;
    private TLongHashSet myDistinctClasses;
    private Map<DfaVariableValue, DfaVariableState> myVariableStates;

    public DfaMemoryStateImpl(DfaValueFactory factory) {
        this.myFactory = factory;
        this.myEqClasses = new ArrayList();
        this.myStateSize = 0;
        this.myStack = new Stack();
        this.myDistinctClasses = new TLongHashSet();
        this.myVariableStates = new THashMap();
        this.myOffsetStack = new TIntStack(1);
    }

    public DfaValueFactory getFactory() {
        return this.myFactory;
    }

    protected DfaMemoryStateImpl createNew() {
        return new DfaMemoryStateImpl(this.myFactory);
    }

    @Override
    public DfaMemoryStateImpl createCopy() {
        DfaMemoryStateImpl newState = this.createNew();
        newState.myStack = (Stack)this.myStack.clone();
        newState.myDistinctClasses = new TLongHashSet(this.myDistinctClasses.toArray());
        newState.myEqClasses = new ArrayList();
        newState.myStateSize = this.myStateSize;
        newState.myVariableStates = new THashMap();
        newState.myOffsetStack = new TIntStack(this.myOffsetStack);
        for (int i = 0; i < this.myEqClasses.size(); ++i) {
            SortedIntSet aClass = this.myEqClasses.get(i);
            newState.myEqClasses.add(aClass != null ? new SortedIntSet(aClass.toNativeArray()) : null);
        }
        try {
            Iterator<DfaVariableValue> i$ = this.myVariableStates.keySet().iterator();
            while (i$.hasNext()) {
                DfaVariableValue o;
                DfaVariableValue dfaVariableValue = o = i$.next();
                DfaVariableState clone = (DfaVariableState)this.myVariableStates.get(dfaVariableValue).clone();
                newState.myVariableStates.put(dfaVariableValue, clone);
            }
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
        }
        return newState;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaMemoryState)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)obj;
        if (this.myStateSize != that.myStateSize) {
            return false;
        }
        if (this.myDistinctClasses.size() != that.myDistinctClasses.size()) {
            return false;
        }
        if (!this.myStack.equals(that.myStack)) {
            return false;
        }
        if (!this.myOffsetStack.equals((Object)that.myOffsetStack)) {
            return false;
        }
        if (!((Object)this.myVariableStates).equals(that.myVariableStates)) {
            return false;
        }
        int[] permutation = this.getPermutationToSortedState();
        int[] thatPermutation = that.getPermutationToSortedState();
        for (int i = 0; i < this.myStateSize; ++i) {
            SortedIntSet thisClass = this.myEqClasses.get(permutation[i]);
            SortedIntSet thatClass = that.myEqClasses.get(thatPermutation[i]);
            if (thisClass == null) break;
            if (thisClass.compareTo(thatClass) == 0) continue;
            return false;
        }
        long[] pairs = this.getSortedDistinctClasses(permutation);
        long[] thatPairs = that.getSortedDistinctClasses(thatPermutation);
        for (int i = 0; i < pairs.length; ++i) {
            if (pairs[i] == thatPairs[i]) continue;
            return false;
        }
        return true;
    }

    private long[] getSortedDistinctClasses(int[] permutation) {
        long[] pairs = this.myDistinctClasses.toArray();
        for (int i = 0; i < pairs.length; ++i) {
            pairs[i] = this.convert(pairs[i], permutation);
        }
        Arrays.sort(pairs);
        return pairs;
    }

    private long convert(long pair, int[] permutation) {
        if (this.myEqClasses.get(DfaMemoryStateImpl.low(pair)) == null || this.myEqClasses.get(DfaMemoryStateImpl.high(pair)) == null) {
            return -1L;
        }
        return DfaMemoryStateImpl.createPair(DfaMemoryStateImpl.inversePermutation(permutation, DfaMemoryStateImpl.low(pair)), DfaMemoryStateImpl.inversePermutation(permutation, DfaMemoryStateImpl.high(pair)));
    }

    private static int inversePermutation(int[] permutation, int idx) {
        for (int i = 0; i < permutation.length; ++i) {
            if (idx != permutation[i]) continue;
            return i;
        }
        return -1;
    }

    private int[] getPermutationToSortedState() {
        int i;
        int size = this.myEqClasses.size();
        int[] permutation = ArrayUtil.newIntArray((int)size);
        for (i = 0; i < size; ++i) {
            permutation[i] = i;
        }
        for (i = 0; i < permutation.length; ++i) {
            for (int j = i + 1; j < permutation.length; ++j) {
                if (this.compare(permutation[i], permutation[j]) <= 0) continue;
                int t = permutation[i];
                permutation[i] = permutation[j];
                permutation[j] = t;
            }
        }
        return permutation;
    }

    private int compare(int i1, int i2) {
        SortedIntSet s1 = this.myEqClasses.get(i1);
        SortedIntSet s2 = this.myEqClasses.get(i2);
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        return s1.compareTo(s2);
    }

    public int hashCode() {
        return 0;
    }

    private void appendClass(StringBuffer buf, int aClassIndex) {
        SortedIntSet aClass = this.myEqClasses.get(aClassIndex);
        if (aClass != null) {
            buf.append("(");
            for (int i = 0; i < aClass.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                int value = aClass.get(i);
                DfaValue dfaValue = this.myFactory.getValue(value);
                buf.append(dfaValue);
            }
            buf.append(")");
        }
    }

    public String toString() {
        long[] dclasses;
        StringBuffer result = new StringBuffer();
        result.append('<');
        for (int i = 0; i < this.myEqClasses.size(); ++i) {
            this.appendClass(result, i);
        }
        result.append(" distincts: ");
        for (long pair : dclasses = this.myDistinctClasses.toArray()) {
            result.append("{");
            this.appendClass(result, DfaMemoryStateImpl.low(pair));
            result.append(", ");
            this.appendClass(result, DfaMemoryStateImpl.high(pair));
            result.append("} ");
        }
        result.append(" stack: ");
        for (DfaValue value : this.myStack) {
            result.append(value);
        }
        result.append('>');
        return result.toString();
    }

    @Override
    public DfaValue pop() {
        return (DfaValue)this.myStack.pop();
    }

    @Override
    public DfaValue peek() {
        return (DfaValue)this.myStack.peek();
    }

    @Override
    public void push(@NotNull DfaValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl.push must not be null");
        }
        this.myStack.push((Object)value);
    }

    @Override
    public int popOffset() {
        return this.myOffsetStack.pop();
    }

    @Override
    public void pushOffset(int offset) {
        this.myOffsetStack.push(offset);
    }

    @Override
    public void emptyStack() {
        this.myStack.clear();
    }

    @Override
    public void setVarValue(DfaVariableValue var, DfaValue value) {
        this.flushVariable(var);
        if (value instanceof DfaUnknownValue) {
            return;
        }
        this.getVariableState(var).setValue(value);
        if (value instanceof DfaNotNullValue) {
            DfaTypeValue dfaType = this.myFactory.getTypeFactory().create(((DfaNotNullValue)value).getType());
            DfaRelationValue dfaInstanceof = this.myFactory.getRelationFactory().create(var, dfaType, "instanceof", false);
            this.applyCondition(dfaInstanceof);
            this.applyCondition(this.compareToNull(var, true));
        } else if (value instanceof DfaTypeValue) {
            DfaRelationValue dfaInstanceof = this.myFactory.getRelationFactory().create(var, value, "instanceof", false);
            this.applyInstanceofOrNull(dfaInstanceof);
        } else {
            DfaRelationValue dfaEqual = this.myFactory.getRelationFactory().create(var, value, "==", false);
            if (dfaEqual == null) {
                return;
            }
            this.applyCondition(dfaEqual);
            if (value instanceof DfaVariableValue) {
                try {
                    DfaVariableState newState = (DfaVariableState)this.getVariableState((DfaVariableValue)value).clone();
                    this.myVariableStates.put(var, newState);
                }
                catch (CloneNotSupportedException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        if (this.getVariableState(var).isNotNull()) {
            this.applyCondition(this.compareToNull(var, true));
        }
    }

    private int getOrCreateEqClassIndex(DfaValue dfaValue) {
        int i = this.getEqClassIndex(dfaValue);
        if (i != -1) {
            return i;
        }
        SortedIntSet aClass = new SortedIntSet();
        aClass.add(dfaValue.getID());
        this.myEqClasses.add(aClass);
        ++this.myStateSize;
        return this.myEqClasses.size() - 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<DfaValue> getEqClassesFor(@NotNull DfaValue dfaValue) {
        List<DfaValue> list;
        SortedIntSet set;
        if (dfaValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl.getEqClassesFor must not be null");
        }
        int index = this.getEqClassIndex(dfaValue);
        SortedIntSet sortedIntSet = set = index == -1 ? null : this.myEqClasses.get(index);
        if (set == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl.getEqClassesFor must not return null");
            return list;
        }
        final ArrayList<DfaValue> result = new ArrayList<DfaValue>(set.size());
        set.forEach(new TIntProcedure(){

            public boolean execute(int c1) {
                DfaValue value = DfaMemoryStateImpl.this.myFactory.getValue(c1);
                result.add(value);
                return true;
            }
        });
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl.getEqClassesFor must not return null");
    }

    @Override
    public boolean canBeNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl.canBeNaN must not be null");
        }
        List<DfaValue> eqClasses = this.getEqClassesFor(dfaValue);
        for (DfaValue eqClass : eqClasses) {
            if (!DfaMemoryStateImpl.isNaN(eqClass)) continue;
            return true;
        }
        return false;
    }

    private int getEqClassIndex(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl.getEqClassIndex must not be null");
        }
        for (int i = 0; i < this.myEqClasses.size(); ++i) {
            SortedIntSet aClass = this.myEqClasses.get(i);
            if (aClass == null || !aClass.contains(dfaValue.getID())) continue;
            if (dfaValue instanceof DfaBoxedValue && !DfaMemoryStateImpl.canBeReused(((DfaBoxedValue)dfaValue).getWrappedValue(), this) && aClass.size() > 1) {
                return -1;
            }
            return i;
        }
        return -1;
    }

    private static boolean canBeReused(DfaValue valueToWrap, DfaMemoryState memoryState) {
        if (valueToWrap instanceof DfaConstValue) {
            return DfaMemoryStateImpl.cacheable((DfaConstValue)valueToWrap);
        }
        if (valueToWrap instanceof DfaVariableValue) {
            if (PsiType.BOOLEAN.equals(((DfaVariableValue)valueToWrap).getPsiVariable().getType())) {
                return true;
            }
            List<DfaValue> values = ((DfaMemoryStateImpl)memoryState).getEqClassesFor(valueToWrap);
            for (DfaValue value : values) {
                if (!(value instanceof DfaConstValue) || !DfaMemoryStateImpl.cacheable((DfaConstValue)value)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean cacheable(DfaConstValue dfaConstValue) {
        Object value = dfaConstValue.getValue();
        return DfaMemoryStateImpl.box(value) == DfaMemoryStateImpl.box(value);
    }

    private static Object box(Object value) {
        Constable newBoxedValue;
        if (value instanceof Integer) {
            newBoxedValue = (int)((Integer)value);
        } else if (value instanceof Byte) {
            newBoxedValue = (byte)((Byte)value);
        } else if (value instanceof Short) {
            newBoxedValue = (short)((Short)value);
        } else if (value instanceof Long) {
            newBoxedValue = (long)((Long)value);
        } else if (value instanceof Boolean) {
            newBoxedValue = (Boolean)value;
        } else if (value instanceof Character) {
            newBoxedValue = Character.valueOf(((Character)value).charValue());
        } else {
            return new Object();
        }
        return newBoxedValue;
    }

    private boolean uniteClasses(int c1Index, int c2Index) {
        int i;
        long[] distincts;
        SortedIntSet c1 = this.myEqClasses.get(c1Index);
        SortedIntSet c2 = this.myEqClasses.get(c2Index);
        THashSet vars = new THashSet();
        THashSet negatedvars = new THashSet();
        int[] cs = new int[c1.size() + c2.size()];
        c1.set(0, cs, 0, c1.size());
        c2.set(0, cs, c1.size(), c2.size());
        int nConst = 0;
        for (int c : cs) {
            DfaValue dfaValue = this.myFactory.getValue(c);
            if (dfaValue instanceof DfaBoxedValue) {
                dfaValue = ((DfaBoxedValue)dfaValue).getWrappedValue();
            }
            if (dfaValue instanceof DfaUnboxedValue) {
                dfaValue = ((DfaUnboxedValue)dfaValue).getVariable();
            }
            if (dfaValue instanceof DfaConstValue) {
                ++nConst;
            }
            if (dfaValue instanceof DfaVariableValue) {
                DfaVariableValue variableValue = (DfaVariableValue)dfaValue;
                PsiVariable variable = variableValue.getPsiVariable();
                THashSet set = variableValue.isNegated() ? negatedvars : vars;
                set.add(variable);
            }
            if (nConst <= 1) continue;
            return false;
        }
        if (ContainerUtil.intersects((Collection)vars, (Collection)negatedvars)) {
            return false;
        }
        TLongArrayList c2Pairs = new TLongArrayList();
        for (long distinct : distincts = this.myDistinctClasses.toArray()) {
            int pc1 = DfaMemoryStateImpl.low(distinct);
            int pc2 = DfaMemoryStateImpl.high(distinct);
            boolean addedToC1 = false;
            if (pc1 == c1Index || pc2 == c1Index) {
                addedToC1 = true;
            }
            if (pc1 != c2Index && pc2 != c2Index) continue;
            if (addedToC1) {
                return false;
            }
            c2Pairs.add(distinct);
        }
        for (i = 0; i < c2.size(); ++i) {
            int c;
            c = c2.get(i);
            c1.add(c);
        }
        for (i = 0; i < c2Pairs.size(); ++i) {
            long c = c2Pairs.get(i);
            this.myDistinctClasses.remove(c);
            this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, DfaMemoryStateImpl.low(c) == c2Index ? DfaMemoryStateImpl.high(c) : DfaMemoryStateImpl.low(c)));
        }
        this.myEqClasses.set(c2Index, null);
        --this.myStateSize;
        return true;
    }

    private static int low(long l) {
        return (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    private static int high(long l) {
        return (int)((l & 0xFFFFFFFF00000000L) >> 32);
    }

    private static long createPair(int i1, int i2) {
        if (i1 < i2) {
            long l = i1;
            l <<= 32;
            return l += (long)i2;
        }
        long l = i2;
        l <<= 32;
        return l += (long)i1;
    }

    private void makeClassesDistinct(int c1Index, int c2Index) {
        this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, c2Index));
    }

    @Override
    public boolean isNull(DfaValue dfaValue) {
        if (dfaValue instanceof DfaNotNullValue) {
            return false;
        }
        if (dfaValue instanceof DfaVariableValue || dfaValue instanceof DfaConstValue) {
            int c2Index;
            DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
            int c1Index = this.getOrCreateEqClassIndex(dfaValue);
            return c1Index == (c2Index = this.getOrCreateEqClassIndex(dfaNull));
        }
        return false;
    }

    @Override
    public boolean isNotNull(DfaVariableValue dfaVar) {
        long[] pairs;
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        int c1Index = this.getOrCreateEqClassIndex(dfaVar);
        int c2Index = this.getOrCreateEqClassIndex(dfaNull);
        for (long pair : pairs = this.myDistinctClasses.toArray()) {
            if ((DfaMemoryStateImpl.low(pair) != c1Index || DfaMemoryStateImpl.high(pair) != c2Index) && (DfaMemoryStateImpl.high(pair) != c1Index || DfaMemoryStateImpl.low(pair) != c2Index)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean applyInstanceofOrNull(DfaRelationValue dfaCond) {
        DfaVariableState varState;
        DfaValue left = dfaCond.getLeftOperand();
        if (left instanceof DfaBoxedValue) {
            left = ((DfaBoxedValue)left).getWrappedValue();
        } else if (left instanceof DfaUnboxedValue) {
            left = ((DfaUnboxedValue)left).getVariable();
        }
        if (!(left instanceof DfaVariableValue)) {
            return true;
        }
        DfaVariableValue dfaVar = (DfaVariableValue)left;
        DfaTypeValue dfaType = (DfaTypeValue)dfaCond.getRightOperand();
        varState.setNullable((varState = this.getVariableState(dfaVar)).isNullable() || dfaType.isNullable());
        return !this.isNotNull(dfaVar) || varState.setInstanceofValue(dfaType);
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        Object constVal;
        if (dfaCond instanceof DfaUnknownValue) {
            return true;
        }
        if (dfaCond instanceof DfaUnboxedValue) {
            DfaVariableValue dfaVar = ((DfaUnboxedValue)dfaCond).getVariable();
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? (DfaVariableValue)dfaVar.createNegated() : dfaVar;
            DfaConstValue dfaTrue = this.myFactory.getConstFactory().getTrue();
            DfaValue boxedTrue = this.myFactory.getBoxedFactory().createBoxed(dfaTrue);
            DfaRelationValue dfaEqualsTrue = this.myFactory.getRelationFactory().create(dfaNormalVar, boxedTrue, "==", isNegated);
            return this.applyCondition(dfaEqualsTrue);
        }
        if (dfaCond instanceof DfaVariableValue) {
            DfaVariableValue dfaVar = (DfaVariableValue)dfaCond;
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? (DfaVariableValue)dfaVar.createNegated() : dfaVar;
            DfaConstValue dfaTrue = this.myFactory.getConstFactory().getTrue();
            DfaRelationValue dfaEqualsTrue = this.myFactory.getRelationFactory().create(dfaNormalVar, dfaTrue, "==", isNegated);
            return this.applyCondition(dfaEqualsTrue);
        }
        if (dfaCond instanceof DfaConstValue) {
            return dfaCond == this.myFactory.getConstFactory().getTrue() || dfaCond != this.myFactory.getConstFactory().getFalse();
        }
        if (!(dfaCond instanceof DfaRelationValue)) {
            return true;
        }
        DfaRelationValue dfaRelation = (DfaRelationValue)dfaCond;
        DfaValue dfaLeft = dfaRelation.getLeftOperand();
        DfaValue dfaRight = dfaRelation.getRightOperand();
        if (dfaRight == null || dfaLeft == null) {
            return false;
        }
        boolean isNegated = dfaRelation.isNegated();
        if (dfaLeft instanceof DfaNotNullValue && dfaRight == this.myFactory.getConstFactory().getNull()) {
            return isNegated;
        }
        if (dfaRight instanceof DfaTypeValue) {
            if (dfaLeft instanceof DfaVariableValue) {
                DfaVariableState varState = this.getVariableState((DfaVariableValue)dfaLeft);
                DfaVariableValue dfaVar = (DfaVariableValue)dfaLeft;
                if (isNegated) {
                    return varState.addNotInstanceofValue((DfaTypeValue)dfaRight) || this.applyCondition(this.compareToNull(dfaVar, false));
                }
                return this.applyCondition(this.compareToNull(dfaVar, true)) && varState.setInstanceofValue((DfaTypeValue)dfaRight);
            }
            return true;
        }
        if (dfaRight == this.myFactory.getConstFactory().getNull() && dfaLeft instanceof DfaVariableValue) {
            DfaVariableState varState = this.getVariableState((DfaVariableValue)dfaLeft);
            if (varState.isNotNull()) {
                return isNegated;
            }
            varState.setNullable(true);
        }
        if (dfaLeft instanceof DfaUnknownValue || dfaRight instanceof DfaUnknownValue) {
            return true;
        }
        boolean result = this.applyRelation(dfaLeft, dfaRight, isNegated);
        if (dfaRight instanceof DfaConstValue && (constVal = ((DfaConstValue)dfaRight).getValue()) instanceof Boolean) {
            boolean neg = (Boolean)constVal == false;
            DfaConstValue negVal = this.myFactory.getConstFactory().createFromValue(neg, PsiType.BOOLEAN);
            result &= this.applyRelation(dfaLeft, negVal, !isNegated);
        }
        if (dfaLeft instanceof DfaVariableValue) {
            PsiVariable psiVariable = ((DfaVariableValue)dfaLeft).getPsiVariable();
            if (TypeConversionUtil.isPrimitiveWrapper((PsiType)psiVariable.getType()) && (!isNegated || dfaRight instanceof DfaConstValue || dfaRight instanceof DfaBoxedValue && ((DfaBoxedValue)dfaRight).getWrappedValue() instanceof DfaConstValue)) {
                dfaLeft = this.myFactory.getBoxedFactory().createUnboxed(dfaLeft);
                dfaRight = this.myFactory.getBoxedFactory().createUnboxed(dfaRight);
                result &= this.applyRelation(dfaLeft, dfaRight, isNegated);
            } else if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)psiVariable.getType())) {
                dfaLeft = this.myFactory.getBoxedFactory().createBoxed(dfaLeft);
                dfaRight = this.myFactory.getBoxedFactory().createBoxed(dfaRight);
                if (dfaLeft != null && dfaRight != null) {
                    result &= this.applyRelation(dfaLeft, dfaRight, isNegated);
                }
            }
        }
        return result;
    }

    private static boolean isNaN(DfaValue dfa) {
        if (dfa instanceof DfaConstValue) {
            Object value = ((DfaConstValue)dfa).getValue();
            if (value instanceof Double && ((Double)value).isNaN()) {
                return true;
            }
            if (value instanceof Float && ((Float)value).isNaN()) {
                return true;
            }
        } else if (dfa instanceof DfaBoxedValue) {
            return DfaMemoryStateImpl.isNaN(((DfaBoxedValue)dfa).getWrappedValue());
        }
        return false;
    }

    private boolean applyRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight, boolean isNegated) {
        if (dfaLeft == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl.applyRelation must not be null");
        }
        if (dfaRight == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl.applyRelation must not be null");
        }
        int c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        int c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (!isNegated) {
            if (c1Index == c2Index) {
                return true;
            }
            if (!this.uniteClasses(c1Index, c2Index)) {
                return false;
            }
        } else {
            if (c1Index == c2Index) {
                return false;
            }
            this.makeClassesDistinct(c1Index, c2Index);
        }
        return true;
    }

    @Override
    public boolean checkNotNullable(DfaValue value) {
        if (value == this.myFactory.getConstFactory().getNull()) {
            return false;
        }
        if (value instanceof DfaTypeValue && ((DfaTypeValue)value).isNullable()) {
            return false;
        }
        if (value instanceof DfaVariableValue) {
            if (this.isNotNull((DfaVariableValue)value)) {
                return true;
            }
            DfaVariableState varState = this.getVariableState((DfaVariableValue)value);
            if (varState.isNullable()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean applyNotNull(DfaValue value) {
        return this.checkNotNullable(value) && this.applyCondition(this.compareToNull(value, true));
    }

    @Nullable
    private DfaRelationValue compareToNull(DfaValue dfaVar, boolean negated) {
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        return this.myFactory.getRelationFactory().create(dfaVar, dfaNull, "==", negated);
    }

    public DfaVariableState getVariableState(DfaVariableValue dfaVar) {
        DfaVariableState state = this.myVariableStates.get(dfaVar);
        if (state == null) {
            PsiVariable psiVariable = dfaVar.getPsiVariable();
            state = this.createVariableState(psiVariable);
            this.myVariableStates.put(dfaVar, state);
            if (psiVariable != null) {
                state.setInstanceofValue(this.myFactory.getTypeFactory().create(psiVariable.getType()));
            }
        }
        return state;
    }

    protected Map<DfaVariableValue, DfaVariableState> getVariableStates() {
        return this.myVariableStates;
    }

    protected DfaVariableState createVariableState(PsiVariable psiVariable) {
        return new DfaVariableState(psiVariable);
    }

    @Override
    public void flushFields(DataFlowRunner runner) {
        DfaVariableValue[] fields;
        for (DfaVariableValue field : fields = runner.getFields()) {
            this.flushVariable(field);
        }
    }

    @Override
    public void flushVariable(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl.flushVariable must not be null");
        }
        int id = variable.getID();
        int size = this.myEqClasses.size();
        int interruptCount = 0;
        for (int varClassIndex = 0; varClassIndex < size; ++varClassIndex) {
            long[] pairs;
            SortedIntSet varClass = this.myEqClasses.get(varClassIndex);
            if (varClass == null) continue;
            for (int i = 0; i < varClass.size(); ++i) {
                int cl;
                DfaValue value;
                if ((++interruptCount & 0xF) == 0) {
                    ProgressManager.checkCanceled();
                }
                if (!((value = this.myFactory.getValue(cl = varClass.get(i))) != null && id == value.getID() || value instanceof DfaBoxedValue && ((DfaBoxedValue)value).getWrappedValue().getID() == id) && (!(value instanceof DfaUnboxedValue) || ((DfaUnboxedValue)value).getVariable().getID() != id)) continue;
                varClass.remove(i);
                break;
            }
            if (!varClass.isEmpty()) continue;
            this.myEqClasses.set(varClassIndex, null);
            --this.myStateSize;
            for (long pair : pairs = this.myDistinctClasses.toArray()) {
                if (DfaMemoryStateImpl.low(pair) != varClassIndex && DfaMemoryStateImpl.high(pair) != varClassIndex) continue;
                this.myDistinctClasses.remove(pair);
            }
        }
        this.myVariableStates.remove(variable);
    }
}

