/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.util.Function;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class InspectionRVContentProviderImpl
extends InspectionRVContentProvider {
    public InspectionRVContentProviderImpl(Project project) {
        super(project);
    }

    @Override
    public boolean checkReportedProblems(InspectionTool tool) {
        tool.updateContent();
        return tool.hasReportedProblems();
    }

    @Override
    @Nullable
    public QuickFixAction[] getQuickFixes(InspectionTool tool, InspectionTree tree) {
        RefEntity[] refEntities = tree.getSelectedElements();
        return refEntities.length == 0 ? null : tool.getQuickFixes(refEntities);
    }

    @Override
    public void appendToolNodeContent(InspectionNode toolNode, InspectionTreeNode parentNode, boolean showStructure) {
        InspectionTool tool = toolNode.getTool();
        final Map<RefEntity, CommonProblemDescriptor[]> problems = tool instanceof DescriptorProviderInspection ? ((DescriptorProviderInspection)tool).getProblemElements() : null;
        Object computeContainer = new Function<RefEntity, InspectionRVContentProvider.UserObjectContainer<RefEntity>>(){

            public InspectionRVContentProvider.UserObjectContainer<RefEntity> fun(RefEntity refElement) {
                return new RefElementContainer(refElement, problems != null ? (CommonProblemDescriptor[])problems.get(refElement) : null);
            }
        };
        Map contents = tool.getContent();
        Set<RefModule> moduleProblems = tool.getModuleProblems();
        if (moduleProblems != null) {
            HashSet entities = contents.get("");
            if (entities == null) {
                entities = new HashSet();
                contents.put("", entities);
            }
            entities.addAll(moduleProblems);
        }
        List<InspectionTreeNode> list = this.buildTree(contents, false, tool, computeContainer, showStructure);
        for (InspectionTreeNode node : list) {
            InspectionRVContentProviderImpl.merge(node, toolNode, true);
        }
        if (tool.isOldProblemsIncluded()) {
            final HashMap<RefEntity, CommonProblemDescriptor[]> oldProblems = tool instanceof DescriptorProviderInspection ? ((DescriptorProviderInspection)tool).getOldProblemElements() : null;
            computeContainer = new Function<RefEntity, InspectionRVContentProvider.UserObjectContainer<RefEntity>>(){

                public InspectionRVContentProvider.UserObjectContainer<RefEntity> fun(RefEntity refElement) {
                    return new RefElementContainer(refElement, oldProblems != null ? (CommonProblemDescriptor[])oldProblems.get(refElement) : null);
                }
            };
            list = this.buildTree(tool.getOldContent(), true, tool, computeContainer, showStructure);
            for (InspectionTreeNode node : list) {
                InspectionRVContentProviderImpl.merge(node, toolNode, true);
            }
        }
        InspectionRVContentProviderImpl.merge(toolNode, parentNode, true);
    }

    @Override
    protected void appendDescriptor(InspectionTool tool, InspectionRVContentProvider.UserObjectContainer container, InspectionPackageNode pNode, boolean canPackageRepeat) {
        GlobalInspectionContextImpl context = tool.getContext();
        RefElementContainer refElementDescriptor = (RefElementContainer)container;
        RefEntity refElement = refElementDescriptor.getUserObject();
        if (context.getUIOptions().SHOW_ONLY_DIFF && tool.getElementStatus(refElement) == FileStatus.NOT_CHANGED) {
            return;
        }
        if (tool instanceof DescriptorProviderInspection) {
            DescriptorProviderInspection descriptorProviderInspection = (DescriptorProviderInspection)tool;
            CommonProblemDescriptor[] problems = refElementDescriptor.getProblemDescriptors();
            if (problems != null) {
                RefElementNode elemNode = InspectionRVContentProviderImpl.addNodeToParent(container, tool, pNode);
                for (CommonProblemDescriptor problem : problems) {
                    if (context.getUIOptions().SHOW_ONLY_DIFF && descriptorProviderInspection.getProblemStatus(problem) == FileStatus.NOT_CHANGED) continue;
                    elemNode.add(new ProblemDescriptionNode(refElement, problem, descriptorProviderInspection));
                    if (problems.length != 1) continue;
                    elemNode.setProblem(problems[0]);
                }
            }
        } else {
            HashSet currentEntities;
            Set<RefEntity> currentElements;
            if (canPackageRepeat && (currentElements = tool.getContent().get(pNode.getPackageName())) != null && InspectionTool.contains(refElement, (Collection<RefEntity>)(currentEntities = new HashSet(currentElements)))) {
                return;
            }
            InspectionRVContentProviderImpl.addNodeToParent(container, tool, pNode);
        }
    }

    private static class RefElementContainer
    implements InspectionRVContentProvider.UserObjectContainer<RefEntity> {
        private final RefEntity myElement;
        private final CommonProblemDescriptor[] myDescriptors;

        public RefElementContainer(RefEntity element, CommonProblemDescriptor[] descriptors) {
            this.myElement = element;
            this.myDescriptors = descriptors;
        }

        @Nullable
        public RefElementContainer getOwner() {
            RefEntity entity = this.myElement.getOwner();
            if (entity instanceof RefElement) {
                return new RefElementContainer(entity, this.myDescriptors);
            }
            return null;
        }

        @Override
        public RefElementNode createNode(InspectionTool tool) {
            return new RefElementNode((Object)this.myElement, tool);
        }

        @Override
        public RefEntity getUserObject() {
            return this.myElement;
        }

        @Override
        @Nullable
        public String getModule() {
            RefModule refModule = this.myElement instanceof RefElement ? ((RefElement)this.myElement).getModule() : (this.myElement instanceof RefModule ? (RefModule)this.myElement : null);
            return refModule != null ? refModule.getName() : null;
        }

        @Override
        public boolean areEqual(RefEntity o1, RefEntity o2) {
            return Comparing.equal((Object)o1, (Object)o2);
        }

        @Override
        public boolean supportStructure() {
            return this.myElement instanceof RefElement && !(this.myElement instanceof RefDirectory);
        }

        public CommonProblemDescriptor[] getProblemDescriptors() {
            return this.myDescriptors;
        }
    }
}

