/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class QuickFixWrapper
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInspection.ex.QuickFixWrapper");
    private final ProblemDescriptor myDescriptor;
    private final int myFixNumber;

    public static IntentionAction wrap(@NotNull ProblemDescriptor descriptor, int fixNumber) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/QuickFixWrapper.wrap must not be null");
        }
        LOG.assertTrue(fixNumber > -1);
        LOG.assertTrue(descriptor.getFixes() != null && descriptor.getFixes().length > fixNumber);
        QuickFix fix = descriptor.getFixes()[fixNumber];
        return fix instanceof IntentionAction ? (IntentionAction)fix : new QuickFixWrapper(descriptor, fixNumber);
    }

    private QuickFixWrapper(@NotNull ProblemDescriptor descriptor, int fixNumber) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/QuickFixWrapper.<init> must not be null");
        }
        this.myDescriptor = descriptor;
        this.myFixNumber = fixNumber;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/QuickFixWrapper.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myDescriptor.getFixes()[this.myFixNumber].getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/QuickFixWrapper.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/QuickFixWrapper.isAvailable must not be null");
        }
        PsiElement psiElement = this.myDescriptor.getPsiElement();
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        LocalQuickFix fix = this.getFix();
        return fix instanceof IntentionAction ? ((IntentionAction)fix).isAvailable(project, editor, file) : true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiFile fileForUndo;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/QuickFixWrapper.invoke must not be null");
        }
        LocalQuickFix fix = this.getFix();
        fix.applyFix(project, (CommonProblemDescriptor)this.myDescriptor);
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
        PsiElement element = this.myDescriptor.getPsiElement();
        if (element != null && !Comparing.equal((Object)(fileForUndo = element.getContainingFile()), (Object)file)) {
            UndoUtil.markPsiFileForUndo((PsiFile)fileForUndo);
        }
    }

    public boolean startInWriteAction() {
        LocalQuickFix fix = this.getFix();
        return fix instanceof IntentionAction ? ((IntentionAction)fix).startInWriteAction() : true;
    }

    public LocalQuickFix getFix() {
        return (LocalQuickFix)this.myDescriptor.getFixes()[this.myFixNumber];
    }

    public String toString() {
        return this.getText();
    }
}

