/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.impl.OneProjectItemCompileScope;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.impl.TranslatingCompilerFilesMonitor;
import com.intellij.compiler.impl.javaCompiler.AnnotationProcessingCompiler;
import com.intellij.compiler.impl.javaCompiler.JavaCompiler;
import com.intellij.compiler.impl.resourceCompiler.ResourceCompiler;
import com.intellij.compiler.impl.rmiCompiler.RmicCompiler;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerFactory;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.OutputToSourceMapping;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.impl.compiler.IncrementalArtifactsCompiler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerManagerImpl
extends CompilerManager {
    private final Project myProject;
    private final List<Compiler> myCompilers = new ArrayList<Compiler>();
    private final List<TranslatingCompiler> myTranslators = new ArrayList<TranslatingCompiler>();
    private final List<CompileTask> myBeforeTasks = new ArrayList<CompileTask>();
    private final List<CompileTask> myAfterTasks = new ArrayList<CompileTask>();
    private final Set<FileType> myCompilableTypes = new HashSet<FileType>();
    private final CompilationStatusListener myEventPublisher;
    private final Semaphore myCompilationSemaphore = new Semaphore(1, true);
    private final Map<Compiler, Set<FileType>> myCompilerToInputTypes = new HashMap<Compiler, Set<FileType>>();
    private final Map<Compiler, Set<FileType>> myCompilerToOutputTypes = new HashMap<Compiler, Set<FileType>>();
    private final Map<CompilationStatusListener, MessageBusConnection> myListenerAdapters = new HashMap<CompilationStatusListener, MessageBusConnection>();
    private static List<String> ourDeletedPaths;
    private static List<String> ourRecompiledPaths;
    private static List<String> ourCompiledPaths;
    private static final OutputToSourceMapping OUTPUT_TO_SOURCE_MAPPING;

    public CompilerManagerImpl(Project project, CompilerConfigurationImpl compilerConfiguration, MessageBus messageBus) {
        this.myProject = project;
        this.myEventPublisher = (CompilationStatusListener)messageBus.syncPublisher(CompilerTopics.COMPILATION_STATUS);
        this.addTranslatingCompiler(new AnnotationProcessingCompiler(project), new HashSet<LanguageFileType>(Arrays.asList(StdFileTypes.JAVA)), new HashSet<FileType>(Arrays.asList(StdFileTypes.JAVA, StdFileTypes.CLASS)));
        this.addTranslatingCompiler(new JavaCompiler(project), new HashSet<LanguageFileType>(Arrays.asList(StdFileTypes.JAVA)), new HashSet<FileType>(Arrays.asList(StdFileTypes.CLASS)));
        this.addCompiler((Compiler)new ResourceCompiler(project, compilerConfiguration));
        this.addCompiler((Compiler)new RmicCompiler());
        this.addCompiler((Compiler)new IncrementalArtifactsCompiler());
        for (Compiler compiler : (Compiler[])Extensions.getExtensions((ExtensionPointName)Compiler.EP_NAME, (AreaInstance)this.myProject)) {
            this.addCompiler(compiler);
        }
        for (Compiler compiler : (CompilerFactory[])Extensions.getExtensions((ExtensionPointName)CompilerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            Compiler[] compilers;
            for (Compiler compiler2 : compilers = compiler.createCompilers((CompilerManager)this)) {
                this.addCompiler(compiler2);
            }
        }
        this.addCompilableFileType((FileType)StdFileTypes.JAVA);
    }

    public Semaphore getCompilationSemaphore() {
        return this.myCompilationSemaphore;
    }

    public boolean isCompilationActive() {
        return this.myCompilationSemaphore.availablePermits() == 0;
    }

    public void addTranslatingCompiler(@NotNull TranslatingCompiler compiler, Set<FileType> inputTypes, Set<FileType> outputTypes) {
        if (compiler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.addTranslatingCompiler must not be null");
        }
        this.myTranslators.add(compiler);
        this.myCompilerToInputTypes.put((Compiler)compiler, inputTypes);
        this.myCompilerToOutputTypes.put((Compiler)compiler, outputTypes);
        List chunks = ModuleCompilerUtil.getSortedChunks(this.createCompilerGraph(this.myTranslators));
        this.myTranslators.clear();
        for (Chunk chunk : chunks) {
            for (Compiler chunkCompiler : chunk.getNodes()) {
                this.myTranslators.add((TranslatingCompiler)chunkCompiler);
            }
        }
    }

    @NotNull
    public Set<FileType> getRegisteredInputTypes(@NotNull TranslatingCompiler compiler) {
        if (compiler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.getRegisteredInputTypes must not be null");
        }
        Set<FileType> inputs = this.myCompilerToInputTypes.get(compiler);
        Set<Object> set = inputs != null ? Collections.unmodifiableSet(inputs) : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.getRegisteredInputTypes must not return null");
        }
        return set;
    }

    @NotNull
    public Set<FileType> getRegisteredOutputTypes(@NotNull TranslatingCompiler compiler) {
        if (compiler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.getRegisteredOutputTypes must not be null");
        }
        Set<FileType> outs = this.myCompilerToOutputTypes.get(compiler);
        Set<Object> set = outs != null ? Collections.unmodifiableSet(outs) : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.getRegisteredOutputTypes must not return null");
        }
        return set;
    }

    public final void addCompiler(@NotNull Compiler compiler) {
        if (compiler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.addCompiler must not be null");
        }
        if (compiler instanceof TranslatingCompiler) {
            this.myTranslators.add((TranslatingCompiler)compiler);
        } else {
            this.myCompilers.add(compiler);
        }
    }

    public final void removeCompiler(@NotNull Compiler compiler) {
        if (compiler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.removeCompiler must not be null");
        }
        if (compiler instanceof TranslatingCompiler) {
            this.myTranslators.remove(compiler);
        } else {
            this.myCompilers.remove(compiler);
        }
        this.myCompilerToInputTypes.remove(compiler);
        this.myCompilerToOutputTypes.remove(compiler);
    }

    @NotNull
    public <T extends Compiler> T[] getCompilers(@NotNull Class<T> compilerClass) {
        if (compilerClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.getCompilers must not be null");
        }
        Compiler[] compilerArray = this.getCompilers(compilerClass, CompilerFilter.ALL);
        if (compilerArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.getCompilers must not return null");
        }
        return compilerArray;
    }

    @NotNull
    public <T extends Compiler> T[] getCompilers(@NotNull Class<T> compilerClass, CompilerFilter filter) {
        if (compilerClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.getCompilers must not be null");
        }
        ArrayList<Object> compilers = new ArrayList<Object>(this.myCompilers.size());
        for (Compiler compiler : this.myCompilers) {
            if (!compilerClass.isAssignableFrom(compiler.getClass()) || !filter.acceptCompiler(compiler)) continue;
            compilers.add(compiler);
        }
        for (TranslatingCompiler translatingCompiler : this.myTranslators) {
            if (!compilerClass.isAssignableFrom(translatingCompiler.getClass()) || !filter.acceptCompiler((Compiler)translatingCompiler)) continue;
            compilers.add(translatingCompiler);
        }
        Compiler[] array = (Compiler[])Array.newInstance(compilerClass, compilers.size());
        Compiler[] compilerArray = compilers.toArray(array);
        if (compilerArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.getCompilers must not return null");
        }
        return compilerArray;
    }

    public void addCompilableFileType(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.addCompilableFileType must not be null");
        }
        this.myCompilableTypes.add(type);
    }

    public void removeCompilableFileType(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.removeCompilableFileType must not be null");
        }
        this.myCompilableTypes.remove(type);
    }

    public boolean isCompilableFileType(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.isCompilableFileType must not be null");
        }
        return this.myCompilableTypes.contains(type);
    }

    public final void addBeforeTask(@NotNull CompileTask task) {
        if (task == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.addBeforeTask must not be null");
        }
        this.myBeforeTasks.add(task);
    }

    public final void addAfterTask(@NotNull CompileTask task) {
        if (task == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.addAfterTask must not be null");
        }
        this.myAfterTasks.add(task);
    }

    @NotNull
    public CompileTask[] getBeforeTasks() {
        CompileTask[] compileTaskArray = this.myBeforeTasks.toArray(new CompileTask[this.myBeforeTasks.size()]);
        if (compileTaskArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.getBeforeTasks must not return null");
        }
        return compileTaskArray;
    }

    @NotNull
    public CompileTask[] getAfterTasks() {
        CompileTask[] compileTaskArray = this.myAfterTasks.toArray(new CompileTask[this.myAfterTasks.size()]);
        if (compileTaskArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.getAfterTasks must not return null");
        }
        return compileTaskArray;
    }

    public void compile(@NotNull VirtualFile[] files, CompileStatusNotification callback, boolean trackDependencies) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.compile must not be null");
        }
        this.compile(this.createFilesCompileScope(files), callback, trackDependencies);
    }

    public void compile(@NotNull Module module, CompileStatusNotification callback, boolean trackDependencies) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.compile must not be null");
        }
        new CompileDriver(this.myProject).compile(this.createModuleCompileScope(module, false), new ListenerNotificator(callback), trackDependencies, true);
    }

    public void compile(@NotNull CompileScope scope, CompileStatusNotification callback, boolean trackDependencies) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.compile must not be null");
        }
        new CompileDriver(this.myProject).compile(scope, new ListenerNotificator(callback), trackDependencies, false);
    }

    public void make(CompileStatusNotification callback) {
        new CompileDriver(this.myProject).make(this.createProjectCompileScope(this.myProject), new ListenerNotificator(callback));
    }

    public void make(@NotNull Module module, CompileStatusNotification callback) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.make must not be null");
        }
        new CompileDriver(this.myProject).make(this.createModuleCompileScope(module, true), new ListenerNotificator(callback));
    }

    public void make(@NotNull Project project, @NotNull Module[] modules, CompileStatusNotification callback) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.make must not be null");
        }
        if (modules == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.make must not be null");
        }
        new CompileDriver(this.myProject).make(this.createModuleGroupCompileScope(project, modules, true), new ListenerNotificator(callback));
    }

    public void make(@NotNull CompileScope scope, CompileStatusNotification callback) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.make must not be null");
        }
        new CompileDriver(this.myProject).make(scope, new ListenerNotificator(callback));
    }

    public void make(@NotNull CompileScope scope, CompilerFilter filter, @Nullable CompileStatusNotification callback) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.make must not be null");
        }
        CompileDriver compileDriver = new CompileDriver(this.myProject);
        compileDriver.setCompilerFilter(filter);
        compileDriver.make(scope, new ListenerNotificator(callback));
    }

    public boolean isUpToDate(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.isUpToDate must not be null");
        }
        return new CompileDriver(this.myProject).isUpToDate(scope);
    }

    public void rebuild(CompileStatusNotification callback) {
        new CompileDriver(this.myProject).rebuild(new ListenerNotificator(callback));
    }

    public void executeTask(@NotNull CompileTask task, @NotNull CompileScope scope, String contentName, Runnable onTaskFinished) {
        if (task == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.executeTask must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.executeTask must not be null");
        }
        CompileDriver compileDriver = new CompileDriver(this.myProject);
        compileDriver.executeCompileTask(task, scope, contentName, onTaskFinished);
    }

    public void addCompilationStatusListener(@NotNull CompilationStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.addCompilationStatusListener must not be null");
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        this.myListenerAdapters.put(listener, connection);
        connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)listener);
    }

    public void removeCompilationStatusListener(@NotNull CompilationStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.removeCompilationStatusListener must not be null");
        }
        MessageBusConnection connection = this.myListenerAdapters.remove(listener);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public static void testSetup() {
        ourDeletedPaths = new ArrayList<String>();
        ourRecompiledPaths = new ArrayList<String>();
        ourCompiledPaths = new ArrayList<String>();
    }

    public static void addDeletedPath(String path) {
        ourDeletedPaths.add(path);
    }

    public static void addRecompiledPath(String path) {
        ourRecompiledPaths.add(path);
    }

    public static void addCompiledPath(String path) {
        ourCompiledPaths.add(path);
    }

    public static String[] getPathsToDelete() {
        return ArrayUtil.toStringArray(ourDeletedPaths);
    }

    public static String[] getPathsToRecompile() {
        return ArrayUtil.toStringArray(ourRecompiledPaths);
    }

    public static String[] getPathsToCompile() {
        return ArrayUtil.toStringArray(ourCompiledPaths);
    }

    public static void clearPathsToCompile() {
        if (ourCompiledPaths != null) {
            ourCompiledPaths.clear();
        }
    }

    public boolean isExcludedFromCompilation(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.isExcludedFromCompilation must not be null");
        }
        return CompilerConfiguration.getInstance((Project)this.myProject).isExcludedFromCompilation(file);
    }

    @NotNull
    public OutputToSourceMapping getJavaCompilerOutputMapping() {
        OutputToSourceMapping outputToSourceMapping = OUTPUT_TO_SOURCE_MAPPING;
        if (outputToSourceMapping == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.getJavaCompilerOutputMapping must not return null");
        }
        return outputToSourceMapping;
    }

    @NotNull
    public CompileScope createFilesCompileScope(@NotNull VirtualFile[] files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.createFilesCompileScope must not be null");
        }
        CompileScope[] scopes = new CompileScope[files.length];
        for (int i = 0; i < files.length; ++i) {
            scopes[i] = new OneProjectItemCompileScope(this.myProject, files[i]);
        }
        CompositeScope compositeScope = new CompositeScope(scopes);
        if (compositeScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.createFilesCompileScope must not return null");
        }
        return compositeScope;
    }

    @NotNull
    public CompileScope createModuleCompileScope(@NotNull Module module, boolean includeDependentModules) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.createModuleCompileScope must not be null");
        }
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(module, includeDependentModules);
        if (moduleCompileScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.createModuleCompileScope must not return null");
        }
        return moduleCompileScope;
    }

    @NotNull
    public CompileScope createModulesCompileScope(@NotNull Module[] modules, boolean includeDependentModules) {
        if (modules == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.createModulesCompileScope must not be null");
        }
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(this.myProject, modules, includeDependentModules);
        if (moduleCompileScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.createModulesCompileScope must not return null");
        }
        return moduleCompileScope;
    }

    @NotNull
    public CompileScope createModuleGroupCompileScope(@NotNull Project project, @NotNull Module[] modules, boolean includeDependentModules) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.createModuleGroupCompileScope must not be null");
        }
        if (modules == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.createModuleGroupCompileScope must not be null");
        }
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(project, modules, includeDependentModules);
        if (moduleCompileScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.createModuleGroupCompileScope must not return null");
        }
        return moduleCompileScope;
    }

    @NotNull
    public CompileScope createProjectCompileScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/CompilerManagerImpl.createProjectCompileScope must not be null");
        }
        ProjectCompileScope projectCompileScope = new ProjectCompileScope(project);
        if (projectCompileScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerManagerImpl.createProjectCompileScope must not return null");
        }
        return projectCompileScope;
    }

    private Graph<Compiler> createCompilerGraph(final List<Compiler> compilers) {
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<Compiler>(){

            public Collection<Compiler> getNodes() {
                return compilers;
            }

            public Iterator<Compiler> getIn(Compiler compiler) {
                Set compilerInput = (Set)CompilerManagerImpl.this.myCompilerToInputTypes.get(compiler);
                if (compilerInput == null || compilerInput.isEmpty()) {
                    return Collections.emptySet().iterator();
                }
                HashSet<Compiler> inCompilers = new HashSet<Compiler>();
                for (Map.Entry entry : CompilerManagerImpl.this.myCompilerToOutputTypes.entrySet()) {
                    Set outputs = (Set)entry.getValue();
                    Compiler comp = (Compiler)entry.getKey();
                    if (outputs == null || !ContainerUtil.intersects((Collection)compilerInput, (Collection)outputs)) continue;
                    inCompilers.add(comp);
                }
                return inCompilers.iterator();
            }
        }));
    }

    static {
        OUTPUT_TO_SOURCE_MAPPING = new OutputToSourceMapping(){

            public String getSourcePath(String outputPath) {
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                VirtualFile outputFile = lfs.findFileByPath(outputPath);
                VirtualFile sourceFile = outputFile != null ? TranslatingCompilerFilesMonitor.getSourceFileByOutput(outputFile) : null;
                return sourceFile != null ? sourceFile.getPath() : null;
            }
        };
    }

    private class ListenerNotificator
    implements CompileStatusNotification {
        private final CompileStatusNotification myDelegate;

        private ListenerNotificator(CompileStatusNotification delegate) {
            this.myDelegate = delegate;
        }

        public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
            CompilerManagerImpl.this.myEventPublisher.compilationFinished(aborted, errors, warnings, compileContext);
            if (this.myDelegate != null) {
                this.myDelegate.finished(aborted, errors, warnings, compileContext);
            }
        }
    }
}

