/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.OutputParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EclipseCompilerErrorParser
extends OutputParser {
    private final StringBuilder problemText = new StringBuilder();

    @Override
    public boolean processMessageLine(OutputParser.Callback callback) {
        String line = callback.getNextLine();
        if (line == null) {
            this.spitOutProblem(callback);
            return false;
        }
        if (line.trim().length() == 0) {
            return true;
        }
        if (line.equals("----------")) {
            this.spitOutProblem(callback);
            this.problemText.setLength(0);
            return true;
        }
        this.problemText.append(line);
        this.problemText.append("\n");
        return true;
    }

    private void spitOutProblem(OutputParser.Callback callback) {
        String problem = this.problemText.toString();
        if (problem.trim().length() == 0) {
            return;
        }
        String problemTemplate = "(\\d*)\\. (\\w*) in (.*)\\s*\\(at line (\\d*)\\)\n\\s*(.*)\n(\\s*)\\^+\n(.*)\\s*";
        Pattern PATTERN = Pattern.compile("(\\d*)\\. (\\w*) in (.*)\\s*\\(at line (\\d*)\\)\n\\s*(.*)\n(\\s*)\\^+\n(.*)\\s*", 32);
        Matcher matcher = PATTERN.matcher(problem);
        if (matcher.matches()) {
            String problemType = matcher.group(2);
            String path = matcher.group(3).trim();
            String lineNum = matcher.group(4);
            String codeSnippet = matcher.group(5);
            String indentWhiteSpace = matcher.group(6);
            String message = matcher.group(7).trim();
            CompilerMessageCategory messageCategory = "WARNING".equals(problemType) ? CompilerMessageCategory.WARNING : ("ERROR".equals(problemType) ? CompilerMessageCategory.ERROR : CompilerMessageCategory.INFORMATION);
            final String url = VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)path));
            final int line = Integer.parseInt(lineNum);
            int col = indentWhiteSpace.length();
            final String offendingCode = codeSnippet.substring(col - 1);
            int colFromFile = (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

                public Integer compute() {
                    Document document;
                    int index = -1;
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                    Document document2 = document = file == null ? null : FileDocumentManager.getInstance().getDocument(file);
                    if (document != null) {
                        int docLine = line == 0 ? 0 : line - 1;
                        int startOffset = document.getLineStartOffset(docLine);
                        int endOffset = document.getLineEndOffset(docLine);
                        String lineText = document.getText().substring(startOffset, endOffset);
                        index = lineText.indexOf(offendingCode);
                        if (index == -1) {
                            for (index = 0; index < lineText.length() && Character.isWhitespace(lineText.charAt(index)); ++index) {
                            }
                            if (index == lineText.length()) {
                                index = -1;
                            }
                        }
                        if (index != -1) {
                            ++index;
                        }
                    }
                    return index;
                }
            });
            if (colFromFile != -1) {
                col = colFromFile;
            }
            callback.message(messageCategory, message, url, line, col);
        } else {
            callback.message(CompilerMessageCategory.WARNING, problem, null, -1, -1);
        }
    }

    @Override
    public boolean isTrimLines() {
        return false;
    }
}

