/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.ItemRemovable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class BreakpointTableModel
extends AbstractTableModel
implements ItemRemovable {
    public static final int ENABLED_STATE = 0;
    public static final int NAME = 1;
    private List<Breakpoint> myBreakpoints = new ArrayList<Breakpoint>();
    private final BreakpointManager myBreakpointManager;

    public BreakpointTableModel(Project project) {
        this.myBreakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
    }

    public final void setBreakpoints(Breakpoint[] breakpoints) {
        this.myBreakpoints.clear();
        if (breakpoints != null) {
            this.myBreakpoints.addAll(Arrays.asList(breakpoints));
        }
        this.fireTableDataChanged();
    }

    public List<Breakpoint> getBreakpoints() {
        return Collections.unmodifiableList(this.myBreakpoints);
    }

    public void removeBreakpoints(Breakpoint[] breakpoints) {
        this.myBreakpoints.removeAll(Arrays.asList(breakpoints));
        this.fireTableDataChanged();
    }

    public Breakpoint getBreakpoint(int index) {
        if (index < 0 || index >= this.myBreakpoints.size()) {
            return null;
        }
        return this.myBreakpoints.get(index);
    }

    public boolean isBreakpointEnabled(int index) {
        return (Boolean)this.getValueAt(index, 0);
    }

    public int getBreakpointIndex(Breakpoint breakpoint) {
        return this.myBreakpoints.indexOf(breakpoint);
    }

    public void insertBreakpointAt(Breakpoint breakpoint, int index) {
        this.myBreakpoints.add(index, breakpoint);
        this.fireTableRowsInserted(index, index);
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        this.myBreakpoints.add(breakpoint);
        int row = this.myBreakpoints.size() - 1;
        this.fireTableRowsInserted(row, row);
    }

    public void removeRow(int idx) {
        if (idx >= 0 && idx < this.myBreakpoints.size()) {
            this.myBreakpoints.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }
    }

    @Override
    public int getRowCount() {
        return this.myBreakpoints.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return DebuggerBundle.message((String)"breakpoint.table.header.column.enabled", (Object[])new Object[0]);
            }
            case 1: {
                return DebuggerBundle.message((String)"breakpoint.table.header.column.name", (Object[])new Object[0]);
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Breakpoint breakpoint = this.myBreakpoints.get(rowIndex);
        if (columnIndex == 1) {
            return breakpoint.getDisplayName();
        }
        if (columnIndex == 0) {
            return breakpoint.ENABLED ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.myBreakpoints.size()) {
            return;
        }
        Breakpoint breakpoint = this.myBreakpoints.get(rowIndex);
        if (columnIndex == 0) {
            boolean isEnabled = aValue == null || (Boolean)aValue != false;
            boolean valueChanged = isEnabled != breakpoint.ENABLED;
            breakpoint.ENABLED = isEnabled;
            if (valueChanged) {
                breakpoint.updateUI();
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            return false;
        }
        boolean isSlave = this.myBreakpointManager.findMasterBreakpoint(this.myBreakpoints.get(rowIndex)) != null;
        return !isSlave;
    }
}

