/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.VMOptions;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OutOfMemoryDialog
extends DialogWrapper {
    private final MemoryKind myMemoryKind;
    private JPanel myContentPane;
    private JLabel myMessageLabel;
    private JTextField myHeapSizeField;
    private JTextField myPermGenSizeField;
    private JLabel myHeapCurrentValueLabel;
    private JLabel myPermGenCurrentValueLabel;
    private JLabel myHeapSizeLabel;
    private JLabel myPermGenSizeLabel;
    private JLabel myHeapUnitsLabel;
    private JLabel myPermGenUnitsLabel;
    private JLabel mySettingsFileHintLabel;
    private final Action myIgnoreAction;
    private final Action myShutdownAction;

    public OutOfMemoryDialog(MemoryKind memoryKind) {
        super(false);
        this.myMemoryKind = memoryKind;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(DiagnosticBundle.message("diagnostic.out.of.memory.title", objectArray));
        this.myMessageLabel.setIcon(Messages.getErrorIcon());
        this.myMessageLabel.setText(DiagnosticBundle.message("diagnostic.out.of.memory.error", memoryKind == MemoryKind.HEAP ? "Xmx" : "XX:MaxPermSize", ApplicationNamesInfo.getInstance().getProductName()));
        this.mySettingsFileHintLabel.setText(DiagnosticBundle.message("diagnostic.out.of.memory.willBeSavedTo", VMOptions.getSettingsFilePath()));
        this.myIgnoreAction = new AbstractAction(DiagnosticBundle.message("diagnostic.out.of.memory.ignore", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutOfMemoryDialog.this.save();
                OutOfMemoryDialog.this.close(0);
            }
        };
        this.myShutdownAction = new AbstractAction(DiagnosticBundle.message("diagnostic.out.of.memory.shutdown", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutOfMemoryDialog.this.save();
                System.exit(0);
            }
        };
        this.myShutdownAction.putValue("DefaultAction", true);
        this.configControls("Xmx", VMOptions.readXmx(), memoryKind == MemoryKind.HEAP, this.myHeapSizeLabel, this.myHeapSizeField, this.myHeapUnitsLabel, this.myHeapCurrentValueLabel);
        this.configControls("XX:MaxPermSize", VMOptions.readMaxPermGen(), memoryKind == MemoryKind.PERM_GEN, this.myPermGenSizeLabel, this.myPermGenSizeField, this.myPermGenUnitsLabel, this.myPermGenCurrentValueLabel);
        this.init();
    }

    private void configControls(String optionName, int value, boolean highlight, JLabel sizeLabel, JTextField sizeField, JLabel unitsLabel, JLabel currentValueLabel) {
        sizeLabel.setText(optionName);
        String formatted = value == -1 ? DiagnosticBundle.message("diagnostic.out.of.memory.currentValue.unknown", new Object[0]) : String.valueOf(value);
        sizeField.setText(formatted);
        currentValueLabel.setText(DiagnosticBundle.message("diagnostic.out.of.memory.currentValue", formatted));
        if (highlight) {
            sizeLabel.setForeground(Color.RED);
            sizeField.setForeground(Color.RED);
            unitsLabel.setForeground(Color.RED);
            currentValueLabel.setForeground(Color.RED);
        }
    }

    private void save() {
        try {
            VMOptions.writeXmx(Integer.parseInt(this.myHeapSizeField.getText()));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            VMOptions.writeMaxPermGen(Integer.parseInt(this.myPermGenSizeField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    protected Action[] createActions() {
        return new Action[]{this.myShutdownAction, this.myIgnoreAction};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMemoryKind == MemoryKind.HEAP ? this.myHeapSizeField : this.myPermGenSizeField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JTextField jTextField;
        JTextField jTextField2;
        JLabel jLabel5;
        JLabel jLabel6;
        JLabel jLabel7;
        JLabel jLabel8;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myHeapSizeLabel = jLabel8 = new JLabel();
        jLabel8.setText("Label");
        jPanel.add((Component)jLabel8, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPermGenSizeLabel = jLabel7 = new JLabel();
        jLabel7.setText("Label");
        jPanel.add((Component)jLabel7, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeapUnitsLabel = jLabel6 = new JLabel();
        jLabel6.setText("MB");
        jPanel.add((Component)jLabel6, new GridConstraints(1, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPermGenUnitsLabel = jLabel5 = new JLabel();
        jLabel5.setText("MB");
        jPanel.add((Component)jLabel5, new GridConstraints(2, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeapSizeField = jTextField2 = new JTextField();
        jTextField2.setColumns(6);
        jPanel.add((Component)jTextField2, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myPermGenSizeField = jTextField = new JTextField();
        jTextField.setColumns(6);
        jPanel.add((Component)jTextField, new GridConstraints(2, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myHeapCurrentValueLabel = jLabel4 = new JLabel();
        Font font = jLabel4.getFont();
        jLabel4.setFont(new Font(font.getName(), 2, font.getSize()));
        jLabel4.setText("Label");
        jPanel.add((Component)jLabel4, new GridConstraints(1, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPermGenCurrentValueLabel = jLabel3 = new JLabel();
        Font font2 = jLabel3.getFont();
        jLabel3.setFont(new Font(font2.getName(), 2, font2.getSize()));
        jLabel3.setText("Label");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, new Dimension(51, 11), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(51, 14), null));
        this.myMessageLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 6, 8, 0, 0, 0, null, null, null));
        this.mySettingsFileHintLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 6, 4, 0, 0, 0, null, null, null));
        jLabel8.setLabelFor(jTextField2);
        jLabel7.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static enum MemoryKind {
        HEAP,
        PERM_GEN;

    }
}

