/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.DefaultConfigurationSettingsEditor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.config.StorageAccessors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RunConfigurable
extends BaseConfigurable {
    private static final Icon ICON = IconLoader.getIcon((String)"/general/configurableRunDebug.png");
    @NonNls
    private static final String GENERAL_ADD_ICON_PATH = "/general/add.png";
    private static final Icon ADD_ICON = IconLoader.getIcon((String)"/general/add.png");
    private static final Icon REMOVE_ICON = IconLoader.getIcon((String)"/general/remove.png");
    private static final Icon COPY_ICON = IconLoader.getIcon((String)"/actions/copy.png");
    private static final Icon SAVE_ICON = IconLoader.getIcon((String)"/runConfigurations/saveTempConfig.png");
    @NonNls
    private static final String EDIT_DEFAULTS_ICON_PATH = "/general/ideOptions.png";
    private static final Icon EDIT_DEFAULTS_ICON = IconLoader.getIcon((String)"/general/ideOptions.png");
    @NonNls
    private static final String DIVIDER_PROPORTION = "dividerProportion";
    private final Project myProject;
    private final RunDialog myRunDialog;
    @NonNls
    private final DefaultMutableTreeNode myRoot = new DefaultMutableTreeNode("Root");
    private final Tree myTree = new Tree((TreeNode)this.myRoot);
    private final JPanel myRightPanel = new JPanel(new BorderLayout());
    private JComponent myToolbarComponent;
    private final Splitter myPanel = new Splitter();
    private JPanel myWholePanel;
    private StorageAccessors myConfig;
    private SingleConfigurationConfigurable<RunConfiguration> mySelectedConfigurable = null;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.RunConfigurable");
    private JTextField myRecentsLimit = new JTextField("5");

    public RunConfigurable(Project project) {
        this(project, null);
    }

    public RunConfigurable(Project project, RunDialog runDialog) {
        this.myProject = project;
        this.myRunDialog = runDialog;
    }

    public String getDisplayName() {
        return ExecutionBundle.message((String)"run.configurable.display.name", (Object[])new Object[0]);
    }

    private void initTree() {
        ConfigurationType[] factories;
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        TreeToolTipHandler.install((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        PopupHandler.installFollowingSelectionTreePopup((JTree)this.myTree, (ActionGroup)this.createActionsGroup(), (String)"unknown", (ActionManager)ActionManager.getInstance());
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    Object userObject = node.getUserObject();
                    if (userObject instanceof ConfigurationType) {
                        ConfigurationType configurationType = (ConfigurationType)userObject;
                        this.append(configurationType.getDisplayName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        this.setIcon(configurationType.getIcon());
                    } else {
                        RunManagerImpl runManager = RunConfigurable.this.getRunManager();
                        Object configuration = null;
                        String name = null;
                        if (userObject instanceof SingleConfigurationConfigurable) {
                            SingleConfigurationConfigurable settings = (SingleConfigurationConfigurable)((Object)userObject);
                            this.setIcon(ExecutionUtil.getConfigurationIcon(RunConfigurable.this.getProject(), (RunnerAndConfigurationSettings)settings.getSettings(), !settings.isValid()));
                            configuration = settings.getConfiguration();
                            name = settings.getNameText();
                        } else if (userObject instanceof RunnerAndConfigurationSettingsImpl) {
                            RunnerAndConfigurationSettingsImpl settings = (RunnerAndConfigurationSettingsImpl)userObject;
                            this.setIcon(ExecutionUtil.getConfigurationIcon(RunConfigurable.this.getProject(), settings));
                            configuration = settings.getConfiguration();
                            name = configuration.getName();
                        }
                        if (configuration != null) {
                            this.append(name, runManager.isTemporary((RunConfiguration)configuration) ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }
                    }
                }
            }
        });
        final RunManagerImpl manager = this.getRunManager();
        for (ConfigurationType type : factories = manager.getConfigurationFactories()) {
            RunnerAndConfigurationSettingsImpl[] configurations = ((RunManagerEx)manager).getConfigurationSettings(type);
            if (configurations == null || configurations.length <= 0) continue;
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(type);
            this.myRoot.add(typeNode);
            for (RunnerAndConfigurationSettingsImpl configuration : configurations) {
                typeNode.add(new DefaultMutableTreeNode(configuration));
            }
        }
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectionPath = RunConfigurable.this.myTree.getSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    Object userObject = node.getUserObject();
                    if (userObject instanceof RunnerAndConfigurationSettingsImpl) {
                        SingleConfigurationConfigurable configurationConfigurable = SingleConfigurationConfigurable.editSettings((RunnerAndConfigurationSettingsImpl)userObject);
                        RunConfigurable.this.installUpdateListeners(configurationConfigurable);
                        node.setUserObject((Object)configurationConfigurable);
                        RunConfigurable.this.updateRightPanel(configurationConfigurable);
                    } else if (userObject instanceof SingleConfigurationConfigurable) {
                        RunConfigurable.this.updateRightPanel((SingleConfigurationConfigurable)((Object)userObject));
                    } else if (userObject instanceof ConfigurationType) {
                        RunConfigurable.this.drawPressAddButtonMessage((ConfigurationType)userObject);
                    }
                }
                RunConfigurable.this.updateDialog();
            }
        });
        this.myTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunConfigurable.this.clickDefaultButton();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunConfigurable.this.myTree.requestFocusInWindow();
                RunnerAndConfigurationSettingsImpl settings = manager.getSelectedConfiguration();
                if (settings != null) {
                    Enumeration<TreeNode> enumeration = RunConfigurable.this.myRoot.breadthFirstEnumeration();
                    while (enumeration.hasMoreElements()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
                        Object userObject = node.getUserObject();
                        if (!(userObject instanceof RunnerAndConfigurationSettingsImpl)) continue;
                        RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettings = (RunnerAndConfigurationSettingsImpl)userObject;
                        ConfigurationType configurationType = settings.getType();
                        if (configurationType == null || !Comparing.strEqual((String)runnerAndConfigurationSettings.getConfiguration().getType().getId(), (String)configurationType.getId()) || !Comparing.strEqual((String)runnerAndConfigurationSettings.getConfiguration().getName(), (String)settings.getName())) continue;
                        TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)true, (JTree)RunConfigurable.this.myTree);
                        return;
                    }
                } else {
                    RunConfigurable.this.mySelectedConfigurable = null;
                }
                TreeUtil.selectFirstNode((JTree)RunConfigurable.this.myTree);
                RunConfigurable.this.drawPressAddButtonMessage(null);
            }
        });
        RunConfigurable.sortTree(this.myRoot);
        ((DefaultTreeModel)this.myTree.getModel()).reload();
    }

    private void updateRightPanel(SingleConfigurationConfigurable<RunConfiguration> userObject) {
        this.myRightPanel.removeAll();
        this.mySelectedConfigurable = userObject;
        this.myRightPanel.add((Component)this.mySelectedConfigurable.createComponent(), "Center");
        this.setupDialogBounds();
    }

    public static void sortTree(DefaultMutableTreeNode root) {
        TreeUtil.sort((DefaultMutableTreeNode)root, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                Object userObject1 = ((DefaultMutableTreeNode)o1).getUserObject();
                Object userObject2 = ((DefaultMutableTreeNode)o2).getUserObject();
                if (userObject1 instanceof ConfigurationType && userObject2 instanceof ConfigurationType) {
                    return ((ConfigurationType)userObject1).getDisplayName().compareTo(((ConfigurationType)userObject2).getDisplayName());
                }
                return 0;
            }
        });
    }

    private void update() {
        this.updateDialog();
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            ((DefaultTreeModel)this.myTree.getModel()).reload(node);
        }
    }

    private void installUpdateListeners(SingleConfigurationConfigurable<RunConfiguration> info) {
        info.getEditor().addSettingsEditorListener((SettingsEditorListener)new SettingsEditorListener<RunnerAndConfigurationSettingsImpl>(){

            public void stateChanged(SettingsEditor<RunnerAndConfigurationSettingsImpl> editor) {
                RunConfigurable.this.update();
                RunConfigurable.this.setupDialogBounds();
            }
        });
        info.addNameListner(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RunConfigurable.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RunConfigurable.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RunConfigurable.this.update();
            }
        });
    }

    private void drawPressAddButtonMessage(ConfigurationType configurationType) {
        JEditorPane browser = new JEditorPane();
        browser.setBorder(null);
        browser.setEditable(false);
        browser.setEditorKit(new HTMLEditorKit());
        browser.setBackground(this.myRightPanel.getBackground());
        URL addUrl = ((Object)((Object)this)).getClass().getResource(GENERAL_ADD_ICON_PATH);
        URL defaultsURL = ((Object)((Object)this)).getClass().getResource(EDIT_DEFAULTS_ICON_PATH);
        Font font = UIUtil.getLabelFont();
        String configurationTypeDescription = configurationType != null ? configurationType.getConfigurationTypeDescription() : ExecutionBundle.message((String)"run.configuration.default.type.description", (Object[])new Object[0]);
        browser.setText(ExecutionBundle.message((String)"empty.run.configuration.panel.text.label", (Object[])new Object[]{font.getFontName(), addUrl, defaultsURL, configurationTypeDescription}));
        browser.setPreferredSize(new Dimension(200, 50));
        browser.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (Comparing.strEqual((String)e.getDescription(), (String)"add")) {
                        new MyToolbarAddAction().actionPerformed(null);
                    } else {
                        RunConfigurable.this.editDefaultsConfiguration();
                    }
                }
            }
        });
        this.myRightPanel.removeAll();
        this.myRightPanel.add((Component)browser, "Center");
        this.myRightPanel.revalidate();
        this.myRightPanel.repaint();
    }

    private JPanel createLeftPanel() {
        JPanel leftPanel = new JPanel(new BorderLayout());
        this.myToolbarComponent = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)this.createActionsGroup(), true).getComponent();
        leftPanel.add((Component)this.myToolbarComponent, "North");
        this.initTree();
        JScrollPane pane = ScrollPaneFactory.createScrollPane((JComponent)this.myTree);
        pane.setHorizontalScrollBarPolicy(30);
        leftPanel.add((Component)pane, "Center");
        JButton editDefaultsButton = new JButton(ExecutionBundle.message((String)"run.configuration.edit.default.configuration.settings.button", (Object[])new Object[0]));
        editDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunConfigurable.this.editDefaultsConfiguration();
            }
        });
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)editDefaultsButton, "North");
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        Box box = new Box(2);
        box.setBorder(BorderFactory.createEmptyBorder(7, 5, 3, 0));
        box.add(new JLabel("Temporary configurations limit:"));
        Dimension size = new Dimension(25, this.myRecentsLimit.getPreferredSize().height);
        this.myRecentsLimit.setPreferredSize(size);
        this.myRecentsLimit.setMaximumSize(size);
        this.myRecentsLimit.setMinimumSize(size);
        box.add(this.myRecentsLimit);
        this.myRecentsLimit.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                RunConfigurable.this.setModified(true);
            }
        });
        box.add(Box.createHorizontalGlue());
        bottomPanel.add((Component)box, "Center");
        leftPanel.add((Component)bottomPanel, "South");
        return leftPanel;
    }

    private void editDefaultsConfiguration() {
        new SingleConfigurableEditor(this.getProject(), (Configurable)new DefaultConfigurationSettingsEditor(this.myProject, this.getSelectedConfigurationType())).show();
    }

    private DefaultActionGroup createActionsGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new MyToolbarAddAction());
        group.add((AnAction)new MyRemoveAction());
        group.add((AnAction)new MyCopyAction());
        group.add((AnAction)new MySaveAction());
        group.add(new AnAction(ExecutionBundle.message((String)"run.configuration.edit.default.configuration.settings.button", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.edit.default.configuration.settings.button", (Object[])new Object[0]), EDIT_DEFAULTS_ICON){

            public void actionPerformed(AnActionEvent e) {
                RunConfigurable.this.editDefaultsConfiguration();
            }
        });
        group.add((AnAction)new MyMoveAction(ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/moveUp.png"), -1));
        group.add((AnAction)new MyMoveAction(ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/moveDown.png"), 1));
        return group;
    }

    @Nullable
    private ConfigurationType getSelectedConfigurationType() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode configurationTypeNode = this.getSelectedConfigurationTypeNode();
        return configurationTypeNode != null ? (ConfigurationType)configurationTypeNode.getUserObject() : null;
    }

    public JComponent createComponent() {
        this.myWholePanel = new JPanel(new BorderLayout());
        this.myPanel.setHonorComponentsMinimumSize(true);
        this.myConfig = StorageAccessors.createGlobal((String)"runConfigurationTab");
        this.myPanel.setShowDividerControls(true);
        this.myPanel.setProportion(this.myConfig.getFloat(DIVIDER_PROPORTION, 0.2f));
        this.myPanel.setHonorComponentsMinimumSize(true);
        this.myPanel.setFirstComponent((JComponent)this.createLeftPanel());
        this.myPanel.setSecondComponent((JComponent)this.myRightPanel);
        this.myWholePanel.add((Component)this.myPanel, "Center");
        this.updateDialog();
        Dimension d = this.myWholePanel.getPreferredSize();
        d.width = Math.max(d.width, 800);
        d.height = Math.max(d.height, 600);
        this.myWholePanel.setPreferredSize(d);
        return this.myWholePanel;
    }

    public Icon getIcon() {
        return ICON;
    }

    public void reset() {
        RunManagerImpl manager = this.getRunManager();
        RunManagerConfig config = ((RunManagerEx)manager).getConfig();
        this.myRecentsLimit.setText(Integer.toString(config.getRecentsLimit()));
        this.setModified(false);
    }

    private Project getProject() {
        return this.myProject;
    }

    public void apply() throws ConfigurationException {
        ConfigurationType[] configurationTypes;
        RunManagerImpl manager = this.getRunManager();
        for (ConfigurationType configurationType : configurationTypes = manager.getConfigurationFactories()) {
            this.applyByType(configurationType);
        }
        if (this.mySelectedConfigurable != null) {
            manager.setSelectedConfiguration((RunnerAndConfigurationSettingsImpl)this.mySelectedConfigurable.getSettings());
        } else {
            manager.setSelectedConfiguration(null);
        }
        String recentsLimit = this.myRecentsLimit.getText();
        try {
            int i = Integer.parseInt(recentsLimit);
            int oldLimit = manager.getConfig().getRecentsLimit();
            if (oldLimit != i) {
                manager.getConfig().setRecentsLimit(i);
                manager.checkRecentsLimit();
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.setModified(false);
    }

    private void applyByType(ConfigurationType type) throws ConfigurationException {
        SingleConfigurationConfigurable configurable;
        DefaultMutableTreeNode typeNode = this.getConfigurationTypeNode(type);
        RunManagerImpl manager = this.getRunManager();
        ArrayList<RunConfigurationBean> stableConfigurations = new ArrayList<RunConfigurationBean>();
        if (typeNode != null) {
            for (int i = 0; i < typeNode.getChildCount(); ++i) {
                Object userObject = ((DefaultMutableTreeNode)typeNode.getChildAt(i)).getUserObject();
                if (userObject instanceof SingleConfigurationConfigurable) {
                    configurable = (SingleConfigurationConfigurable)((Object)userObject);
                    RunnerAndConfigurationSettingsImpl settings = (RunnerAndConfigurationSettingsImpl)configurable.getSettings();
                    if (manager.isTemporary(settings)) {
                        this.applyConfiguration(typeNode, configurable);
                    }
                    stableConfigurations.add(new RunConfigurationBean(configurable));
                    continue;
                }
                if (!(userObject instanceof RunnerAndConfigurationSettingsImpl)) continue;
                RunnerAndConfigurationSettingsImpl settings = (RunnerAndConfigurationSettingsImpl)userObject;
                stableConfigurations.add(new RunConfigurationBean(settings, manager.isConfigurationShared(settings), manager.getBeforeRunTasks(settings.getConfiguration())));
            }
        }
        for (RunConfigurationBean bean : stableConfigurations) {
            configurable = bean.getConfigurable();
            if (configurable == null) continue;
            this.applyConfiguration(typeNode, configurable);
        }
        manager.removeConfigurations(type);
        for (RunConfigurationBean stableConfiguration : stableConfigurations) {
            manager.addConfiguration(stableConfiguration.getSettings(), stableConfiguration.isShared(), stableConfiguration.getStepsBeforeLaunch());
        }
    }

    @Nullable
    private DefaultMutableTreeNode getConfigurationTypeNode(ConfigurationType type) {
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myRoot.getChildAt(i);
            if (node.getUserObject() != type) continue;
            return node;
        }
        return null;
    }

    private void applyConfiguration(DefaultMutableTreeNode typeNode, SingleConfigurationConfigurable configurable) throws ConfigurationException {
        try {
            if (configurable != null) {
                configurable.apply();
            }
        }
        catch (ConfigurationException e) {
            for (int i = 0; i < typeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)typeNode.getChildAt(i);
                if (!Comparing.equal((Object)((Object)configurable), (Object)node.getUserObject())) continue;
                TreeUtil.selectNode((JTree)this.myTree, (TreeNode)node);
                break;
            }
            throw e;
        }
    }

    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        RunManagerImpl runManager = this.getRunManager();
        RunnerAndConfigurationSettingsImpl settings = runManager.getSelectedConfiguration();
        if (this.mySelectedConfigurable == null) {
            return settings != null;
        }
        if (settings == null || !Comparing.strEqual((String)this.mySelectedConfigurable.getConfiguration().getType().getId(), (String)settings.getType().getId()) || Comparing.strEqual((String)this.mySelectedConfigurable.getConfiguration().getType().getId(), (String)settings.getType().getId()) && !Comparing.strEqual((String)this.mySelectedConfigurable.getNameText(), (String)settings.getConfiguration().getName())) {
            return true;
        }
        RunConfiguration[] allConfigurations = runManager.getAllConfigurations();
        HashSet<Object> currentConfigurations = new HashSet<Object>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode typeNode = (DefaultMutableTreeNode)this.myRoot.getChildAt(i);
            RunnerAndConfigurationSettingsImpl[] configurationSettings = runManager.getConfigurationSettings((ConfigurationType)typeNode.getUserObject());
            if (configurationSettings.length != typeNode.getChildCount()) {
                return true;
            }
            for (int j = 0; j < typeNode.getChildCount(); ++j) {
                Object userObject = ((DefaultMutableTreeNode)typeNode.getChildAt(j)).getUserObject();
                if (userObject instanceof SingleConfigurationConfigurable) {
                    SingleConfigurationConfigurable configurable = (SingleConfigurationConfigurable)((Object)userObject);
                    if (!Comparing.strEqual((String)configurationSettings[j].getConfiguration().getName(), (String)configurable.getConfiguration().getName())) {
                        return true;
                    }
                    if (configurable.isModified()) {
                        return true;
                    }
                    currentConfigurations.add(configurable.getConfiguration());
                    continue;
                }
                if (!(userObject instanceof RunnerAndConfigurationSettingsImpl)) continue;
                currentConfigurations.add(((RunnerAndConfigurationSettingsImpl)userObject).getConfiguration());
            }
        }
        for (RunConfiguration configuration : allConfigurations) {
            if (currentConfigurations.contains(configuration)) continue;
            return true;
        }
        return false;
    }

    public void disposeUIResources() {
        TreeUtil.traverseDepth((TreeNode)this.myRoot, (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                DefaultMutableTreeNode treeNode;
                Object userObject;
                if (node instanceof DefaultMutableTreeNode && (userObject = (treeNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof SingleConfigurationConfigurable) {
                    ((SingleConfigurationConfigurable)((Object)userObject)).disposeUIResources();
                }
                return true;
            }
        });
        this.myRightPanel.removeAll();
        this.myConfig.setFloat(DIVIDER_PROPORTION, this.myPanel.getProportion());
        this.myPanel.dispose();
    }

    private void updateDialog() {
        if (this.myRunDialog == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        Executor executor = this.myRunDialog.getExecutor();
        buffer.append(executor.getId());
        SingleConfigurationConfigurable<RunConfiguration> configuration = this.getSelectedConfiguration();
        if (configuration != null) {
            buffer.append(" - ");
            buffer.append(configuration.getNameText());
        }
        this.myRunDialog.setOKActionEnabled(RunConfigurable.canRunConfiguration(configuration, executor));
        this.myRunDialog.setTitle(buffer.toString());
    }

    private void setupDialogBounds() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIUtil.setupEnclosingDialogBounds((JComponent)RunConfigurable.this.myWholePanel);
            }
        });
    }

    @Nullable
    private SingleConfigurationConfigurable<RunConfiguration> getSelectedConfiguration() {
        DefaultMutableTreeNode treeNode;
        Object userObject;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && (userObject = (treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject()) instanceof SingleConfigurationConfigurable) {
            return (SingleConfigurationConfigurable)((Object)userObject);
        }
        return null;
    }

    private static boolean canRunConfiguration(@Nullable SingleConfigurationConfigurable<RunConfiguration> configuration, @NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/impl/RunConfigurable.canRunConfiguration must not be null");
        }
        try {
            return configuration != null && RunManagerImpl.canRunConfiguration(configuration.getSnapshot(), executor);
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    private RunManagerImpl getRunManager() {
        return RunManagerImpl.getInstanceImpl(this.myProject);
    }

    public String getHelpTopic() {
        ConfigurationType type = this.getSelectedConfigurationType();
        if (type != null) {
            return "reference.dialogs.rundebug." + type.getId();
        }
        return "reference.dialogs.rundebug";
    }

    private void clickDefaultButton() {
        if (this.myRunDialog != null) {
            this.myRunDialog.clickDefaultButton();
        }
    }

    private DefaultMutableTreeNode getSelectedConfigurationTypeNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myTree.getSelectionPath().getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof ConfigurationType) {
            return node;
        }
        return (DefaultMutableTreeNode)node.getParent();
    }

    private static String createUniqueName(DefaultMutableTreeNode typeNode) {
        int i;
        String str = ExecutionBundle.message((String)"run.configuration.unnamed.name.prefix", (Object[])new Object[0]);
        ArrayList<String> currentNames = new ArrayList<String>();
        for (i = 0; i < typeNode.getChildCount(); ++i) {
            Object userObject = ((DefaultMutableTreeNode)typeNode.getChildAt(i)).getUserObject();
            if (userObject instanceof SingleConfigurationConfigurable) {
                currentNames.add(((SingleConfigurationConfigurable)((Object)userObject)).getNameText());
                continue;
            }
            if (!(userObject instanceof RunnerAndConfigurationSettingsImpl)) continue;
            currentNames.add(((RunnerAndConfigurationSettingsImpl)userObject).getName());
        }
        if (!currentNames.contains(str)) {
            return str;
        }
        i = 1;
        while (currentNames.contains(str + i)) {
            ++i;
        }
        return str + i;
    }

    private SingleConfigurationConfigurable<RunConfiguration> createNewConfiguration(RunnerAndConfigurationSettingsImpl settings, DefaultMutableTreeNode node) {
        SingleConfigurationConfigurable<RunConfiguration> configurationConfigurable = SingleConfigurationConfigurable.editSettings(settings);
        this.installUpdateListeners(configurationConfigurable);
        DefaultMutableTreeNode nodeToAdd = new DefaultMutableTreeNode(configurationConfigurable);
        node.add(nodeToAdd);
        ((DefaultTreeModel)this.myTree.getModel()).reload(node);
        TreeUtil.selectNode((JTree)this.myTree, (TreeNode)nodeToAdd);
        return configurationConfigurable;
    }

    private void createNewConfiguration(ConfigurationFactory factory) {
        DefaultMutableTreeNode node = null;
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.myRoot.getChildAt(i);
            if (treeNode.getUserObject() != factory.getType()) continue;
            node = treeNode;
            break;
        }
        if (node == null) {
            node = new DefaultMutableTreeNode(factory.getType());
            this.myRoot.add(node);
            RunConfigurable.sortTree(this.myRoot);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }
        RunnerAndConfigurationSettingsImpl settings = this.getRunManager().createConfiguration(RunConfigurable.createUniqueName(node), factory);
        this.createNewConfiguration(settings, node);
    }

    private static class RunConfigurationBean {
        private final RunnerAndConfigurationSettingsImpl mySettings;
        private final boolean myShared;
        private final Map<Key<? extends BeforeRunTask>, BeforeRunTask> myStepsBeforeLaunch;
        private final SingleConfigurationConfigurable myConfigurable;

        public RunConfigurationBean(RunnerAndConfigurationSettingsImpl settings, boolean shared, Map<Key<? extends BeforeRunTask>, BeforeRunTask> stepsBeforeLaunch) {
            this.mySettings = settings;
            this.myShared = shared;
            this.myStepsBeforeLaunch = Collections.unmodifiableMap(stepsBeforeLaunch);
            this.myConfigurable = null;
        }

        public RunConfigurationBean(SingleConfigurationConfigurable configurable) {
            this.myConfigurable = configurable;
            this.mySettings = (RunnerAndConfigurationSettingsImpl)this.myConfigurable.getSettings();
            ConfigurationSettingsEditorWrapper editorWrapper = (ConfigurationSettingsEditorWrapper)this.myConfigurable.getEditor();
            this.myShared = editorWrapper.isStoreProjectConfiguration();
            this.myStepsBeforeLaunch = editorWrapper.getStepsBeforeLaunch();
        }

        public RunnerAndConfigurationSettingsImpl getSettings() {
            return this.mySettings;
        }

        public boolean isShared() {
            return this.myShared;
        }

        public Map<Key<? extends BeforeRunTask>, BeforeRunTask> getStepsBeforeLaunch() {
            return this.myStepsBeforeLaunch;
        }

        public SingleConfigurationConfigurable getConfigurable() {
            return this.myConfigurable;
        }
    }

    private class MyMoveAction
    extends AnAction {
        private final int myDirection;

        protected MyMoveAction(String text, String description, Icon icon, int direction) {
            super(text, description, icon);
            this.myDirection = direction;
        }

        public void actionPerformed(AnActionEvent e) {
            TreeUtil.moveSelectedRow((JTree)RunConfigurable.this.myTree, (int)this.myDirection);
        }

        public void update(AnActionEvent e) {
            DefaultMutableTreeNode treeNode;
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            TreePath selectionPath = RunConfigurable.this.myTree.getSelectionPath();
            if (selectionPath != null && (treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject() instanceof SingleConfigurationConfigurable) {
                if (this.myDirection < 0) {
                    presentation.setEnabled(treeNode.getPreviousSibling() != null);
                } else {
                    presentation.setEnabled(treeNode.getNextSibling() != null);
                }
            }
        }
    }

    private class MySaveAction
    extends AnAction {
        public MySaveAction() {
            super(ExecutionBundle.message((String)"action.name.save.configuration", (Object[])new Object[0]), null, SAVE_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            SingleConfigurationConfigurable configurationConfigurable = RunConfigurable.this.getSelectedConfiguration();
            LOG.assertTrue(configurationConfigurable != null);
            try {
                configurationConfigurable.apply();
            }
            catch (ConfigurationException e1) {
                // empty catch block
            }
            RunnerAndConfigurationSettingsImpl originalConfiguration = (RunnerAndConfigurationSettingsImpl)configurationConfigurable.getSettings();
            if (RunConfigurable.this.getRunManager().isTemporary(originalConfiguration)) {
                RunConfigurable.this.getRunManager().makeStable(originalConfiguration.getConfiguration());
            }
            RunConfigurable.this.myTree.repaint();
        }

        public void update(AnActionEvent e) {
            SingleConfigurationConfigurable configuration = RunConfigurable.this.getSelectedConfiguration();
            Presentation presentation = e.getPresentation();
            boolean enabled = configuration != null && RunConfigurable.this.getRunManager().isTemporary((RunnerAndConfigurationSettingsImpl)configuration.getSettings());
            presentation.setEnabled(enabled);
            presentation.setVisible(enabled);
        }
    }

    private class MyCopyAction
    extends AnAction {
        public MyCopyAction() {
            super(ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), COPY_ICON);
            AnAction action = ActionManager.getInstance().getAction("EditorDuplicate");
            this.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)RunConfigurable.this.myTree);
        }

        public void actionPerformed(AnActionEvent e) {
            SingleConfigurationConfigurable configuration = RunConfigurable.this.getSelectedConfiguration();
            LOG.assertTrue(configuration != null);
            try {
                DefaultMutableTreeNode typeNode = RunConfigurable.this.getSelectedConfigurationTypeNode();
                RunnerAndConfigurationSettingsImpl settings = configuration.getSnapshot();
                String copyName = RunConfigurable.createUniqueName(typeNode);
                settings.setName(copyName);
                SingleConfigurationConfigurable configurable = RunConfigurable.this.createNewConfiguration(settings, typeNode);
                IdeFocusManager.getInstance((Project)RunConfigurable.this.myProject).requestFocus((Component)configurable.getNameTextField(), true);
                configurable.getNameTextField().setSelectionStart(0);
                configurable.getNameTextField().setSelectionEnd(copyName.length());
            }
            catch (ConfigurationException e1) {
                Messages.showErrorDialog((Component)RunConfigurable.this.myToolbarComponent, (String)e1.getMessage(), (String)e1.getTitle());
            }
        }

        public void update(AnActionEvent e) {
            SingleConfigurationConfigurable configuration = RunConfigurable.this.getSelectedConfiguration();
            e.getPresentation().setEnabled(configuration != null && !(configuration.getConfiguration() instanceof UnknownRunConfiguration));
        }
    }

    private class MyRemoveAction
    extends AnAction {
        public MyRemoveAction() {
            super(ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0]), REMOVE_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)RunConfigurable.this.myTree);
        }

        public void actionPerformed(AnActionEvent e) {
            TreePath[] selections = RunConfigurable.this.myTree.getSelectionPaths();
            RunConfigurable.this.myTree.clearSelection();
            int nodeIndexToSelect = -1;
            DefaultMutableTreeNode parentToSelect = null;
            HashSet<DefaultMutableTreeNode> changedParents = new HashSet<DefaultMutableTreeNode>();
            boolean wasRootChanged = false;
            for (TreePath each : selections) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)each.getLastPathComponent();
                if (node.getUserObject() instanceof ConfigurationType) continue;
                if (node.getUserObject() instanceof SingleConfigurationConfigurable) {
                    ((SingleConfigurationConfigurable)((Object)node.getUserObject())).disposeUIResources();
                }
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                nodeIndexToSelect = parent.getIndex(node);
                parentToSelect = parent;
                parent.remove(node);
                changedParents.add(parent);
                if (parent.getChildCount() != 0) continue;
                changedParents.remove(parent);
                wasRootChanged = true;
                nodeIndexToSelect = RunConfigurable.this.myRoot.getIndex(parent);
                parentToSelect = RunConfigurable.this.myRoot;
                RunConfigurable.this.myRoot.remove(parent);
            }
            if (wasRootChanged) {
                ((DefaultTreeModel)RunConfigurable.this.myTree.getModel()).reload();
            } else {
                for (DefaultMutableTreeNode each : changedParents) {
                    ((DefaultTreeModel)RunConfigurable.this.myTree.getModel()).reload(each);
                    RunConfigurable.this.myTree.expandPath(new TreePath(each));
                }
            }
            RunConfigurable.this.mySelectedConfigurable = null;
            if (RunConfigurable.this.myRoot.getChildCount() == 0) {
                RunConfigurable.this.drawPressAddButtonMessage(null);
            } else {
                TreeNode nodeToSelect = nodeIndexToSelect < parentToSelect.getChildCount() ? parentToSelect.getChildAt(nodeIndexToSelect) : parentToSelect.getChildAt(nodeIndexToSelect - 1);
                TreeUtil.selectInTree((DefaultMutableTreeNode)((DefaultMutableTreeNode)nodeToSelect), (boolean)true, (JTree)RunConfigurable.this.myTree);
            }
        }

        public void update(AnActionEvent e) {
            boolean enabled = false;
            TreePath[] selections = RunConfigurable.this.myTree.getSelectionPaths();
            if (selections != null) {
                for (TreePath each : selections) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)each.getLastPathComponent();
                    if (node.getUserObject() instanceof ConfigurationType) continue;
                    enabled = true;
                    break;
                }
            }
            e.getPresentation().setEnabled(enabled);
        }
    }

    private class MyToolbarAddAction
    extends AnAction {
        public MyToolbarAddAction() {
            super(ExecutionBundle.message((String)"add.new.run.configuration.acrtion.name", (Object[])new Object[0]), ExecutionBundle.message((String)"add.new.run.configuration.acrtion.name", (Object[])new Object[0]), ADD_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)RunConfigurable.this.myTree);
        }

        public void actionPerformed(AnActionEvent e) {
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            final ConfigurationType[] configurationTypes = RunConfigurable.this.getRunManager().getConfigurationFactories(false);
            Arrays.sort(configurationTypes, new Comparator<ConfigurationType>(){

                @Override
                public int compare(ConfigurationType type1, ConfigurationType type2) {
                    return type1.getDisplayName().compareTo(type2.getDisplayName());
                }
            });
            ListPopup popup = popupFactory.createWizardStep((PopupStep)new BaseListPopupStep<ConfigurationType>(ExecutionBundle.message((String)"add.new.run.configuration.acrtion.name", (Object[])new Object[0]), configurationTypes){

                @NotNull
                public String getTextFor(ConfigurationType type) {
                    String string = type.getDisplayName();
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/execution/impl/RunConfigurable$MyToolbarAddAction$2.getTextFor must not return null");
                    }
                    return string;
                }

                public Icon getIconFor(ConfigurationType type) {
                    return type.getIcon();
                }

                public PopupStep onChosen(ConfigurationType type, boolean finalChoice) {
                    if (this.hasSubstep(type)) {
                        return this.getSupStep(type);
                    }
                    ConfigurationFactory[] factories = type.getConfigurationFactories();
                    if (factories.length > 0) {
                        RunConfigurable.this.createNewConfiguration(factories[0]);
                    }
                    return PopupStep.FINAL_CHOICE;
                }

                public int getDefaultOptionIndex() {
                    TreePath selectionPath = RunConfigurable.this.myTree.getSelectionPath();
                    if (selectionPath != null) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                        Object userObject = node.getUserObject();
                        ConfigurationType type = null;
                        if (userObject instanceof SingleConfigurationConfigurable) {
                            SingleConfigurationConfigurable configurable = (SingleConfigurationConfigurable)((Object)userObject);
                            type = configurable.getConfiguration().getType();
                        } else if (userObject instanceof ConfigurationType) {
                            type = (ConfigurationType)userObject;
                        }
                        return ArrayUtil.find((Object[])configurationTypes, (Object)type);
                    }
                    return super.getDefaultOptionIndex();
                }

                private ListPopupStep getSupStep(ConfigurationType type) {
                    ConfigurationFactory[] factories = type.getConfigurationFactories();
                    Arrays.sort(factories, new Comparator<ConfigurationFactory>(){

                        @Override
                        public int compare(ConfigurationFactory factory1, ConfigurationFactory factory2) {
                            return factory1.getName().compareTo(factory2.getName());
                        }
                    });
                    return new BaseListPopupStep<ConfigurationFactory>(ExecutionBundle.message((String)"add.new.run.configuration.action.name", (Object[])new Object[]{type.getDisplayName()}), factories){

                        @NotNull
                        public String getTextFor(ConfigurationFactory value) {
                            String string = value.getName();
                            if (string == null) {
                                throw new IllegalStateException("@NotNull method com/intellij/execution/impl/RunConfigurable$MyToolbarAddAction$2$2.getTextFor must not return null");
                            }
                            return string;
                        }

                        public Icon getIconFor(ConfigurationFactory factory) {
                            return factory.getIcon();
                        }

                        public PopupStep onChosen(ConfigurationFactory factory, boolean finalChoice) {
                            RunConfigurable.this.createNewConfiguration(factory);
                            return PopupStep.FINAL_CHOICE;
                        }
                    };
                }

                public boolean hasSubstep(ConfigurationType type) {
                    return type.getConfigurationFactories().length > 1;
                }
            });
            popup.showUnderneathOf((Component)RunConfigurable.this.myToolbarComponent);
        }
    }
}

