/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.LocatableConfigurationType;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public abstract class RuntimeConfigurationProducer
implements Comparable {
    public static final ExtensionPointName<RuntimeConfigurationProducer> RUNTIME_CONFIGURATION_PRODUCER = ExtensionPointName.create((String)"com.intellij.configurationProducer");
    public static final Comparator<RuntimeConfigurationProducer> COMPARATOR = new ProducerComparator();
    protected static final int PREFERED = -1;
    private final ConfigurationFactory myConfigurationFactory;
    private RunnerAndConfigurationSettingsImpl myConfiguration;

    public RuntimeConfigurationProducer(ConfigurationType configurationType) {
        this(configurationType.getConfigurationFactories()[0]);
    }

    protected RuntimeConfigurationProducer(ConfigurationFactory configurationFactory) {
        this.myConfigurationFactory = configurationFactory;
    }

    public RuntimeConfigurationProducer createProducer(Location location, ConfigurationContext context) {
        ConfigurationType type;
        PsiElement psiElement;
        Location _location;
        RuntimeConfigurationProducer result = this.clone();
        RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = result.myConfiguration = location != null ? result.createConfigurationByElement(location, context) : null;
        if (result.myConfiguration != null && (_location = PsiLocation.fromPsiElement((PsiElement)(psiElement = result.getSourceElement()), (Module)(location != null ? location.getModule() : null))) != null && (type = result.myConfiguration.getType()) instanceof LocatableConfigurationType) {
            RunnerAndConfigurationSettingsImpl[] configurations;
            RunManagerEx runManager = RunManagerEx.getInstanceEx(context.getProject());
            for (RunnerAndConfigurationSettingsImpl configuration : configurations = runManager.getConfigurationSettings(type)) {
                if (!((LocatableConfigurationType)type).isConfigurationByLocation(configuration.getConfiguration(), _location)) continue;
                result.myConfiguration = configuration;
                break;
            }
        }
        return result;
    }

    public abstract PsiElement getSourceElement();

    public RunnerAndConfigurationSettingsImpl getConfiguration() {
        return this.myConfiguration;
    }

    @Nullable
    protected abstract RunnerAndConfigurationSettingsImpl createConfigurationByElement(Location var1, ConfigurationContext var2);

    public RuntimeConfigurationProducer clone() {
        try {
            return (RuntimeConfigurationProducer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected RunnerAndConfigurationSettingsImpl cloneTemplateConfiguration(Project project, ConfigurationContext context) {
        RuntimeConfiguration original;
        if (context != null && (original = context.getOriginalConfiguration(this.myConfigurationFactory.getType())) != null) {
            return RunManagerEx.getInstanceEx(project).createConfiguration((RunConfiguration)original.clone(), this.myConfigurationFactory);
        }
        return RunManagerEx.getInstanceEx(project).createConfiguration("", this.myConfigurationFactory);
    }

    protected void copyStepsBeforeRun(Project project, RunConfiguration runConfiguration) {
        RunManagerImpl manager = RunManagerImpl.getInstanceImpl(project);
        RunnerAndConfigurationSettingsImpl template = manager.getConfigurationTemplate(this.myConfigurationFactory);
    }

    protected ConfigurationFactory getConfigurationFactory() {
        return this.myConfigurationFactory;
    }

    public ConfigurationType getConfigurationType() {
        return this.myConfigurationFactory.getType();
    }

    public static RuntimeConfigurationProducer getInstance(Class aClass) {
        RuntimeConfigurationProducer[] configurationProducers;
        for (RuntimeConfigurationProducer configurationProducer : configurationProducers = (RuntimeConfigurationProducer[])Extensions.getExtensions(RUNTIME_CONFIGURATION_PRODUCER)) {
            if (configurationProducer.getClass() != aClass) continue;
            return configurationProducer;
        }
        return null;
    }

    private static class ProducerComparator
    implements Comparator<RuntimeConfigurationProducer> {
        private ProducerComparator() {
        }

        @Override
        public int compare(RuntimeConfigurationProducer producer1, RuntimeConfigurationProducer producer2) {
            PsiElement psiElement2;
            PsiElement psiElement1 = producer1.getSourceElement();
            if (ProducerComparator.doesContains(psiElement1, psiElement2 = producer2.getSourceElement())) {
                return 1;
            }
            if (ProducerComparator.doesContains(psiElement2, psiElement1)) {
                return -1;
            }
            return producer1.compareTo(producer2);
        }

        private static boolean doesContains(PsiElement container, PsiElement element) {
            while ((element = element.getParent()) != null) {
                if (!container.equals(element)) continue;
                return true;
            }
            return false;
        }
    }
}

