/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogConsoleImpl;
import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.diagnostic.logging.LogFilesManager;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RestartAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RunContentBuilder
implements LogConsoleManager,
Disposable {
    private static final Icon DEFAULT_RERUN_ICON = IconLoader.getIcon((String)"/actions/refreshUsages.png");
    @NonNls
    private static final String JAVA_RUNNER = "JavaRunner";
    private final ProgramRunner myRunner;
    private final Project myProject;
    private final ArrayList<Disposable> myDisposeables = new ArrayList();
    private final ArrayList<AnAction> myRunnerActions = new ArrayList();
    private final Icon myRerunIcon = DEFAULT_RERUN_ICON;
    private final boolean myReuseProhibited = false;
    private ExecutionResult myExecutionResult;
    private final LogFilesManager myManager;
    private RunnerLayoutUi myUi;
    private final Map<AdditionalTabComponent, Content> myAdditionalContent = new HashMap<AdditionalTabComponent, Content>();
    private final Executor myExecutor;
    private ExecutionEnvironment myEnvironment;

    public RunContentBuilder(Project project, ProgramRunner runner, Executor executor) {
        this.myProject = project;
        this.myRunner = runner;
        this.myExecutor = executor;
        this.myManager = new LogFilesManager(project, this, this);
    }

    public ExecutionResult getExecutionResult() {
        return this.myExecutionResult;
    }

    public void setExecutionResult(ExecutionResult executionResult) {
        this.myExecutionResult = executionResult;
    }

    public void setEnvironment(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/runners/RunContentBuilder.setEnvironment must not be null");
        }
        this.myEnvironment = env;
        RunProfile profile = env.getRunProfile();
        if (profile instanceof RunConfigurationBase) {
            this.myManager.registerFileMatcher((RunConfigurationBase)profile);
        }
    }

    public void addAction(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/runners/RunContentBuilder.addAction must not be null");
        }
        this.myRunnerActions.add(action);
    }

    public void dispose() {
        for (Disposable disposable : this.myDisposeables) {
            disposable.dispose();
        }
    }

    private RunContentDescriptor createDescriptor() {
        if (this.myExecutionResult == null) {
            throw new IllegalStateException("Missing ExecutionResult");
        }
        if (this.myEnvironment == null) {
            throw new IllegalStateException("Missing ExecutionEnvironment");
        }
        RunProfile profile = this.myEnvironment.getRunProfile();
        ExecutionConsole console = this.myExecutionResult.getExecutionConsole();
        String runnerType = console instanceof ExecutionConsoleEx ? "JavaRunner." + ((ExecutionConsoleEx)console).getExecutionConsoleId() : JAVA_RUNNER;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)this.myProject).create(runnerType, this.myExecutor.getId(), profile.getName(), (Disposable)this);
        this.myUi.getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new MyRunContentDescriptor(profile, this.myExecutionResult, false, this.myUi.getComponent(), this);
        }
        if (console != null) {
            if (console instanceof ExecutionConsoleEx) {
                ((ExecutionConsoleEx)console).buildUi(this.myUi);
            } else {
                this.buildConsoleUiDefault(console);
            }
            if (profile instanceof RunConfigurationBase) {
                this.myManager.initLogConsoles((RunConfigurationBase)profile, this.myExecutionResult.getProcessHandler());
            }
        }
        MyRunContentDescriptor contentDescriptor = new MyRunContentDescriptor(profile, this.myExecutionResult, false, this.myUi.getComponent(), this);
        this.myUi.getOptions().setLeftToolbar(this.createActionToolbar(contentDescriptor, this.myUi.getComponent()), "unknown");
        return contentDescriptor;
    }

    private void buildConsoleUiDefault(ExecutionConsole console) {
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        if (console instanceof ConsoleView) {
            AnAction[] actions;
            for (AnAction goaction : actions = ((ConsoleView)console).createConsoleActions()) {
                consoleActions.add(goaction);
            }
        }
        Content consoleContent = this.myUi.createContent("Console", console.getComponent(), "Console", IconLoader.getIcon((String)"/debugger/console.png"), console.getPreferredFocusableComponent());
        consoleContent.setActions((ActionGroup)consoleActions, "unknown", console.getComponent());
        this.myUi.addContent(consoleContent, 0, PlaceInGrid.bottom, false);
    }

    @Override
    public void addLogConsole(String name, final String path, long skippedContent) {
        final LogConsoleImpl log = new LogConsoleImpl(this.myProject, new File(path), skippedContent, name, false){

            @Override
            public boolean isActive() {
                Content content = RunContentBuilder.this.myUi.findContent(path);
                return content != null && content.isSelected();
            }
        };
        if (this.myEnvironment.getRunProfile() instanceof RunConfigurationBase) {
            ((RunConfigurationBase)this.myEnvironment.getRunProfile()).customizeLogConsole((LogConsole)log);
        }
        log.attachStopLogConsoleTrackingListener(this.myExecutionResult.getProcessHandler());
        this.addAdditionalTabComponent(log, path);
        this.myUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                log.stateChanged(new ChangeEvent(RunContentBuilder.this.myUi));
            }
        }, (Disposable)log);
    }

    @Override
    public void removeLogConsole(String path) {
        Content content = this.myUi.findContent(path);
        if (content != null) {
            LogConsoleImpl log = (LogConsoleImpl)((Object)content.getComponent());
            this.removeAdditionalTabComponent(log);
        }
    }

    private ActionGroup createActionToolbar(RunContentDescriptor contentDescriptor, JComponent component) {
        AnAction[] actions;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        final RestartAction restartAction = new RestartAction(this.myExecutor, this.myRunner, this.getProcessHandler(), this.myRerunIcon, contentDescriptor, this.myEnvironment);
        restartAction.registerShortcut(component);
        actionGroup.add((AnAction)restartAction);
        contentDescriptor.setRestarter(new Runnable(){

            @Override
            public void run() {
                restartAction.restart();
            }
        });
        if (this.myExecutionResult instanceof DefaultExecutionResult && (actions = ((DefaultExecutionResult)this.myExecutionResult).getRestartActions()) != null) {
            actionGroup.addAll(actions);
            if (actions.length > 0) {
                actionGroup.addSeparator();
            }
        }
        AnAction stopAction = ActionManager.getInstance().getAction("Stop");
        actionGroup.add(stopAction);
        if (this.myExecutionResult instanceof DefaultExecutionResult) {
            actionGroup.addAll(((DefaultExecutionResult)this.myExecutionResult).getAdditionalStopActions());
        }
        actionGroup.addAll(this.myExecutionResult.getActions());
        for (AnAction anAction : this.myRunnerActions) {
            if (anAction != null) {
                actionGroup.add(anAction);
                continue;
            }
            actionGroup.addSeparator();
        }
        actionGroup.addSeparator();
        actionGroup.add(this.myUi.getOptions().getLayoutActions());
        actionGroup.addSeparator();
        actionGroup.add(PinToolwindowTabAction.getPinAction());
        actionGroup.add((AnAction)new CloseAction(this.myExecutor, contentDescriptor, this.myProject));
        actionGroup.add((AnAction)new ContextHelpAction(this.myExecutor.getHelpId()));
        return actionGroup;
    }

    public ProcessHandler getProcessHandler() {
        return this.myExecutionResult.getProcessHandler();
    }

    public RunContentDescriptor showRunContent(RunContentDescriptor reuseContent) {
        RunContentDescriptor descriptor = this.createDescriptor();
        if (reuseContent != null) {
            descriptor.setAttachedContent(reuseContent.getAttachedContent());
        }
        return descriptor;
    }

    public void addAdditionalTabComponent(final AdditionalTabComponent tabComponent, String id) {
        Content content = this.myUi.createContent(id, (ComponentWithActions)tabComponent, tabComponent.getTabTitle(), IconLoader.getIcon((String)"/debugger/console.png"), tabComponent.getPreferredFocusableComponent());
        this.myUi.addContent(content);
        this.myAdditionalContent.put(tabComponent, content);
        this.myDisposeables.add(new Disposable(){

            public void dispose() {
                if (!RunContentBuilder.this.myUi.isDisposed()) {
                    RunContentBuilder.this.removeAdditionalTabComponent(tabComponent);
                }
            }
        });
    }

    public void removeAdditionalTabComponent(AdditionalTabComponent component) {
        Disposer.dispose((Disposable)component);
        this.myDisposeables.remove(component);
        Content content = this.myAdditionalContent.remove(component);
        this.myUi.removeContent(content, true);
    }

    private static class MyRunContentDescriptor
    extends RunContentDescriptor {
        private final boolean myReuseProhibited;
        private final Disposable myAdditionalDisposable;

        public MyRunContentDescriptor(RunProfile profile, ExecutionResult executionResult, boolean reuseProhibited, JComponent component, @NotNull Disposable additionalDisposable) {
            if (additionalDisposable == null) {
                throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/execution/runners/RunContentBuilder$MyRunContentDescriptor.<init> must not be null");
            }
            super(executionResult.getExecutionConsole(), executionResult.getProcessHandler(), component, profile.getName(), profile.getIcon());
            this.myReuseProhibited = reuseProhibited;
            this.myAdditionalDisposable = additionalDisposable;
        }

        public boolean isContentReuseProhibited() {
            return this.myReuseProhibited;
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myAdditionalDisposable);
            super.dispose();
        }
    }
}

