/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class FacetTypeRegistryImpl
extends FacetTypeRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.FacetTypeRegistryImpl");
    private final Map<String, FacetTypeId> myTypeIds = new HashMap<String, FacetTypeId>();
    private final Map<FacetTypeId, FacetType> myFacetTypes = new HashMap<FacetTypeId, FacetType>();
    private boolean myExtensionsLoaded = false;

    public synchronized void registerFacetType(FacetType facetType) {
        FacetTypeId typeId = facetType.getId();
        String id = facetType.getStringId();
        LOG.assertTrue(!id.contains("/"), (Object)("Facet type id '" + id + "' contains illegal character '/'"));
        LOG.assertTrue(!this.myFacetTypes.containsKey(typeId), (Object)("Facet type '" + id + "' is already registered"));
        this.myFacetTypes.put(typeId, facetType);
        LOG.assertTrue(!this.myTypeIds.containsKey(id), (Object)("Facet type id '" + id + "' is already registered"));
        this.myTypeIds.put(id, typeId);
    }

    public synchronized void unregisterFacetType(FacetType facetType) {
        FacetTypeId id = facetType.getId();
        String stringId = facetType.getStringId();
        LOG.assertTrue(this.myFacetTypes.remove(id) != null, (Object)("Facet type '" + stringId + "' is not registered"));
        this.myFacetTypes.remove(id);
        this.myTypeIds.remove(stringId);
    }

    public synchronized FacetTypeId[] getFacetTypeIds() {
        this.loadExtensions();
        Set<FacetTypeId> ids = this.myFacetTypes.keySet();
        return ids.toArray(new FacetTypeId[ids.size()]);
    }

    public synchronized FacetType[] getFacetTypes() {
        this.loadExtensions();
        Collection<FacetType> types = this.myFacetTypes.values();
        return types.toArray(new FacetType[types.size()]);
    }

    @Nullable
    public synchronized FacetType findFacetType(String id) {
        this.loadExtensions();
        FacetTypeId typeId = this.myTypeIds.get(id);
        return typeId == null ? null : this.myFacetTypes.get(typeId);
    }

    @Nullable
    public synchronized <F extends Facet<C>, C extends FacetConfiguration> FacetType<F, C> findFacetType(FacetTypeId<F> typeId) {
        this.loadExtensions();
        return this.myFacetTypes.get(typeId);
    }

    private void loadExtensions() {
        if (!this.myExtensionsLoaded) {
            this.myExtensionsLoaded = true;
            ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(FacetType.EP_NAME);
            extensionPoint.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FacetType>(){

                public void extensionAdded(FacetType extension, @Nullable PluginDescriptor pluginDescriptor) {
                    FacetTypeRegistryImpl.this.registerFacetType(extension);
                }

                public void extensionRemoved(FacetType extension, @Nullable PluginDescriptor pluginDescriptor) {
                    FacetTypeRegistryImpl.this.unregisterFacetType(extension);
                }
            });
        }
    }
}

