/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.MultipleFacetEditorHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class MultipleFacetEditorHelperImpl
implements MultipleFacetEditorHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.ui.MultipleFacetSettingsEditor");
    private final List<AbstactBinding> myBindings = new ArrayList<AbstactBinding>();

    public void bind(@NotNull ThreeStateCheckBox common, @NotNull FacetEditor[] editors, @NotNull NotNullFunction<FacetEditor, JCheckBox> fun) {
        if (common == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl.bind must not be null");
        }
        if (editors == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl.bind must not be null");
        }
        if (fun == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl.bind must not be null");
        }
        ArrayList<JCheckBox> checkBoxesList = new ArrayList<JCheckBox>();
        for (FacetEditor editor : editors) {
            checkBoxesList.add((JCheckBox)fun.fun((Object)editor));
        }
        CheckBoxBinding checkBoxBinding = new CheckBoxBinding(common, checkBoxesList);
        this.myBindings.add(checkBoxBinding);
    }

    public void bind(@NotNull JTextField common, @NotNull FacetEditor[] editors, @NotNull NotNullFunction<FacetEditor, JTextField> fun) {
        if (common == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl.bind must not be null");
        }
        if (editors == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl.bind must not be null");
        }
        if (fun == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl.bind must not be null");
        }
        ArrayList<Object> componentsList = new ArrayList<Object>();
        for (FacetEditor editor : editors) {
            componentsList.add(fun.fun((Object)editor));
        }
        TextFieldBinding binding = new TextFieldBinding(common, componentsList);
        this.myBindings.add(binding);
    }

    public void bind(@NotNull JComboBox common, @NotNull FacetEditor[] editors, @NotNull NotNullFunction<FacetEditor, JComboBox> fun) {
        if (common == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl.bind must not be null");
        }
        if (editors == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl.bind must not be null");
        }
        if (fun == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl.bind must not be null");
        }
        ArrayList<JComboBox> componentsList = new ArrayList<JComboBox>();
        for (FacetEditor editor : editors) {
            componentsList.add((JComboBox)fun.fun((Object)editor));
        }
        CombobBoxBinding binding = new CombobBoxBinding(common, componentsList);
        this.myBindings.add(binding);
    }

    public void unbind() {
        for (AbstactBinding binding : this.myBindings) {
            binding.unbind();
        }
        this.myBindings.clear();
    }

    private static class CombobBoxBinding
    extends AbstactBinding
    implements ItemListener {
        private final JComboBox myCommon;
        private final List<JComboBox> myComponentsList;
        private final List<Object> myInitialValues;

        public CombobBoxBinding(JComboBox common, List<JComboBox> componentsList) {
            LOG.assertTrue(!componentsList.isEmpty());
            this.myCommon = common;
            this.myComponentsList = componentsList;
            JComboBox first = componentsList.get(0);
            Object initialValue = first.getSelectedItem();
            this.myInitialValues = new ArrayList<Object>();
            for (JComboBox component : componentsList) {
                Object item = component.getSelectedItem();
                this.myInitialValues.add(item);
                if (initialValue == null || initialValue.equals(item)) continue;
                initialValue = null;
            }
            common.setSelectedItem(initialValue);
            common.addItemListener(this);
        }

        @Override
        public void unbind() {
            this.myCommon.removeItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object item = this.myCommon.getSelectedItem();
            for (int i = 0; i < this.myComponentsList.size(); ++i) {
                this.myComponentsList.get(i).setSelectedItem(item != null ? item : this.myInitialValues.get(i));
            }
        }
    }

    private static class TextFieldBinding
    extends AbstactBinding {
        private final JTextField myCommon;
        private final List<JTextField> myTextFields;
        private final List<String> myInitialValues;
        private final DocumentAdapter myListener;

        private TextFieldBinding(JTextField common, List<JTextField> textFields) {
            LOG.assertTrue(!textFields.isEmpty());
            this.myCommon = common;
            this.myTextFields = textFields;
            String initialValue = this.myTextFields.get(0).getText();
            this.myInitialValues = new ArrayList<String>();
            for (JTextField field : this.myTextFields) {
                String value = field.getText();
                this.myInitialValues.add(value);
                if (initialValue == null || initialValue.equals(value)) continue;
                initialValue = null;
            }
            common.setText(initialValue != null ? initialValue : "");
            this.myListener = new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    TextFieldBinding.this.textChanged();
                }
            };
            this.myCommon.getDocument().addDocumentListener((DocumentListener)this.myListener);
        }

        protected void textChanged() {
            String value = this.myCommon.getText();
            for (int i = 0; i < this.myTextFields.size(); ++i) {
                this.myTextFields.get(i).setText(value.length() == 0 ? this.myInitialValues.get(i) : value);
            }
        }

        @Override
        public void unbind() {
            this.myCommon.getDocument().removeDocumentListener((DocumentListener)this.myListener);
        }
    }

    private static class CheckBoxBinding
    extends AbstactBinding
    implements ActionListener {
        private final ThreeStateCheckBox myCommon;
        private final List<JCheckBox> myCheckBoxesList;
        private final List<Boolean> myInitialValues;

        public CheckBoxBinding(ThreeStateCheckBox common, List<JCheckBox> checkBoxesList) {
            LOG.assertTrue(!checkBoxesList.isEmpty());
            this.myCommon = common;
            this.myCheckBoxesList = checkBoxesList;
            Boolean initialValue = checkBoxesList.get(0).isSelected();
            this.myInitialValues = new ArrayList<Boolean>();
            for (JCheckBox checkBox : checkBoxesList) {
                boolean value = checkBox.isSelected();
                this.myInitialValues.add(value);
                if (initialValue == null || value == initialValue) continue;
                initialValue = null;
            }
            if (initialValue != null) {
                common.setThirdStateEnabled(false);
                common.setSelected(initialValue.booleanValue());
            } else {
                common.setThirdStateEnabled(true);
                common.setState(ThreeStateCheckBox.State.DONT_CARE);
            }
            this.myCommon.addActionListener((ActionListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThreeStateCheckBox.State state = this.myCommon.getState();
            for (int i = 0; i < this.myCheckBoxesList.size(); ++i) {
                JCheckBox checkBox;
                boolean value = state == ThreeStateCheckBox.State.SELECTED ? true : (state == ThreeStateCheckBox.State.NOT_SELECTED ? false : this.myInitialValues.get(i));
                if (value == (checkBox = this.myCheckBoxesList.get(i)).isSelected()) continue;
                ButtonModel model = checkBox.getModel();
                model.setArmed(true);
                model.setPressed(true);
                model.setPressed(false);
                model.setArmed(false);
            }
        }

        @Override
        public void unbind() {
            this.myCommon.removeActionListener((ActionListener)this);
        }
    }

    private static abstract class AbstactBinding {
        private AbstactBinding() {
        }

        public abstract void unbind();
    }
}

