/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.BlockUtil;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageBlock
extends AbstractBlock
implements BlockWithParent {
    private final TemplateLanguageBlockFactory myBlockFactory;
    protected final CodeStyleSettings mySettings;
    private List<DataLanguageBlockWrapper> myForeignChildren;
    private boolean myChildrenBuilt;
    private BlockWithParent myParent;

    protected TemplateLanguageBlock(@NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings settings, @NotNull ASTNode node, @Nullable List<DataLanguageBlockWrapper> foreignChildren) {
        if (blockFactory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/formatting/templateLanguages/TemplateLanguageBlock.<init> must not be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/formatting/templateLanguages/TemplateLanguageBlock.<init> must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/formatting/templateLanguages/TemplateLanguageBlock.<init> must not be null");
        }
        this(node, null, null, blockFactory, settings, foreignChildren);
    }

    protected TemplateLanguageBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings settings, @Nullable List<DataLanguageBlockWrapper> foreignChildren) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/formatting/templateLanguages/TemplateLanguageBlock.<init> must not be null");
        }
        if (blockFactory == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/formatting/templateLanguages/TemplateLanguageBlock.<init> must not be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/formatting/templateLanguages/TemplateLanguageBlock.<init> must not be null");
        }
        super(node, wrap, alignment);
        this.myChildrenBuilt = false;
        this.myBlockFactory = blockFactory;
        this.myForeignChildren = foreignChildren;
        this.mySettings = settings;
    }

    @Override
    protected List<Block> buildChildren() {
        this.myChildrenBuilt = true;
        if (this.isLeaf()) {
            return EMPTY;
        }
        ArrayList<TemplateLanguageBlock> tlChildren = new ArrayList<TemplateLanguageBlock>(5);
        for (ASTNode childNode = this.getNode().getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly(childNode) || !this.shouldBuildBlockFor(childNode)) continue;
            TemplateLanguageBlock childBlock = this.myBlockFactory.createTemplateLanguageBlock(childNode, this.createChildWrap(childNode), this.createChildAlignment(childNode), null, this.mySettings);
            childBlock.setParent(this);
            tlChildren.add(childBlock);
        }
        ArrayList<TemplateLanguageBlock> children = this.myForeignChildren == null ? tlChildren : BlockUtil.mergeBlocks(tlChildren, this.myForeignChildren);
        return BlockUtil.setParent(children, this);
    }

    protected boolean shouldBuildBlockFor(ASTNode childNode) {
        return childNode.getElementType() != this.getTemplateTextElementType() || this.noForeignChildren();
    }

    private boolean noForeignChildren() {
        return this.myForeignChildren == null || this.myForeignChildren.isEmpty();
    }

    void addForeignChild(@NotNull DataLanguageBlockWrapper foreignChild) {
        if (foreignChild == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/formatting/templateLanguages/TemplateLanguageBlock.addForeignChild must not be null");
        }
        this.initForeignChildren();
        this.myForeignChildren.add(foreignChild);
    }

    void addForeignChildren(List<DataLanguageBlockWrapper> foreignChildren) {
        this.initForeignChildren();
        this.myForeignChildren.addAll(foreignChildren);
    }

    private void initForeignChildren() {
        assert (!this.myChildrenBuilt);
        if (this.myForeignChildren == null) {
            this.myForeignChildren = new ArrayList<DataLanguageBlockWrapper>(5);
        }
    }

    @Nullable
    public Spacing getSpacing(Block child1, Block child2) {
        if (child1 instanceof DataLanguageBlockWrapper && child2 instanceof DataLanguageBlockWrapper) {
            return ((DataLanguageBlockWrapper)child1).getRightHandSpacing((DataLanguageBlockWrapper)child2);
        }
        return null;
    }

    public boolean isLeaf() {
        return this.noForeignChildren() && this.getNode().getFirstChildNode() == null;
    }

    protected abstract IElementType getTemplateTextElementType();

    @Override
    public BlockWithParent getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(BlockWithParent newParent) {
        this.myParent = newParent;
    }

    public boolean isRequiredRange(TextRange range) {
        return true;
    }

    protected Wrap createChildWrap(ASTNode child) {
        return Wrap.createWrap((WrapType)Wrap.NONE, (boolean)false);
    }

    protected Alignment createChildAlignment(ASTNode child) {
        return null;
    }
}

