/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import java.io.IOException;

public class PutEntryLabelChange
extends PutLabelChange {
    private String myPath;
    private IdPath myAffectedIdPath;

    public PutEntryLabelChange(String path, String name, long timestamp) {
        super(name, timestamp);
        this.myPath = path;
    }

    public PutEntryLabelChange(Stream s) throws IOException {
        super(s);
        this.myAffectedIdPath = s.readIdPath();
    }

    @Override
    public void write(Stream s) throws IOException {
        super.write(s);
        s.writeIdPath(this.myAffectedIdPath);
    }

    @Override
    public void applyTo(Entry r) {
        this.myAffectedIdPath = r.getEntry(this.myPath).getIdPath();
    }

    @Override
    public boolean affects(IdPath ... pp) {
        for (IdPath p : pp) {
            if (!p.startsWith(this.myAffectedIdPath)) continue;
            return true;
        }
        return false;
    }
}

