/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;

public class FileFilter {
    public static final long MAX_FILE_SIZE = 102400L;
    private final FileIndex myFileIndex;
    private final FileTypeManager myTypeManager;

    public FileFilter(FileIndex fi, FileTypeManager tm) {
        this.myFileIndex = fi;
        this.myTypeManager = tm;
    }

    public boolean isAllowedAndUnderContentRoot(VirtualFile f) {
        return this.isAllowed(f) && this.isUnderContentRoot(f);
    }

    public boolean isUnderContentRoot(VirtualFile f) {
        if (!(f.getFileSystem() instanceof LocalFileSystem)) {
            return false;
        }
        return this.myFileIndex.isInContent(f);
    }

    public boolean isAllowed(VirtualFile f) {
        if (this.myTypeManager.isFileIgnored(f.getName())) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return !this.myTypeManager.getFileTypeByFile(f).isBinary();
    }
}

