/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.NotNull;

public class SaveAndSyncHandler
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.SaveAndSyncHandler");
    private final Runnable myIdleListener;
    private final PropertyChangeListener myGeneralSettingsListener;

    public SaveAndSyncHandler(FrameStateManager frameStateManager, final FileDocumentManager fileDocumentManager, final GeneralSettings generalSettings) {
        this.myIdleListener = new Runnable(){

            @Override
            public void run() {
                if (generalSettings.isAutoSaveIfInactive() && SaveAndSyncHandler.canSyncOrSave()) {
                    fileDocumentManager.saveAllDocuments();
                }
            }
        };
        IdeEventQueue.getInstance().addIdleListener(this.myIdleListener, generalSettings.getInactiveTimeout() * 1000);
        this.myGeneralSettingsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("inactiveTimeout".equals(e.getPropertyName())) {
                    IdeEventQueue eventQueue = IdeEventQueue.getInstance();
                    eventQueue.removeIdleListener(SaveAndSyncHandler.this.myIdleListener);
                    Integer timeout = (Integer)e.getNewValue();
                    eventQueue.addIdleListener(SaveAndSyncHandler.this.myIdleListener, timeout * 1000);
                }
            }
        };
        generalSettings.addPropertyChangeListener(this.myGeneralSettingsListener);
        frameStateManager.addListener(new FrameStateListener(){

            public void onFrameDeactivated() {
                if (SaveAndSyncHandler.canSyncOrSave()) {
                    SaveAndSyncHandler.saveProjectsAndDocuments();
                }
            }

            public void onFrameActivated() {
                SaveAndSyncHandler.refreshFiles();
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("SaveAndSyncHandler" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/SaveAndSyncHandler.getComponentName must not return null");
        }
        return "SaveAndSyncHandler";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        GeneralSettings.getInstance().removePropertyChangeListener(this.myGeneralSettingsListener);
        IdeEventQueue.getInstance().removeIdleListener(this.myIdleListener);
    }

    private static boolean canSyncOrSave() {
        return !LaterInvocator.isInModalContext() && !ProgressManager.getInstance().hasModalProgressIndicator();
    }

    private static void saveProjectsAndDocuments() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: save()");
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
            Project[] openProjects;
            FileDocumentManager.getInstance().saveAllDocuments();
            for (Project project : openProjects = ProjectManagerEx.getInstanceEx().getOpenProjects()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("save project: " + project);
                }
                project.save();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("save application settings");
            }
            ApplicationManagerEx.getApplicationEx().saveSettings();
            if (LOG.isDebugEnabled()) {
                LOG.debug("exit: save()");
            }
        }
    }

    private static void refreshFiles() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: synchronize()");
        }
        if (SaveAndSyncHandler.canSyncOrSave()) {
            SaveAndSyncHandler.refreshOpenFiles();
        }
        if (GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("refresh VFS");
            }
            VirtualFileManager.getInstance().refresh(true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("exit: synchronize()");
        }
    }

    public static void refreshOpenFiles() {
        RefreshSession session = RefreshQueue.getInstance().createSession(false, false, null);
        for (Project project : ProjectManagerEx.getInstanceEx().getOpenProjects()) {
            VirtualFile[] files;
            for (VirtualFile file : files = FileEditorManager.getInstance((Project)project).getSelectedFiles()) {
                if (!(file instanceof NewVirtualFile)) continue;
                session.addFile(file);
            }
        }
        session.launch();
    }
}

