/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.AutoScrollToSourceOptionProvider;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CollapseAllToolbarAction;
import com.intellij.ide.actions.ExpandAllToolbarAction;
import com.intellij.ide.actions.ExportToTextFileToolbarAction;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.AutoScrollToSourceHandler;
import javax.swing.JComponent;
import javax.swing.JTree;

public class CommonActionsManagerImpl
extends CommonActionsManager {
    public AnAction createPrevOccurenceAction(OccurenceNavigator navigator) {
        return new PreviousOccurenceToolbarAction(navigator);
    }

    public AnAction createNextOccurenceAction(OccurenceNavigator navigator) {
        return new NextOccurenceToolbarAction(navigator);
    }

    public AnAction createExpandAllAction(TreeExpander expander) {
        return new ExpandAllToolbarAction(expander);
    }

    public AnAction createExpandAllAction(TreeExpander expander, JComponent component) {
        ExpandAllToolbarAction expandAllToolbarAction = new ExpandAllToolbarAction(expander);
        expandAllToolbarAction.registerCustomShortcutSet(expandAllToolbarAction.getShortcutSet(), component);
        return expandAllToolbarAction;
    }

    public AnAction createCollapseAllAction(TreeExpander expander) {
        return new CollapseAllToolbarAction(expander);
    }

    public AnAction createCollapseAllAction(TreeExpander expander, JComponent component) {
        CollapseAllToolbarAction collapseAllToolbarAction = new CollapseAllToolbarAction(expander);
        collapseAllToolbarAction.registerCustomShortcutSet(collapseAllToolbarAction.getShortcutSet(), component);
        return collapseAllToolbarAction;
    }

    public AnAction createHelpAction(String helpId) {
        return new HelpAction(helpId);
    }

    public AnAction installAutoscrollToSourceHandler(Project project, JTree tree, final AutoScrollToSourceOptionProvider optionProvider) {
        AutoScrollToSourceHandler handler = new AutoScrollToSourceHandler(){

            public boolean isAutoScrollMode() {
                return optionProvider.isAutoScrollMode();
            }

            public void setAutoScrollMode(boolean state) {
                optionProvider.setAutoScrollMode(state);
            }
        };
        handler.install(tree);
        return handler.createToggleAction();
    }

    public AnAction createExportToTextFileAction(ExporterToTextFile exporter) {
        return new ExportToTextFileToolbarAction(exporter);
    }

    private static final class HelpAction
    extends AnAction
    implements DumbAware {
        private final String myHelpId;

        private HelpAction(String helpId) {
            super(IdeBundle.message((String)"action.help", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/help.png"));
            this.myHelpId = helpId;
        }

        public void actionPerformed(AnActionEvent e) {
            HelpManager.getInstance().invokeHelp(this.myHelpId);
        }
    }
}

