/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.impl.IdeRootPaneNorthExtension;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NonNls;

public class NavBarRootPaneExtension
extends IdeRootPaneNorthExtension {
    private static final Icon CROSS_ICON = IconLoader.getIcon((String)"/actions/cross.png");
    private JComponent myPanel;
    @NonNls
    public static final String NAV_BAR = "NavBar";
    private final Project myProject;
    private NavBarPanel myNavigationBar;

    public NavBarRootPaneExtension(Project project) {
        this.myProject = project;
    }

    @Override
    public JComponent getComponent() {
        if (this.myPanel == null) {
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.setBackground(UIUtil.getListBackground());
            this.myNavigationBar = new NavBarPanel(this.myProject);
            JScrollPane scroller = new JScrollPane(this.myNavigationBar);
            scroller.setVerticalScrollBarPolicy(21);
            scroller.setHorizontalScrollBar(null);
            scroller.setBorder(null);
            this.myPanel.add((Component)scroller, "Center");
            JLabel closeLabel = new JLabel(CROSS_ICON);
            closeLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    UISettings.getInstance().SHOW_NAVIGATION_BAR = false;
                    NavBarRootPaneExtension.this.uiSettingsChanged(UISettings.getInstance());
                }
            });
            this.myPanel.add((Component)closeLabel, "East");
            this.myPanel.putClientProperty("NavBarPanel", this.myNavigationBar);
            this.myNavigationBar.installBorder(0);
            this.myPanel.setBorder(this.myNavigationBar.getBorder());
            this.myNavigationBar.setBorder(null);
        }
        return this.myPanel;
    }

    @Override
    public void uiSettingsChanged(UISettings settings) {
        if (this.myNavigationBar != null) {
            this.myNavigationBar.updateState(settings.SHOW_NAVIGATION_BAR);
            this.myPanel.setVisible(settings.SHOW_NAVIGATION_BAR);
        }
    }

    @Override
    @NonNls
    public String getKey() {
        return NAV_BAR;
    }

    public void dispose() {
        this.myPanel.setVisible(false);
        this.myPanel = null;
        this.myNavigationBar = null;
    }
}

