/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.masterKey;

import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class ResetPasswordDialog
extends DialogWrapper {
    private JPasswordField myNewPasswordPasswordField;
    private JPasswordField myConfirmNewPasswordPasswordField;
    private JPanel myPanel;
    private JLabel myPrompt;
    private JCheckBox myEncryptMasterPasswordWithCheckBox;

    protected ResetPasswordDialog(Project project, MasterKeyPasswordSafe safe, boolean firstTime) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle(firstTime ? "Master Password" : "Reset Master Password");
        this.setOKButtonText(firstTime ? "Set Password" : "Reset Password");
        if (safe.isOsProtectedPasswordSupported()) {
            this.myEncryptMasterPasswordWithCheckBox.setSelected(false);
        } else {
            this.myEncryptMasterPasswordWithCheckBox.setSelected(false);
            this.myEncryptMasterPasswordWithCheckBox.setVisible(false);
        }
        if (firstTime) {
            this.myPrompt.setText("Specify Master Password for the password database.");
        }
        MasterKeyUtils.matchPasswords(this.myConfirmNewPasswordPasswordField, this.myNewPasswordPasswordField, new Processor<String>(){

            public boolean process(String s) {
                ResetPasswordDialog.this.setErrorText(s);
                ResetPasswordDialog.this.setOKActionEnabled(s == null);
                return false;
            }
        });
        this.init();
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public static boolean newPassword(Project project, MasterKeyPasswordSafe safe) {
        return ResetPasswordDialog.resetPassword(project, safe, true);
    }

    public static boolean resetPassword(Project project, MasterKeyPasswordSafe safe) {
        return ResetPasswordDialog.resetPassword(project, safe, false);
    }

    private static boolean resetPassword(Project project, MasterKeyPasswordSafe safe, boolean firstTime) {
        ResetPasswordDialog d = new ResetPasswordDialog(project, safe, firstTime);
        d.show();
        if (d.isOK()) {
            safe.resetMasterPassword(new String(d.myNewPasswordPasswordField.getPassword()), d.myEncryptMasterPasswordWithCheckBox.isSelected());
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JPasswordField jPasswordField;
        JPasswordField jPasswordField2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("New Password");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNewPasswordPasswordField = jPasswordField2 = new JPasswordField();
        jPanel.add((Component)jPasswordField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Confirm New Password");
        jLabel3.setDisplayedMnemonic('C');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConfirmNewPasswordPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myEncryptMasterPasswordWithCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText("The master password will be stored in password database  encrypted with user credentials using OS-specific mechanisms. If this checkbox is selected, the master password will not be asked from user, on new session.");
        jCheckBox.setText("Encrypt master password with user credentials");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPrompt = jLabel = new JLabel();
        jLabel.setText("<html>The password for the password database will be reset.<br/><b>NOTE:</b> All previously stored passwords will be removed.</html>");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jPasswordField2);
        jLabel3.setLabelFor(jPasswordField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

