/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NonNls;

public class PsiFileUrl
extends AbstractUrl {
    @NonNls
    private static final String ELEMENT_TYPE = "psiFile";

    public PsiFileUrl(String url, String moduleName) {
        super(url, moduleName, ELEMENT_TYPE);
    }

    @Override
    public Object[] createPath(Project project) {
        VirtualFile fileByUrl = VirtualFileManager.getInstance().findFileByUrl(this.url);
        if (fileByUrl == null || !fileByUrl.isValid()) {
            return null;
        }
        return new Object[]{PsiManager.getInstance((Project)project).findFile(fileByUrl)};
    }

    @Override
    protected AbstractUrl createUrl(String moduleName, String url) {
        return new PsiFileUrl(url, moduleName);
    }

    @Override
    public AbstractUrl createUrlByElement(Object element) {
        VirtualFile file;
        if (element instanceof PsiFile && (file = ((PsiFile)element).getVirtualFile()) != null) {
            return new PsiFileUrl(file.getUrl(), null);
        }
        return null;
    }
}

