/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.search.TodoItem;
import org.jetbrains.annotations.NotNull;

public final class SmartTodoItemPointer {
    private final TodoItem myTodoItem;
    private final Document myDocument;
    private final RangeMarker myRangeMarker;

    public SmartTodoItemPointer(@NotNull TodoItem todoItem, @NotNull Document document) {
        if (todoItem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/todo/SmartTodoItemPointer.<init> must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/todo/SmartTodoItemPointer.<init> must not be null");
        }
        this.myTodoItem = todoItem;
        this.myDocument = document;
        TextRange textRange = this.myTodoItem.getTextRange();
        this.myRangeMarker = document.createRangeMarker(textRange);
    }

    public TodoItem getTodoItem() {
        return this.myTodoItem;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public RangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SmartTodoItemPointer)) {
            return false;
        }
        SmartTodoItemPointer pointer = (SmartTodoItemPointer)obj;
        return this.myTodoItem.getFile().equals(pointer.myTodoItem.getFile()) && this.myRangeMarker.getStartOffset() == pointer.myRangeMarker.getStartOffset() && this.myRangeMarker.getEndOffset() == pointer.myRangeMarker.getEndOffset() && this.myTodoItem.getPattern().equals((Object)pointer.myTodoItem.getPattern());
    }

    public int hashCode() {
        return this.myTodoItem.getFile().hashCode();
    }
}

