/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.util.text.CharArrayCharSequence;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JavaUtil {
    public static List<Pair<File, String>> suggestRoots(File dir) {
        ArrayList<Pair<File, String>> foundDirectories = new ArrayList<Pair<File, String>>();
        try {
            JavaUtil.suggestRootsImpl(dir, dir, foundDirectories);
        }
        catch (PathFound pathFound) {
            // empty catch block
        }
        return foundDirectories;
    }

    private static void suggestRootsImpl(File base, File dir, ArrayList<? super Pair<File, String>> foundDirectories) throws PathFound {
        File[] list;
        if (!dir.isDirectory()) {
            return;
        }
        FileTypeManager typeManager = FileTypeManager.getInstance();
        if (typeManager.isFileIgnored(dir.getName())) {
            return;
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            if (progressIndicator.isCanceled()) {
                return;
            }
            progressIndicator.setText2(dir.getPath());
        }
        if ((list = dir.listFiles()) == null || list.length == 0) {
            return;
        }
        for (File child : list) {
            FileType type;
            if (!child.isFile() || StdFileTypes.JAVA != (type = typeManager.getFileTypeByFileName(child.getName()))) continue;
            if (progressIndicator != null && progressIndicator.isCanceled()) {
                return;
            }
            Pair<File, String> root = JavaUtil.suggestRootForJavaFile(child);
            if (root != null) {
                String packagePrefix = JavaUtil.getPackagePrefix(base, root);
                if (packagePrefix == null) {
                    foundDirectories.add((Pair<File, String>)root);
                } else {
                    foundDirectories.add((Pair<File, String>)Pair.create((Object)base, (Object)packagePrefix));
                }
                throw new PathFound((File)root.getFirst());
            }
            return;
        }
        for (File child : list) {
            if (!child.isDirectory()) continue;
            try {
                JavaUtil.suggestRootsImpl(base, child, foundDirectories);
            }
            catch (PathFound found) {
                if (found.myDirectory.equals(child)) continue;
                throw found;
            }
        }
    }

    private static String getPackagePrefix(File base, Pair<File, String> root) {
        String result = "";
        for (File parent = base; parent != null; parent = parent.getParentFile()) {
            if (parent.equals(root.getFirst())) {
                return (String)root.getSecond() + (((String)root.getSecond()).length() > 0 && result.length() > 0 ? "." : "") + result;
            }
            result = parent.getName() + (result.length() > 0 ? "." : "") + result;
        }
        return null;
    }

    private static Pair<File, String> suggestRootForJavaFile(File javaFile) {
        if (!javaFile.isFile()) {
            return null;
        }
        try {
            CharArrayCharSequence chars = new CharArrayCharSequence(FileUtil.loadFileText((File)javaFile));
            String packageName = JavaUtil.getPackageStatement((CharSequence)chars);
            if (packageName != null) {
                File root = javaFile.getParentFile();
                int index = packageName.length();
                while (index > 0) {
                    boolean equalsToToken;
                    int index1 = packageName.lastIndexOf(46, index - 1);
                    String token = packageName.substring(index1 + 1, index);
                    String dirName = root.getName();
                    boolean bl = equalsToToken = SystemInfo.isFileSystemCaseSensitive ? dirName.equals(token) : dirName.equalsIgnoreCase(token);
                    if (!equalsToToken) {
                        return Pair.create((Object)root, (Object)packageName.substring(0, index));
                    }
                    String parent = root.getParent();
                    if (parent == null) {
                        return null;
                    }
                    root = new File(parent);
                    index = index1;
                }
                return Pair.create((Object)root, (Object)"");
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    private static String getPackageStatement(CharSequence text) {
        JavaLexer lexer = new JavaLexer(LanguageLevel.JDK_1_3);
        lexer.start(text);
        JavaUtil.skipWhiteSpaceAndComments((Lexer)lexer);
        if (lexer.getTokenType() != JavaTokenType.PACKAGE_KEYWORD) {
            return "";
        }
        lexer.advance();
        JavaUtil.skipWhiteSpaceAndComments((Lexer)lexer);
        StringBuilder buffer = new StringBuilder();
        while (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            buffer.append(text, lexer.getTokenStart(), lexer.getTokenEnd());
            lexer.advance();
            JavaUtil.skipWhiteSpaceAndComments((Lexer)lexer);
            if (lexer.getTokenType() != JavaTokenType.DOT) break;
            buffer.append('.');
            lexer.advance();
            JavaUtil.skipWhiteSpaceAndComments((Lexer)lexer);
        }
        String packageName = buffer.toString();
        if (packageName.length() == 0 || StringUtil.endsWithChar((CharSequence)packageName, (char)'.')) {
            return null;
        }
        return packageName;
    }

    private static void skipWhiteSpaceAndComments(Lexer lexer) {
        while (JavaTokenType.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
            lexer.advance();
        }
    }

    private static class PathFound
    extends Exception {
        public File myDirectory;

        public PathFound(File directory) {
            this.myDirectory = directory;
        }
    }
}

