/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.autodetecting.FacetDetector;
import com.intellij.facet.autodetecting.UnderlyingFacetSelector;
import com.intellij.facet.impl.autodetecting.FacetDetectorForWizardRegistry;
import com.intellij.facet.impl.autodetecting.FacetDetectorRegistryEx;
import com.intellij.facet.impl.autodetecting.facetsTree.DetectedFacetsTreeComponent;
import com.intellij.facet.impl.ui.FacetDetectionProcessor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.newProjectWizard.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FacetDetectionStep
extends AbstractStepWithProgress<Map<ModuleDescriptor, Map<File, List<FacetDetectionProcessor.DetectedInWizardFacetInfo>>>>
implements ProjectFromSourcesBuilder.ProjectConfigurationUpdater {
    private final Icon myIcon;
    private final ModuleType myModuleType;
    private List<File> myLastRoots = null;
    private final DetectedFacetsTreeComponent myDetectedFacetsComponent;
    private JPanel myMainPanel;
    private JPanel myFacetsTreePanel;
    private JLabel myFacetsDetectedLabel;

    public FacetDetectionStep(Icon icon, ModuleType moduleType) {
        super(ProjectBundle.message((String)"message.text.stop.searching.for.facets", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
        this.myIcon = icon;
        this.myModuleType = moduleType;
        this.$$$setupUI$$$();
        this.myDetectedFacetsComponent = new DetectedFacetsTreeComponent();
    }

    public void updateDataModel() {
    }

    @Override
    protected boolean shouldRunProgress() {
        return this.myLastRoots == null || !Comparing.haveEqualElements(this.myLastRoots, this.getRoots());
    }

    @Override
    protected String getProgressText() {
        return ProjectBundle.message((String)"progress.text.searching.facets", (Object[])new Object[0]);
    }

    @Override
    protected JComponent createResultsPanel() {
        JPanel mainPanel = this.myDetectedFacetsComponent.getMainPanel();
        this.myFacetsTreePanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)mainPanel), "Center");
        return this.myMainPanel;
    }

    @Override
    protected Map<ModuleDescriptor, Map<File, List<FacetDetectionProcessor.DetectedInWizardFacetInfo>>> calculate() {
        this.myLastRoots = this.getRoots();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        HashMap<ModuleDescriptor, Map<File, List<FacetDetectionProcessor.DetectedInWizardFacetInfo>>> result = new HashMap<ModuleDescriptor, Map<File, List<FacetDetectionProcessor.DetectedInWizardFacetInfo>>>();
        for (ModuleDescriptor moduleDescriptor : this.getModuleDescriptors()) {
            HashMap<File, List<FacetDetectionProcessor.DetectedInWizardFacetInfo>> root2Facets = new HashMap<File, List<FacetDetectionProcessor.DetectedInWizardFacetInfo>>();
            for (File root : moduleDescriptor.getContentRoots()) {
                FacetDetectionProcessor processor = new FacetDetectionProcessor(progressIndicator, this.myModuleType);
                processor.process(root);
                List<FacetDetectionProcessor.DetectedInWizardFacetInfo> facets = processor.getDetectedFacetsInfos();
                if (facets.isEmpty()) continue;
                root2Facets.put(root, facets);
            }
            if (root2Facets.isEmpty()) continue;
            result.put(moduleDescriptor, root2Facets);
        }
        return result;
    }

    protected abstract List<ModuleDescriptor> getModuleDescriptors();

    private List<File> getRoots() {
        ArrayList<File> roots = new ArrayList<File>();
        for (ModuleDescriptor moduleDescriptor : this.getModuleDescriptors()) {
            roots.addAll(moduleDescriptor.getContentRoots());
        }
        return roots;
    }

    @Override
    protected void onFinished(Map<ModuleDescriptor, Map<File, List<FacetDetectionProcessor.DetectedInWizardFacetInfo>>> result, boolean canceled) {
        this.myDetectedFacetsComponent.clear();
        for (ModuleDescriptor moduleDescriptor : result.keySet()) {
            this.myDetectedFacetsComponent.addFacets(moduleDescriptor, result.get(moduleDescriptor));
        }
        this.myDetectedFacetsComponent.createTree();
        if (result.isEmpty()) {
            this.myFacetsDetectedLabel.setText(ProjectBundle.message((String)"label.text.no.facets.detected", (Object[])new Object[0]));
        } else {
            this.myFacetsDetectedLabel.setText(ProjectBundle.message((String)"label.text.the.following.facets.are.detected", (Object[])new Object[0]));
        }
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public static boolean isEnabled(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/importProject/FacetDetectionStep.isEnabled must not be null");
        }
        for (FacetType facetType : FacetTypeRegistry.getInstance().getFacetTypes()) {
            if (!facetType.isSuitableModuleType(moduleType)) continue;
            final Ref hasDetector = Ref.create((Object)false);
            facetType.registerDetectors(new FacetDetectorRegistryEx(new FacetDetectorForWizardRegistry(){

                public void register(@NotNull FileType fileType, @NotNull VirtualFileFilter virtualFileFilter, @NotNull FacetDetector facetDetector) {
                    if (fileType == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/importProject/FacetDetectionStep$1.register must not be null");
                    }
                    if (virtualFileFilter == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/importProject/FacetDetectionStep$1.register must not be null");
                    }
                    if (facetDetector == null) {
                        throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/util/importProject/FacetDetectionStep$1.register must not be null");
                    }
                    hasDetector.set((Object)true);
                }

                public void register(FileType fileType, @NotNull VirtualFileFilter virtualFileFilter, FacetDetector facetDetector, UnderlyingFacetSelector underlyingFacetSelector) {
                    if (virtualFileFilter == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/importProject/FacetDetectionStep$1.register must not be null");
                    }
                    hasDetector.set((Object)true);
                }
            }, null));
            if (!((Boolean)hasDetector.get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.fromCode.facets";
    }

    @Override
    public void updateModule(ModuleDescriptor descriptor, Module module, ModifiableRootModel rootModel) {
        this.myDetectedFacetsComponent.createFacets(descriptor, module, rootModel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        this.myFacetsDetectedLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("label.text.the.following.facets.are.detected"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFacetsTreePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

