/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockFileManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.CompositeCacheManager;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockPsiManager
extends PsiManagerEx {
    private final Project myProject;
    private final Map<VirtualFile, PsiDirectory> myDirectories = new THashMap();
    private CachedValuesManagerImpl myCachedValuesManager;
    private MockFileManager myMockFileManager;
    private PsiModificationTrackerImpl myPsiModificationTracker;
    private final CompositeCacheManager myCompositeCacheManager = new CompositeCacheManager();
    private ResolveCache myResolveCache;

    public MockPsiManager() {
        this(null);
    }

    public MockPsiManager(Project project) {
        this.myProject = project;
    }

    public void addPsiDirectory(VirtualFile file, PsiDirectory psiDirectory) {
        this.myDirectories.put(file, psiDirectory);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockPsiManager.getProject must not return null");
        }
        return project;
    }

    public PsiFile findFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.findFile must not be null");
        }
        return null;
    }

    @Nullable
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.findViewProvider must not be null");
        }
        return null;
    }

    public PsiDirectory findDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.findDirectory must not be null");
        }
        return this.myDirectories.get(file);
    }

    public boolean areElementsEquivalent(PsiElement element1, PsiElement element2) {
        return Comparing.equal((Object)element1, (Object)element2);
    }

    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.reloadFromDisk must not be null");
        }
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.addPsiTreeChangeListener must not be null");
        }
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener, Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.addPsiTreeChangeListener must not be null");
        }
    }

    public void removePsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.removePsiTreeChangeListener must not be null");
        }
    }

    @NotNull
    public CodeStyleManager getCodeStyleManager() {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        if (codeStyleManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockPsiManager.getCodeStyleManager must not return null");
        }
        return codeStyleManager;
    }

    @NotNull
    public PsiSearchHelper getSearchHelper() {
        PsiSearchHelperImpl psiSearchHelperImpl = new PsiSearchHelperImpl(this);
        if (psiSearchHelperImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockPsiManager.getSearchHelper must not return null");
        }
        return psiSearchHelperImpl;
    }

    @NotNull
    public PsiModificationTracker getModificationTracker() {
        if (this.myPsiModificationTracker == null) {
            this.myPsiModificationTracker = new PsiModificationTrackerImpl(this.myProject);
        }
        PsiModificationTrackerImpl psiModificationTrackerImpl = this.myPsiModificationTracker;
        if (psiModificationTrackerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockPsiManager.getModificationTracker must not return null");
        }
        return psiModificationTrackerImpl;
    }

    @NotNull
    public CachedValuesManager getCachedValuesManager() {
        if (this.myCachedValuesManager == null) {
            this.myCachedValuesManager = new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this));
        }
        CachedValuesManagerImpl cachedValuesManagerImpl = this.myCachedValuesManager;
        if (cachedValuesManagerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockPsiManager.getCachedValuesManager must not return null");
        }
        return cachedValuesManagerImpl;
    }

    public void moveFile(@NotNull PsiFile file, @NotNull PsiDirectory newParentDir) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.moveFile must not be null");
        }
        if (newParentDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockPsiManager.moveFile must not be null");
        }
    }

    public void moveDirectory(@NotNull PsiDirectory dir, @NotNull PsiDirectory newParentDir) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.moveDirectory must not be null");
        }
        if (newParentDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockPsiManager.moveDirectory must not be null");
        }
    }

    public void checkMove(@NotNull PsiElement element, @NotNull PsiElement newContainer) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.checkMove must not be null");
        }
        if (newContainer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockPsiManager.checkMove must not be null");
        }
    }

    public void startBatchFilesProcessingMode() {
    }

    public void finishBatchFilesProcessingMode() {
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.getUserData must not be null");
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.putUserData must not be null");
        }
    }

    public boolean isDisposed() {
        return false;
    }

    public void dropResolveCaches() {
        this.getFileManager().cleanupForNextTest();
    }

    public boolean isInProject(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.isInProject must not be null");
        }
        return false;
    }

    public void performActionWithFormatterDisabled(Runnable r) {
        r.run();
    }

    public <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> r) throws T {
        r.run();
    }

    public <T> T performActionWithFormatterDisabled(Computable<T> r) {
        return (T)r.compute();
    }

    public void registerLanguageInjector(@NotNull LanguageInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.registerLanguageInjector must not be null");
        }
    }

    public void registerLanguageInjector(@NotNull LanguageInjector injector, Disposable parentDisposable) {
        if (injector == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.registerLanguageInjector must not be null");
        }
    }

    public void unregisterLanguageInjector(@NotNull LanguageInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.unregisterLanguageInjector must not be null");
        }
    }

    public void postponeAutoFormattingInside(Runnable runnable) {
        PostprocessReformattingAspect.getInstance(this.getProject()).postponeFormattingInside(runnable);
    }

    @NotNull
    public List<LanguageInjector> getLanguageInjectors() {
        List<LanguageInjector> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockPsiManager.getLanguageInjectors must not return null");
        }
        return list;
    }

    @Override
    public boolean isBatchFilesProcessingMode() {
        return false;
    }

    @Override
    public boolean isAssertOnFileLoading(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.isAssertOnFileLoading must not be null");
        }
        return false;
    }

    @Override
    public void nonPhysicalChange() {
        throw new UnsupportedOperationException("Method nonPhysicalChange is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Override
    public void physicalChange() {
        throw new UnsupportedOperationException("physicalChange is not implemented");
    }

    @Override
    @NotNull
    public ResolveCache getResolveCache() {
        if (this.myResolveCache == null) {
            this.myResolveCache = new ResolveCache(this);
        }
        ResolveCache resolveCache = this.myResolveCache;
        if (resolveCache == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockPsiManager.getResolveCache must not return null");
        }
        return resolveCache;
    }

    @Override
    public void registerRunnableToRunOnChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.registerRunnableToRunOnChange must not be null");
        }
    }

    @Override
    public void registerWeakRunnableToRunOnChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.registerWeakRunnableToRunOnChange must not be null");
        }
    }

    @Override
    public void registerRunnableToRunOnAnyChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.registerRunnableToRunOnAnyChange must not be null");
        }
    }

    @Override
    public void registerRunnableToRunAfterAnyChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.registerRunnableToRunAfterAnyChange must not be null");
        }
        throw new UnsupportedOperationException("Method registerRunnableToRunAfterAnyChange is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Override
    @NotNull
    public FileManager getFileManager() {
        if (this.myMockFileManager == null) {
            this.myMockFileManager = new MockFileManager(this);
        }
        MockFileManager mockFileManager = this.myMockFileManager;
        if (mockFileManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockPsiManager.getFileManager must not return null");
        }
        return mockFileManager;
    }

    @Override
    public void invalidateFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.invalidateFile must not be null");
        }
    }

    @Override
    public void beforeChildRemoval(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.beforeChildRemoval must not be null");
        }
    }

    @Override
    public void beforeChildReplacement(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockPsiManager.beforeChildReplacement must not be null");
        }
    }

    @Override
    @NotNull
    public CacheManager getCacheManager() {
        CompositeCacheManager compositeCacheManager = this.myCompositeCacheManager;
        if (compositeCacheManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockPsiManager.getCacheManager must not return null");
        }
        return compositeCacheManager;
    }
}

