/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationModelListener;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.notification.impl.ui.StickyButton;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.util.MinimizeButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.content.GraphicsConfig;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationsListPanel
extends JPanel
implements NotificationModelListener,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.impl.ui.NotificationsListPanel");
    private static final String REMOVE_KEY = "REMOVE";
    private Project myProject;
    private Wrapper myWrapper;
    private JComponent myActiveComponent;
    private JComponent myEmptyComponent;
    private JComponent myListComponent;

    public NotificationsListPanel(@Nullable Project project) {
        this.setLayout(new BorderLayout());
        this.myProject = project;
        this.myEmptyComponent = new JLabel("No new notifications.", 0);
        this.myListComponent = ItemsList.create(project, this);
        this.myWrapper = new Wrapper();
        this.myWrapper.setContent(this.getCurrentComponent(project));
        this.add((Component)this.myWrapper, "Center");
    }

    @Override
    public void notificationsAdded(Notification ... notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsListPanel.notificationsAdded must not be null");
        }
        this.switchView(this.myProject);
    }

    @Override
    public void notificationsRemoved(Notification ... notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsListPanel.notificationsRemoved must not be null");
        }
        this.switchView(this.myProject);
    }

    @Override
    public void notificationsRead(Notification ... notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsListPanel.notificationsRead must not be null");
        }
        this.switchView(this.myProject);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        NotificationsListPanel.getManager().addListener(this);
    }

    @Override
    public void removeNotify() {
        NotificationsListPanel.getManager().removeListener(this);
        super.removeNotify();
    }

    private JComponent getCurrentComponent(@Nullable Project project) {
        JComponent component;
        boolean empty = NotificationsListPanel.getManager().count(project) == 0;
        JComponent jComponent = component = empty ? this.myEmptyComponent : this.myListComponent;
        if (this.myActiveComponent == component) {
            return null;
        }
        this.myActiveComponent = component;
        return this.myActiveComponent;
    }

    protected void switchView(@Nullable Project project) {
        JComponent component = this.getCurrentComponent(project);
        if (component != null) {
            this.myWrapper.setContent(component);
            this.myWrapper.revalidate();
            this.myWrapper.repaint();
        }
    }

    public void dispose() {
        NotificationsListPanel.getManager().markRead();
        this.myProject = null;
    }

    private static NotificationsManagerImpl getManager() {
        return NotificationsManagerImpl.getNotificationsManagerImpl();
    }

    static Dimension getMinSize() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        size.width = (int)((double)size.width * 0.1);
        size.height = (int)((double)size.height * 0.1);
        return size;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myWrapper.getTargetComponent();
    }

    public static JBPopup show(@Nullable Project project, @NotNull JComponent parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsListPanel.show must not be null");
        }
        final NotificationsListPanel panel = new NotificationsListPanel(project);
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, panel.getPreferredFocusedComponent());
        JBPopup popup = builder.setResizable(true).setMinSize(NotificationsListPanel.getMinSize()).setDimensionServiceKey(null, "NotificationsPopup", true).setCancelOnClickOutside(false).setBelongsToGlobalPopupStack(false).setCancelButton((IconButton)new MinimizeButton("Hide")).setMovable(true).setRequestFocus(true).setTitle("Notifications").createPopup();
        popup.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void onClosed(LightweightWindowEvent event) {
                Disposer.dispose((Disposable)panel);
            }
        });
        popup.showInCenterOf((Component)SwingUtilities.getRootPane(parent));
        return popup;
    }

    private static abstract class MyButton
    extends StickyButton {
        private MyButton(String text, ActionListener listener) {
            super(text, listener);
        }

        private MyButton(String text) {
            super(text);
        }

        public abstract void updateTitle();
    }

    private static class ItemsList
    extends JList {
        private ItemsList(NotificationsListModel model) {
            super(model);
            this.setOpaque(false);
            this.setCellRenderer(new NotificationsListRenderer());
            this.getSelectionModel().setSelectionInterval(0, 0);
            this.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), NotificationsListPanel.REMOVE_KEY);
            this.getActionMap().put(NotificationsListPanel.REMOVE_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ItemsList.this.removeSelected();
                }
            });
            this.setBackground(UIUtil.getPanelBackgound());
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    ItemsList.this.processMouse(e, false);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        ItemsList.this.processMouse(e, true);
                    }
                }
            });
        }

        private void processMouse(MouseEvent e, boolean click) {
            Object value;
            int index = this.locationToIndex(e.getPoint());
            if (index > -1 && (value = this.getModel().getElementAt(index)) != null && value instanceof Notification) {
                Notification notification = (Notification)value;
                Component renderer = this.getCellRenderer().getListCellRendererComponent(this, value, index, false, false);
                if (renderer instanceof NotificationsListRenderer) {
                    Rectangle bounds = this.getCellBounds(index, index);
                    renderer.setBounds(bounds);
                    renderer.doLayout();
                    JTextPane text = ((NotificationsListRenderer)renderer).getText();
                    HyperlinkListener listener = null;
                    if (click) {
                        listener = NotificationsUtil.wrapListener(notification);
                        if (listener != null) {
                            text.addHyperlinkListener(listener);
                        }
                    } else {
                        Processor<Cursor> processor = new Processor<Cursor>(){

                            public boolean process(Cursor cursor) {
                                ItemsList.this.setCursor(cursor);
                                return true;
                            }
                        };
                        ((NotificationsListRenderer)renderer).setCursorHandler(processor);
                    }
                    Point point = e.getPoint();
                    point.translate(-bounds.x, -bounds.y);
                    Rectangle r = text.getBounds();
                    point.translate(-r.x, -r.y);
                    MouseEvent newEvent = new MouseEvent(text, e.getID(), e.getWhen(), e.getModifiers(), point.x, point.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    text.dispatchEvent(newEvent);
                    ((NotificationsListRenderer)renderer).resetCursorHandler();
                    if (listener != null) {
                        text.removeHyperlinkListener(listener);
                    }
                }
            }
        }

        public NotificationsListModel getModel() {
            ListModel listModel = super.getModel();
            return listModel instanceof NotificationsListModel ? (NotificationsListModel)listModel : null;
        }

        public void removeSelected() {
            ListSelectionModel model = this.getSelectionModel();
            NotificationsListModel listModel = this.getModel();
            if (!model.isSelectionEmpty()) {
                int min = model.getMinSelectionIndex();
                int max = model.getMaxSelectionIndex();
                ArrayList<Notification> tbr = new ArrayList<Notification>();
                for (int i = min; i <= max; ++i) {
                    Notification notification;
                    if (!model.isSelectedIndex(i) || (notification = (Notification)listModel.getElementAt(i)) == null) continue;
                    tbr.add(notification);
                }
                if (tbr.size() > 0) {
                    NotificationsListPanel.getManager().remove(tbr.toArray(new Notification[tbr.size()]));
                    int toSelect = Math.min(min, listModel.getSize() - 1);
                    model.clearSelection();
                    if (toSelect >= 0) {
                        model.setSelectionInterval(toSelect, toSelect);
                        this.scrollRectToVisible(this.getCellBounds(toSelect, toSelect));
                    }
                }
            }
            this.revalidate();
            this.repaint();
        }

        private static void createFilterButton(JPanel parent, ButtonGroup group, String title, ActionListener listener, final NotNullFunction<MyButton, String> titleCallback, char mnemonic, boolean active) {
            MyButton b = new MyButton(title, listener){

                @Override
                public void updateTitle() {
                    this.setText((String)titleCallback.fun((Object)this));
                }
            };
            parent.add(b);
            group.add(b);
            b.setFocusable(false);
            b.setSelected(active);
            b.setMnemonic(mnemonic);
        }

        private static void updateButtons(@NotNull JComponent filterBar) {
            Component[] components;
            if (filterBar == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsListPanel$ItemsList.updateButtons must not be null");
            }
            for (Component c : components = filterBar.getComponents()) {
                if (!(c instanceof MyButton)) continue;
                ((MyButton)c).updateTitle();
            }
        }

        private static JComponent buildFilterBar(final ItemsList list, final Project project) {
            JPanel box = new JPanel();
            box.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            box.setLayout(new BoxLayout(box, 0));
            final ButtonGroup buttonGroup = new ButtonGroup();
            ItemsList.createFilterButton(box, buttonGroup, "All", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    list.filter(null);
                }
            }, new NotNullFunction<MyButton, String>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @NotNull
                public String fun(MyButton myButton) {
                    int i = ItemsList.count(null, project);
                    if (i <= 0) return "All";
                    String string = String.format("All (%s)", i);
                    String string2 = string;
                    if (string != null) return string2;
                    throw new IllegalStateException("@NotNull method com/intellij/notification/impl/ui/NotificationsListPanel$ItemsList$7.fun must not return null");
                }
            }, 'A', true);
            ItemsList.createFilterButton(box, buttonGroup, "Error", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    list.filter(NotificationType.ERROR);
                }
            }, new NotNullFunction<MyButton, String>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @NotNull
                public String fun(MyButton myButton) {
                    int i = ItemsList.count(NotificationType.ERROR, project);
                    myButton.setVisible(i > 0);
                    if (i > 0) {
                        String string = String.format("Error (%s)", i);
                        String string2 = string;
                        if (string != null) return string2;
                        throw new IllegalStateException("@NotNull method com/intellij/notification/impl/ui/NotificationsListPanel$ItemsList$9.fun must not return null");
                    }
                    if (!myButton.isSelected()) return "Error";
                    ItemsList.switchToAll(buttonGroup);
                    return "Error";
                }
            }, 'E', false);
            ItemsList.createFilterButton(box, buttonGroup, "Warning", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    list.filter(NotificationType.WARNING);
                }
            }, new NotNullFunction<MyButton, String>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @NotNull
                public String fun(MyButton myButton) {
                    int i = ItemsList.count(NotificationType.WARNING, project);
                    myButton.setVisible(i > 0);
                    if (i > 0) {
                        String string = String.format("Warning (%s)", i);
                        String string2 = string;
                        if (string != null) return string2;
                        throw new IllegalStateException("@NotNull method com/intellij/notification/impl/ui/NotificationsListPanel$ItemsList$11.fun must not return null");
                    }
                    if (!myButton.isSelected()) return "Warning";
                    ItemsList.switchToAll(buttonGroup);
                    return "Warning";
                }
            }, 'W', false);
            ItemsList.createFilterButton(box, buttonGroup, "Information", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    list.filter(NotificationType.INFORMATION);
                }
            }, new NotNullFunction<MyButton, String>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @NotNull
                public String fun(MyButton myButton) {
                    int i = ItemsList.count(NotificationType.INFORMATION, project);
                    myButton.setVisible(i > 0);
                    if (i > 0) {
                        String string = String.format("Information (%s)", i);
                        String string2 = string;
                        if (string != null) return string2;
                        throw new IllegalStateException("@NotNull method com/intellij/notification/impl/ui/NotificationsListPanel$ItemsList$13.fun must not return null");
                    }
                    if (!myButton.isSelected()) return "Information";
                    ItemsList.switchToAll(buttonGroup);
                    return "Information";
                }
            }, 'I', false);
            return box;
        }

        private static void switchToAll(ButtonGroup buttonGroup) {
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                AbstractButton button = enumeration.nextElement();
                if (!button.getText().startsWith("All")) continue;
                button.doClick();
                return;
            }
        }

        private static int count(@Nullable NotificationType type, @Nullable Project project) {
            return NotificationsManagerImpl.getNotificationsManagerImpl().getByType(type, project).size();
        }

        private void filter(@Nullable NotificationType type) {
            NotificationsListModel listModel = this.getModel();
            listModel.filter(type);
            if (listModel.getSize() > 0) {
                this.setSelectedIndex(0);
            }
        }

        public static JComponent create(Project project, Disposable parentDisposable) {
            NotificationsListModel model = new NotificationsListModel(project);
            Disposer.register((Disposable)parentDisposable, (Disposable)model);
            final ItemsList list = new ItemsList(model);
            JScrollPane scrollPane = new JScrollPane(list);
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setBorder(null);
            scrollPane.getViewport().setBackground(UIUtil.getPanelBackgound());
            final JComponent buttonBar = ItemsList.buildFilterBar(list, project);
            model.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    ItemsList.updateButtons(buttonBar);
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    ItemsList.updateButtons(buttonBar);
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    ItemsList.updateButtons(buttonBar);
                }
            });
            JPanel panel = new JPanel(new BorderLayout()){

                @Override
                public void requestFocus() {
                    ItemsList.updateButtons(buttonBar);
                    list.requestFocus();
                }
            };
            panel.add((Component)buttonBar, "North");
            panel.add((Component)scrollPane, "Center");
            return panel;
        }
    }

    private static class NotificationsListModel
    extends AbstractListModel
    implements NotificationModelListener,
    Disposable {
        private List<Notification> myNotifications = new ArrayList<Notification>();
        private NotificationType myType;
        private Project myProject;
        private NotNullFunction<Project, Collection<Notification>> myRebuildFunction;
        private boolean myArchive;

        private NotificationsListModel(@Nullable Project project) {
            this.myProject = project;
            this.myRebuildFunction = new NotNullFunction<Project, Collection<Notification>>(){

                @NotNull
                public Collection<Notification> fun(Project project) {
                    Collection<Notification> collection = NotificationsListPanel.getManager().getByType(NotificationsListModel.this.myType, project);
                    if (collection == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/notification/impl/ui/NotificationsListPanel$NotificationsListModel$1.fun must not return null");
                    }
                    return collection;
                }
            };
            NotificationsListPanel.getManager().addListener(this);
            this.rebuildList();
        }

        public void dispose() {
            NotificationsListPanel.getManager().removeListener(this);
            this.myProject = null;
        }

        @Override
        public int getSize() {
            return this.myNotifications.size();
        }

        @Override
        public Object getElementAt(int index) {
            return index < this.myNotifications.size() ? this.myNotifications.get(index) : null;
        }

        private void rebuildList() {
            this.myNotifications.clear();
            this.myNotifications.addAll((Collection)this.myRebuildFunction.fun((Object)this.myProject));
            this.fireContentsChanged(this, 0, this.myNotifications.size() - 1);
        }

        public void filter(NotificationType type) {
            this.myType = type;
            this.rebuildList();
        }

        @Override
        public void notificationsAdded(Notification ... notification) {
            if (notification == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsListPanel$NotificationsListModel.notificationsAdded must not be null");
            }
            this.rebuildList();
        }

        @Override
        public void notificationsRemoved(Notification ... notification) {
            if (notification == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsListPanel$NotificationsListModel.notificationsRemoved must not be null");
            }
            this.rebuildList();
        }

        @Override
        public void notificationsRead(Notification ... notification) {
            if (notification == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsListPanel$NotificationsListModel.notificationsRead must not be null");
            }
            this.rebuildList();
        }
    }

    private static class NotificationsListRenderer
    extends JComponent
    implements ListCellRenderer {
        private JTextPane myText;
        private boolean mySelected;
        private boolean myHasFocus;
        private JLabel myIconLabel;
        private Processor<Cursor> myProc;
        private boolean myWasRead;

        private NotificationsListRenderer() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.setOpaque(false);
            this.myIconLabel = new JLabel();
            this.myIconLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.myIconLabel.setOpaque(false);
            this.myText = new JTextPane(){

                @Override
                public void setCursor(Cursor cursor) {
                    super.setCursor(cursor);
                    NotificationsListRenderer.this.onCursorChanged(cursor);
                }
            };
            this.myText.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
            this.myText.setOpaque(false);
            this.myText.setEditable(false);
            this.myText.setEditorKit(UIUtil.getHTMLEditorKit());
            Wrapper.North comp = new Wrapper.North((JComponent)this.myIconLabel);
            comp.setOpaque(false);
            this.add((Component)comp, "West");
            this.add((Component)this.myText, "Center");
        }

        public JTextPane getText() {
            return this.myText;
        }

        public void setCursorHandler(Processor<Cursor> proc) {
            this.myProc = proc;
        }

        public void resetCursorHandler() {
            this.myProc = null;
        }

        public void onCursorChanged(Cursor cursor) {
            if (this.myProc != null) {
                this.myProc.process((Object)cursor);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            GraphicsConfig cfg = new GraphicsConfig(g);
            cfg.setAntialiasing(true);
            RoundRectangle2D.Double shape = new RoundRectangle2D.Double(insets.left, insets.top, bounds.width - 1 - insets.left - insets.right, bounds.height - 1 - insets.top - insets.bottom, 6.0, 6.0);
            if (this.mySelected) {
                g2d.setColor(UIUtil.getListSelectionBackground());
                g2d.fillRect(0, 0, bounds.width, bounds.height);
            }
            g2d.setColor(Color.WHITE);
            g2d.fill(shape);
            Color bgColor = this.getBackground();
            if (this.myWasRead) {
                bgColor = new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 60);
            }
            g2d.setColor(bgColor);
            g2d.fill(shape);
            g2d.setColor(this.myHasFocus || this.mySelected ? this.getBackground().darker().darker() : (this.myWasRead ? this.getBackground() : this.getBackground().darker()));
            g2d.draw(shape);
            cfg.restore();
            super.paintComponent(g);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            LOG.assertTrue(value instanceof Notification);
            Notification notification = (Notification)value;
            this.mySelected = isSelected;
            this.myHasFocus = cellHasFocus;
            this.myText.setText(NotificationsUtil.buildHtml(notification));
            this.myIconLabel.setIcon(NotificationsUtil.getIcon(notification));
            this.myWasRead = NotificationsManagerImpl.getNotificationsManagerImpl().wasRead(notification);
            this.setBackground(NotificationsUtil.getBackground(notification));
            return this;
        }
    }
}

