/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfirmExitDialog
extends OptionsDialog {
    private final boolean myHasTasks;

    public ConfirmExitDialog(boolean hasBgTasks) {
        super(false);
        this.setTitle(ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]));
        this.myHasTasks = hasBgTasks;
        this.init();
    }

    protected Action[] createActions() {
        this.setOKButtonText(CommonBundle.getYesButtonText());
        this.setCancelButtonText(CommonBundle.getNoButtonText());
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    protected boolean isToBeShown() {
        return GeneralSettings.getInstance().isConfirmExit() || this.myHasTasks;
    }

    protected void setToBeShown(boolean value, boolean onOk) {
        GeneralSettings.getInstance().setConfirmExit(value);
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return !this.myHasTasks;
    }

    protected boolean canBeHidden() {
        return !this.myHasTasks;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        String message = ApplicationBundle.message((String)(this.myHasTasks ? "exit.confirm.prompt.tasks" : "exit.confirm.prompt"), (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        JLabel label = new JLabel(message);
        label.setIconTextGap(10);
        label.setIcon(Messages.getQuestionIcon());
        panel.add((Component)label, "Center");
        panel.add(Box.createVerticalStrut(10), "South");
        return panel;
    }
}

