/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.NotNullFunction;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.Nullable;

public abstract class PathMacroMap {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.PathMacroMap");
    protected final Map<String, String> myMacroMap = new LinkedHashMap<String, String>();

    protected PathMacroMap() {
    }

    public void putAll(PathMacroMap pathMacroMap) {
        this.putAll(pathMacroMap.myMacroMap);
    }

    public void putAll(Map<String, String> macroMap) {
        this.myMacroMap.putAll(macroMap);
    }

    public void put(String fromText, String toText) {
        this.myMacroMap.put(fromText, toText);
    }

    public abstract String substitute(String var1, boolean var2);

    public final void substitute(Element e, boolean caseSensitive) {
        this.substitute(e, caseSensitive, false);
    }

    public final void substitute(Element e, boolean caseSensitive, boolean recursively, @Nullable NotNullFunction<Object, Boolean> filter, @Nullable NotNullFunction<Object, Boolean> recursiveFilter) {
        List content = e.getContent();
        for (Object child : content) {
            if (child instanceof Element) {
                Element element = (Element)child;
                this.substitute(element, caseSensitive, recursively, filter, recursiveFilter);
                continue;
            }
            if (child instanceof Text) {
                Text t = (Text)child;
                if (filter != null && !((Boolean)filter.fun((Object)t)).booleanValue()) continue;
                t.setText(recursively || recursiveFilter != null && (Boolean)recursiveFilter.fun((Object)t) != false ? this.substituteRecursively(t.getText(), caseSensitive) : this.substitute(t.getText(), caseSensitive));
                continue;
            }
            if (child instanceof Comment) continue;
            LOG.error("Wrong content: " + child.getClass());
        }
        List attributes = e.getAttributes();
        for (Object attribute1 : attributes) {
            Attribute attribute = (Attribute)attribute1;
            if (filter != null && !((Boolean)filter.fun((Object)attribute)).booleanValue()) continue;
            String value = recursively || recursiveFilter != null && (Boolean)recursiveFilter.fun((Object)attribute) != false ? this.substituteRecursively(attribute.getValue(), caseSensitive) : this.substitute(attribute.getValue(), caseSensitive);
            attribute.setValue(value);
        }
    }

    public final void substitute(Element e, boolean caseSensitive, boolean recursively) {
        this.substitute(e, caseSensitive, recursively, null, null);
    }

    public String substituteRecursively(String text, boolean caseSensitive) {
        return this.substitute(text, caseSensitive);
    }

    public int size() {
        return this.myMacroMap.size();
    }

    protected Set<Map.Entry<String, String>> entries() {
        return this.myMacroMap.entrySet();
    }

    protected Set<String> keySet() {
        return this.myMacroMap.keySet();
    }

    public String get(String key) {
        return this.myMacroMap.get(key);
    }

    public static String quotePath(String path) {
        path = path.replace(File.separatorChar, '/');
        return path;
    }

    public int hashCode() {
        return ((Object)this.myMacroMap).hashCode();
    }
}

